package cn.gtmap.gtc.resource.domain.resource.heatdata;

import java.io.Serializable;

/**
 * .工业用地统计 model (热度图数据)
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2017/12/18 (c) Copyright gtmap Corp.
 */
public class GyydStatModel extends AbstractStatModel implements Serializable {

    private static final long serialVersionUID = -7196971750501204223L;

    /**
     * 营业收入
     */
    private double income;

    /**
     * 分摊土地面积
     */
    private double landArea;

    /**
     * 上缴税金
     */
    private double tax;

    /**
     * 从业人员
     */
    private int employee;

    /**
     * 固定资产投资总额
     */
    private Double invest = 0.0;

    /**
     * 已建成工况仓储用地面积
     */
    private double landWarehouse;


    public double getIncome() {
        return income;
    }

    public void setIncome(double income) {
        this.income = income;
    }

    public double getLandArea() {
        return landArea;
    }

    public void setLandArea(double landArea) {
        this.landArea = landArea;
    }

    public double getTax() {
        return tax;
    }

    public void setTax(double tax) {
        this.tax = tax;
    }

    public int getEmployee() {
        return employee;
    }

    public void setEmployee(int employee) {
        this.employee = employee;
    }

    public double getInvest() {
        return invest;
    }

    public void setInvest(Double invest) {
        this.invest = invest == null ? 0.0 : invest;
    }

    public double getLandWarehouse() {
        return landWarehouse;
    }

    public void setLandWarehouse(double landWarehouse) {
        this.landWarehouse = landWarehouse;
    }

}
