package cn.gtmap.gtc.resource.domain.resource.dto.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Capable;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 *
 *CapableViewBuilder
 *  @data 2018-04-17 14:39:40
 */
public class CapableViewBuilder {

    /**
     * build capableView by capable
     *
     * @param capable
     * @return
     */
    final ResourceViewBuilder resourceViewBuilder = new ResourceViewBuilder();
    public CapableView build(final Capable capable) {
        if (capable == null) {
            return null;
        }else {
            CapableView capableView = new CapableView();
            capableView.setType(capable.getType());
            capableView.setCode(capable.getCode());
            capableView.setInfo(capable.getInfo());
            capableView.setUrl(capable.getUrl());
            capableView.setTitle(capable.getTitle());
            capableView.setStatus(capable.getStatus());
            capableView.setId(capable.getId());
            capableView.setResourceView(resourceViewBuilder.build(capable.getResource()));
            return capableView;
        }
    }

    /**
     * build CapableViews by capables
     *
     * @param capables
     * @return
     */
    public List<CapableView> build(final List<Capable> capables) {
        if (capables == null) {
            return new ArrayList<>();
        }else {
            List<CapableView> capableViewList = new ArrayList<>();
            for (Capable capable : capables) {
                capableViewList.add(build(capable));
            }
            return capableViewList;
        }
    }
}
