package cn.gtmap.gtc.resource.clients.tpl;

import cn.gtmap.gtc.resource.domain.resource.dto.tpl.Tpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * .TplClient
 *
 * @author <a href="mailto:yingxiufeng@gtmap.cn">alex.y</a>
 * @version v1.0, 2018/4/27 (c) Copyright gtmap Corp.
 */
@FeignClient(name="${app.services.resource-tpl-app:resource-tpl-app}")
@RequestMapping("/rest/tpl")
public interface TplClient {
    /**
     * find one by id
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/find/{id}")
    Tpl getOne(@PathVariable("id") String id);

    /**
     * 查询tpl并过滤content
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/queryTplByIdExceptContent")
    Tpl queryTplByIdExceptContent(@RequestParam("id") String id);

    /**
     * 保存模板配置
     *
     * @param tpl
     * @return
     */
    @PostMapping(value = "/save")
    Tpl saveTplConfig(@RequestBody Tpl tpl);

    /**
     * find all
     *
     * @return
     */
    @GetMapping(value = "/all")
    List<Tpl> fetchAll();

    /**
     * find all except content
     *
     * @return
     */
    @GetMapping(value = "/allExceptContent")
    List<Tpl> fetchAllExceptContent();

    /**
     * 分页获取 tpl
     *
     * @param pageable
     * @return
     */
    @RequestMapping(value = "/page")
    Page<Tpl> getPage(Pageable pageable);

    /**
     * delete by id
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/delete/{id}")
    boolean delete(@PathVariable("id") String id);

    /**
     * query by regionCode
     *
     * @param regionCode
     * @return
     */
    @PostMapping(value = "/queryTplListByRegionCode")
    List<Tpl> queryTplListByRegionCode(@RequestParam(name = "regionCode", required = false) String regionCode);

    /**
     * query by tplId
     *
     * @param tplId
     * @return
     */
    @PostMapping(value = "/query/queryTplRoleRefsByTplId")
    List<String> queryTplRoleRefsByTplId(@RequestParam(name = "tplId") String tplId);

    /**
     * query by roleId
     *
     * @param roleId
     * @return
     */
    @PostMapping(value = "/query/queryTplRoleRefsByRoleId")
    List<String> queryTplRoleRefsByRoleId(@RequestParam(name = "roleId") String roleId);

    /**
     * associate menuId and roles
     *
     * @param tplId
     * @param roles
     * @return
     */
    @PostMapping(value = "/associate/associateTplAndRoles")
    public String associateTplAndRoles(@RequestParam(name = "tplId") String tplId,
                                       @RequestParam(name = "roleIds", required = false) String roles);


    /**
     * 根据id 和sr 查询tpl
     *
     * @param roleId 用户角色 id
     * @param sr     坐标系标识
     * @return
     */
    @PostMapping(value = "/queryTplbyId/{roleId}/{sr}")
    List<Tpl> queryTplbyId(@PathVariable(name = "roleId") String roleId,
                           @PathVariable(name = "sr") String sr);

    /**
     * 根据id 和sr 查询tpl
     *
     * @param roleId 用户角色 id
     * @param sr     坐标系标识
     * @return
     */
    @PostMapping(value = "/queryTplbyRoleIdAndSr")
    String queryTplbyRoleIdAndSr(@RequestParam(name = "roleId") String roleId,
                                 @RequestParam(name = "sr") String sr);

    /**
     * 查询tpl并过滤content
     * @param ids
     * @return
     */
    @GetMapping(value = "/queryTplsByIdExceptContent")
    List<Tpl> queryTplsByIdExceptContent(@RequestParam("ids") List<String> ids);

}

