package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.Theme.ThemeData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * theme client
 *
 * @author zhaozhuyi
 * @create 2019年9月24日16:37:32
 **/
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/themeData")
public interface ThemeClient {

    @GetMapping(value = "/all")
    List<ThemeData> fetchAll();

    @GetMapping(value = "/queryThemeData")
    List<ThemeData> queryThemeDataFilter(@RequestParam(name = "themeId",required = false) String themeId,
                                         @RequestParam(name = "themeYear", required = false) String themeYear,
                                         @RequestParam(name = "themeLevel", required = false) String themeLevel);

    @PostMapping(value = "/save")
    ThemeData saveThemeData(@RequestBody ThemeData themeData);
}
