package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Server;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.Map;

@FeignClient("resource-core")
@RequestMapping("/resource")
public interface ServerClient {
    @RequestMapping("/query/server")
    Page<Server> findServer(Pageable pageable);

    @PostMapping("/save/server")
    Boolean saveService(Server server);

    @RequestMapping("/del/server")
    Boolean delManageServer(@RequestParam(name = "ids", required = true) String ids);

    @PostMapping("/update/server")
    boolean updateServer(@RequestBody Server server);

    @GetMapping("/queryList/server")
    Map queryManageServer(@RequestParam(name = "condition", required = true) String condition);

    @PostMapping(value = "/upload/server", produces = MediaType.APPLICATION_JSON_UTF8_VALUE, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    Boolean uploadFile(@RequestPart(name = "file") MultipartFile file);

    @RequestMapping("/findByIp/server")
    Server findByIp(@RequestParam("ip") String ip);

}
