package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.statistic.PercentDTO;
import cn.gtmap.gtc.resource.domain.resource.dto.statistic.ResourceOnlineDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author <a href="mailto:yangyang@gtmap.cn">yangyang</a>
 * @version 1.0.2020-4-13
 * @description
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/rest/resources/statistic")
public interface ResourceStatisticClient {

    /**
     * @param
     * @return
     * @description 类型分类统计在线离线
     */
    @GetMapping("/catalog/online")
    ResourceOnlineDTO onlineStatistic(@RequestParam(name = "catalogCode", required = false) String catalogCode);

    /**
     * @param
     * @return
     * @description 按照不同维度统计资源
     */
    @GetMapping("/dimension")
    List<PercentDTO> dimensionStatistic(@RequestParam(name = "dimension") String dimension);
}
