package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceLayer;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.ResourceView;
import cn.gtmap.gtc.resource.domain.resource.metadata.ResourceUserRef;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * resource client
 *
 * @author zhuzhifeng
 * @create 2018年11月15日16:37:32
 **/
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/resourceMap")
public interface ResourceMapClient {

    /**
     * 根据资源目录和行政区查询资源
     */
    @RequestMapping("/query/condition2")
    List<ResourceView> condition2(@RequestParam(name = "catalog", required = false) String catalogId,
                                  @RequestParam(name = "type", required = false) String type,
                                  @RequestParam(name = "region", required = false) String regionCode);
    @PostMapping("/query/queryMapResourceByCondition")
    Page<ResourceLayer> queryMapResourceByCondition(
            @RequestParam(name = "keyword", required = false) String keyword,
            @RequestParam(name = "catalogId", required = false) String catalogId,
            @RequestParam(name = "type", required = false) String type,
            Pageable pageable);

    @PostMapping("/query/findResourcesListByUserId")
    List<ResourceView> findResourcesListByUserId(@RequestParam(name = "userId", required = false) List<String> userId);

    @RequestMapping("/save/saveResourceAndUserRef")
    Iterable<ResourceUserRef> saveResourceAndUserRef(@RequestParam(name = "userId", required = false) String userId,
                                                     @RequestParam(name = "resourceIds", required = false) List<String> resourceIds);

    @PostMapping("/query/findResourceIdByCatalogId")
    List<String> findResourceIdByCatalogId(@RequestParam(name = "catalogId", required = false) String catalogId);
}
