package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.geojson.Geojson;
import cn.gtmap.gtc.resource.domain.resource.dto.resource.*;
import cn.gtmap.gtc.resource.domain.resource.metadata.*;
import cn.gtmap.gtc.resource.domain.workflow.HistoricTaskDesc;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * resource client
 *
 * @author monarchCheng
 * @create 2017-11-14 10:47
 **/
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/resource")
public interface ResourceClient {
    /**
     * 注册资源
     *
     * @return
     */
    @RequestMapping("/register")
    String register();

    /**
     * 保存resource
     *
     * @param resourceView
     * @return
     */
    @PostMapping("/save")
    String saveResource(@RequestBody ResourceView resourceView);

    /**
     * 批量保存resource
     *
     * @param resourceView
     * @return
     */
    @PostMapping("/saveMultiResource")
    String saveMultiResource(@RequestBody ResourceView resourceView);

    /**
     * 更新resource
     *
     * @param resourceView
     * @return
     */
    @PostMapping("/update")
    String updateResource(@RequestBody ResourceView resourceView);

    /**
     * 删除resource
     *
     * @param id
     * @return
     */
    @RequestMapping("/deleteResource/{id}")
    public Boolean deleteResource(@PathVariable(name = "id") String id);

    /**
     * 删除关联resource
     *
     * @param id
     * @return
     */
    @RequestMapping("/deleteResourceRef/{id}")
    public Map deleteResourceRef(@PathVariable(name = "id") String id);

    /**
     * 删除资源能力
     *
     * @param id
     * @return
     */
    @RequestMapping("/deleteResourceCapables/{id}")
    public Boolean deleteResourceCapables(@PathVariable(name = "id") String id);

    /**
     * 创建申请资源流程
     *
     * @param resourceApply
     * @return
     */
    @PostMapping("/apply")
    Boolean applyResource(ResourceApply resourceApply);


    /**
     * 转发资源申请
     *
     * @param taskId
     * @param resourceApply
     * @return
     */
    @RequestMapping("/transfer/task/{taskId}")
    String transferProcess(@PathVariable(name = "taskId") String taskId, @RequestBody ResourceApply resourceApply);


    /**
     * 查询申请信息
     *
     * @param taskId
     * @return
     */
    @RequestMapping("/query/applyData/{taskId}")
    ResourceApply queryApply(@PathVariable(name = "taskId") String taskId);

    /**
     * 查询申请信息
     *
     * @param businessKey
     * @return
     */
    @GetMapping("/query/applyData/key/{businessKey}")
    ResourceApply queryApplyByKey(@PathVariable(name = "businessKey") String businessKey);


    /**
     * 审核资源申请
     *
     * @param resourceApply
     */
    @PostMapping("/check/apply")
    public Boolean checkApply(ResourceApply resourceApply);

    /**
     * 驳回
     *
     * @param resourceApply
     */
    @PostMapping("/back/apply")
    public Boolean backApply(ResourceApply resourceApply);

    /**
     * 根据流程的ID获取历史任务及其局部的属性
     */
    @RequestMapping("/find/history/processHistory/{processId}")
    public List<HistoricTaskDesc> queryProcessHistory(@PathVariable(name = "processId") String processId);

    /**
     * 查询目录资源
     *
     * @param catalogId
     * @param pageable
     * @return
     */
    @RequestMapping("/catalog/resources/{catalogId}")
    Page<ResourceView> findCatalogResources(@PathVariable(name = "catalogId") String catalogId, Pageable pageable);


    /**
     * 查询资源
     *
     * @return
     */
    @RequestMapping("/getProcessPage")
    ResourceView getProcessPage(Pageable pageable);


    /**
     * 根据id查询资源
     *
     * @param id
     * @return
     */
    @RequestMapping("/id/{id}")
    ResourceView queryResourceById(@PathVariable(name = "id") String id);

    /**
     * 获取坐标系对象
     *
     * @param wkid
     * @return
     */
    @RequestMapping("/getSpatialCoverageRefByWkid/{wkid}")
    SpatialCoverageRef getSpatialCoverageRefByWkid(@PathVariable(name = "wkid") int wkid);

    /**
     * 查询capables
     *
     * @param id
     * @return
     */
    @RequestMapping("/{id}/capables")
    List<CapableView> queryResourceCapables(@PathVariable(name = "id") String id);

    @RequestMapping("/{id}/getCapableById")
    CapableView getCapableById(@PathVariable(name = "id") String id);

    @RequestMapping("/{id}/getResourceByCapable")
    ResourceView getResourceByCapable(@PathVariable(name = "id") String id);

    /**
     * 查询用戶是否有權限
     *
     * @param id
     * @return
     */
    @RequestMapping("/{id}/ResourceRights")
    Boolean getRightsByResource(@PathVariable(name = "id") String id);

    @RequestMapping("/{id}/getRateById")
    int getRateById(@PathVariable(name = "id") String id);

    /**
     * 获取关联资源
     *
     * @param id
     * @return
     */
    @RequestMapping("/{id}/getResourceRef")
    List<ResourceRefView> getResourceRef(@PathVariable(name = "id") String id);

    /**
     * 查询capables original
     *
     * @param id
     * @return
     */
    @RequestMapping("/{id}/capables/original")
    List<Capable> queryResourceCapablesOriginal(@PathVariable(name = "id") String id);

    /**
     * 查询capable url
     *
     * @param id
     * @param capableType
     * @return
     */
    @RequestMapping("/px/{id}/{capableType}/url")
    String queryResourceCapableUrls(@PathVariable(name = "id") String id, @PathVariable(name = "capableType") String capableType);

    /**
     * 根据发布者查询资源
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/query/publisher")
    Page<ResourceView> queryResourceByPublisher(@RequestParam(name = "keyword", required = false) String keyword, Pageable pageable);

    /**
     * 根据类型查询资源
     *
     * @param type
     * @return
     */
    @RequestMapping("/query/type/{type}")
    Page<ResourceView> queryResourcesByType(@PathVariable(name = "type") String type, Pageable pageable);

    /**
     * 根据控件覆盖范围查询资源
     *
     * @param spatialCoverage
     * @return
     */
    @RequestMapping("/query/spatialCoverage")
    List<ResourceView> queryResourcesBySpatialCoverage(@RequestBody SpatialCoverageProperty spatialCoverage);

    /**
     * 模糊查询资源
     *
     * @param keyword
     * @param title
     * @param start
     * @param end
     * @param pageable
     * @return
     */
    @PostMapping("/query/condition")
    Page<ResourceView> queryResourceByCondition(@RequestParam(name = "keyword", required = false) String keyword,
                                                @RequestParam(name = "title", required = false) String title,
                                                @RequestParam(name = "start", required = false) Date start,
                                                @RequestParam(name = "end", required = false) Date end,
                                                Pageable pageable);

    /**
     * 模糊查询资源
     *
     * @param title
     * @return
     */
    @PostMapping("/query/queryResourceByTitle")
    List<ResourceView> queryResourceByTitle(@RequestParam(name = "title", required = false) String title);


    /**
     * 分页查询资源
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/query/all")
    Page<ResourceView> findResources(Pageable pageable);

    /**
     * 查询所有capable
     *
     * @return
     */
    @RequestMapping("capable/all")
    List<MIMEType> findAllCapableType();

    /**
     * 根据类型名称查询capable
     *
     * @param name
     * @return
     */
    @RequestMapping("capable/{name}")
    MIMEType findCapableType(@PathVariable(name = "name") String name);


    /**
     * 查询申请信息
     *
     * @param id
     * @return
     */
    @GetMapping("/query/queryApplyById/{id}")
    ResourceApply queryApplyById(@PathVariable(name = "id") String id);

    /**
     * 根据资源目录和行政区查询资源
     */
    @RequestMapping("/query/condition2")
    List<ResourceView> condition2(@RequestParam(name = "catalog", required = false) String catalogId,
                                  @RequestParam(name = "type", required = false) String type,
                                  @RequestParam(name = "region", required = false) String regionCode);


    /**
     * 我的申请（未审核）AuthorityClient.java
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/history/process/unchecked")
    Page<ResourceApply> applyIsendAndUnCheck(@RequestParam(name = "keyword", required = false) String keyword, Pageable pageable);

    /**
     * 我的申请（已审核）
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/history/process/checked")
    Page<ResourceApply> applyIsendAndChecked(@RequestParam(name = "keyword", required = false) String keyword, Pageable pageable);

    /**
     * 我的申请（已审核,未通过）
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/history/process/turnBack")
    public Page<ResourceApply> applyTurnBack(@RequestParam(name = "keyword", required = false) String keyword, Pageable pageable);

    /**
     * 我的审批（未审批）
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/query/active/tasks/undo")
    Page<ResourceApply> applyINeedCheck(@RequestParam(name = "keyword", required = false) String keyword, Pageable pageable);

    /**
     * 我的审批（已审批）
     *
     * @param pageable
     * @return
     */
    @RequestMapping("/query/active/tasks")
    Page<ResourceApply> applyIChecked(@RequestParam(name = "keyword", required = false) String keyword, Pageable pageable);

    /**
     * query Page Resource By Condition
     *
     * @param catalogId
     * @param type
     * @param regionCode
     * @param pageable
     * @return
     */
    @PostMapping("/query/condition2/pageable")
    Page<ResourceView> queryPageResourceByCondition2(@RequestParam(name = "catalog", required = false) String catalogId,
                                                     @RequestParam(name = "type", required = false) String type,
                                                     @RequestParam(name = "region", required = false) String regionCode,
                                                     @RequestParam(name = "keyword", required = false) String keyword,
                                                     @RequestParam(name = "wkid", required = false) Integer wkid,
                                                     @RequestParam(name = "fwlx", required = false) String fwlx,
                                                     Pageable pageable);

    /**
     * query Page Resource By Condition
     *
     * @param catalogId
     * @param type
     * @param regionCode
     * @param pageable
     * @return
     */
    @PostMapping("/query/condition3/pageable")
    Page<ResourceView> queryPageResourceByCondition3(@RequestParam(name = "catalog", required = false) String catalogId,
                                                     @RequestParam(name = "type", required = false) String type,
                                                     @RequestParam(name = "region", required = false) String regionCode,
                                                     @RequestParam(name = "keyword", required = false) String keyword,
                                                     @RequestParam(name = "wkid", required = false) Integer wkid,
                                                     @RequestParam(name = "fwlx", required = false) String fwlx,
                                                     Pageable pageable);

    /**
     * query Page Resource By Condition
     *
     * @param catalogId
     * @param type
     * @param regionCode
     * @param pageable
     * @return
     */
    @PostMapping("/query/condition4/pageable")
    Page<ResourceView> queryPageResourceByCondition4(@RequestParam(name = "catalog", required = false) String catalogId,
                                                     @RequestParam(name = "department", required = false) String departmentId,
                                                     @RequestParam(name = "type", required = false) String type,
                                                     @RequestParam(name = "region", required = false) String regionCode,
                                                     @RequestParam(name = "keyword", required = false) String keyword,
                                                     @RequestParam(name = "wkid", required = false) Integer wkid,
                                                     @RequestParam(name = "fwlx", required = false) String fwlx,
                                                     @RequestParam(name = "dataResource", required = false) String dataResource,
                                                     Pageable pageable);

    @RequestMapping("/grantAthority")
    public Boolean grantAthority(@RequestParam(name = "user", required = false) String user,
                                 @RequestParam(name = "role", required = false) String role,
                                 @RequestParam(name = "departments", required = false) String departments,
                                 @RequestParam(name = "resourceId", required = false) String resourceId,
                                 @RequestParam(name = "capable", required = false) String capable);

    @RequestMapping("/backAthority")
    public Boolean backAthority(@RequestParam(name = "id", required = false) String id);

    @RequestMapping("/query/getSpatialCoverageRefList")
    public List<SpatialCoverageRef> getSpatialCoverageRefList();

    @PostMapping("/query/queryMapResourceByCondition")
    Page<ResourceLayer> queryMapResourceByCondition(
            @RequestParam(name = "keyword", required = false) String keyword,
            @RequestParam(name = "catalogId", required = false) String catalogId,
            @RequestParam(name = "type", required = false) String type,
            Pageable pageable);

    @RequestMapping("/findCapableByResId")
    public List<CapableView> findCapableByResId(@RequestParam(name = "id") String id);

    /**
     * 查询资源是否注册
     *
     * @param urls
     * @return
     */
    @GetMapping("/query/synIsResgisteredByUrl")
    List<Boolean> synIsResgisteredByUrl(@RequestParam(name = "urls") String urls);

    /**
     * 资源同步
     *
     * @param resourceViews
     * @return
     */
    @PostMapping("/synResources")
    List<CatalogView> synResources(@RequestBody ResourceView[] resourceViews);

    /**
     * 保存元数据管理信息
     *
     * @param manageMatadata
     * @return
     */
    @PostMapping("/save/manageMatadata")
    boolean saveManageMatadata(@RequestBody ManageMatadata manageMatadata);

    /**
     * 更新元数据管理信息
     *
     * @param manageMatadata
     * @return
     */
    @PostMapping("/update/manageMatadata")
    boolean updateMatadata(@RequestBody ManageMatadata manageMatadata);

    /**
     * 根据id删除元数据管理信息
     *
     * @param ids
     * @return
     */
    @RequestMapping("/del/manageMatadata")
    boolean delManageMatadata(@RequestParam(name = "ids", required = true) String ids);

    /**
     * 根据查询条件查询元数据信息
     *
     * @param condition
     * @return
     */
    @GetMapping("/query/manageMatadatas")
    List<ManageMatadata> queryManageMatadatas(@RequestParam(name = "condition", required = true) String condition);


    @GetMapping("/queryResByIds")
    List<Resource> queryResByIds(@RequestParam(name = "ids") String ids);

    /**
     * 获取所有元数据信息
     *
     * @return
     */
    @GetMapping("/findAll/manageMatadatas")
    List<ManageMatadata> findAllManagemataData();

    @PostMapping("/saveResLogParam")
    public String saveResLogParam(@RequestBody Map params);

    @PostMapping("/saveGeoJson")
    public Map saveGeoJson(@RequestBody Map params);

    @RequestMapping("/queryByServiceId")
    Geojson queryByServiceId(@RequestParam(name = "serviceId", required = false) String serviceId);

}
