package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.ResAccess;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 1 * @Author: zgl
 * 2 * @Date: 2020/3/24 14:32
 * 3
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/res/access")
public interface ResAccessClient {

    @GetMapping("/get/page")
    Page<ResAccess> getResAccessByPage(@RequestParam(name = "title") String title, Pageable pageable);

    @PostMapping("/save")
    String save(@RequestBody ResAccess resAccess);

    @PostMapping("/save/batch")
    String save(@RequestBody List<ResAccess> resAccessList);

    @RequestMapping("/delete")
    public Boolean delete(@RequestParam(name = "id") String id);

    @RequestMapping("/query/id")
    public ResAccess queryById(@RequestParam(name = "id") String id);

    @RequestMapping("/query/ids")
    public List<ResAccess> queryByIds(@RequestParam(name = "ids") String ids);

}
