package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.*;
import cn.gtmap.gtc.resource.domain.resource.metadata.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * resource client
 *
 * @author monarchCheng
 * @create 2017-11-14 10:47
 **/
@FeignClient(name = "${app.services.resource-core:resource-core}")
@RequestMapping("/res/v2")
public interface NewResClient {

    @PostMapping("/save/res")
    public Map saveRes(@RequestBody ResourceView resourceView);

    @PostMapping("/save/multi/res")
    public Map saveMultiRes(@RequestBody List<ResourceView> resourceViewList);

    @PostMapping("/query/res/condition")
    public Page<ResourceView> queryResCondition(@RequestBody Map params);

    @RequestMapping("/query/dicts")
    public Map queryDicts(@RequestParam(name = "catalog", required = false) String catalog,
                          @RequestParam(name = "serverCatalog", required = false) String serverCatalog,
                          @RequestParam(name = "department", required = false) String department,
                          @RequestParam(name = "resDate", required = false) String resDate,
                          @RequestParam(name = "layerDate", required = false) String layerDate,
                          @RequestParam(name = "dataSources", required = false) String dataSources,
                          @RequestParam(name = "nd", required = false) String nd,
                          @RequestParam(name = "keywords", required = false) String keywords,
                          @RequestParam(name = "spatialCoverage", required = false) String spatialCoverage,
                          @RequestParam(name = "permission", required = false) String permission);

    @PostMapping("/apply/res")
    public Map applyRes(@RequestBody Map map);

    @RequestMapping("/query/apply")
    public Page<Map> queryApply(@RequestParam(name = "keyword", required = false) String keyword,
                                @RequestParam(name = "applyState") String applyState, Pageable pageable);

    @PostMapping("/approval")
    public Map approval(@RequestBody List<Map> mapList);

    @PostMapping("/back")
    public Map back(@RequestBody Map map);

    @RequestMapping("/query/approval")
    public Page<Map> getApprovalList(@RequestParam(name = "keyword", required = false) String keyword,
                                     @RequestParam(name = "applyState") String applyState, Pageable pageable);

    @PostMapping("/authorize/res")
    public Map authorizeRes(@RequestBody Map map);

    @GetMapping("/query/res")
    ResourceView queryResById(@RequestParam(name = "id") String id);

    @GetMapping("/token/url")
    String queryTokenUrl(@RequestParam(name = "capableType") String capableType, @RequestParam(name = "capableId") String capableId, @RequestParam(name = "resId") String resId);

    @GetMapping("/query/apply/taskId")
    public Map queryApplys(@RequestParam(name = "taskId") String taskId);

    @GetMapping("/query/his/taskId")
    public List<ApplyRefHis> queryApplyHis(@RequestParam(name = "taskId") String taskId);

    @PostMapping("/del/res")
    public Map delRes(@RequestBody Map map);
}
