package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Keyword;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * Created by zgl on 2017-12-02.
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/keyword")
public interface KeywordClient {

    /**
     * 查询关键字
     * @param strContent
     * @return
     */
    @GetMapping("/findKeywordByStr")
    public List<Keyword> findKeywordByStr(@RequestParam(name = "strContent", required = false) String strContent);

    @PostMapping("/save")
    public String saveKeyWord(@RequestBody Keyword keyword);

    @RequestMapping("/delete/{id}")
    public Boolean deleteKeyword(@PathVariable(name = "id") String id);

    @RequestMapping("/query/top10")
    public List<Keyword> queryTopTen();

    @RequestMapping("/query")
    public List<Map> query();
}
