package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.dto.resource.CapableView;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * Created by Fjj on 2018/1/11.
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/capable")
public interface CapableClient {

    /**
     * 根据资源名称查询对应能力
     *
     * @param title
     * @param pageable
     * @return
     */
    @GetMapping("/queryByResourceTitle")
    Page<CapableView> queryByResourceTitle(@RequestParam(name = "title") String title, Pageable pageable);


    @GetMapping("/getCapableViewByTypes")
    List<CapableView> getCapableViewByTypes(@RequestParam(name = "capableTypeStr") String capableTypeStr);


    @RequestMapping("/selectByResType")
    List<CapableView> selectByResType();

    @PostMapping("/getCapableViewByUrl")
    List<CapableView> getCapableViewByUrl(@RequestParam(name = "url") String url);

    @GetMapping("/getCapableTypeByIds")
    List<String> getCapableTypeByIds(@RequestParam(name = "ids") String ids);
}
