package cn.gtmap.gtc.resource.clients.resource;

import cn.gtmap.gtc.resource.domain.resource.metadata.Announcement;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * Created by Administrator on 2018/3/27.
 */
@FeignClient(name="${app.services.resource-core:resource-core}")
@RequestMapping("/announcement")
public interface AnnouncementClient {
    @GetMapping("/getAnnouncementByPage")
    Page<Announcement> getAnnouncementByPage(@RequestParam(name = "title") String title, Pageable pageable);

    @GetMapping("/getAnnouncementByPublisher")
    Page<Announcement> getAnnouncementByPublisher(@RequestParam(name = "title") String title, @RequestParam(name = "username") String username, Pageable pageable);

    @PostMapping("/saveAnnouncement")
    Boolean saveAnnouncement(@RequestBody Announcement announcement);

    @PostMapping("/updateAnnouncementSort")
    Boolean updateAnnouncementSort(@RequestParam(name="ids") String ids);

    @RequestMapping("/deleteAnnouncement")
    public Boolean deleteAnnouncement(@RequestParam(name = "id") String id);

    @RequestMapping("/findAnnouncement")
    public Announcement findAnnouncement(@RequestParam(name = "id") String id);

    @RequestMapping("/updateAnnouncement")
    public boolean updateAnnouncement(@RequestBody Announcement announcement);

    @RequestMapping("/findMaxWeight")
    public Integer findMaxWeight();

    @RequestMapping("/findAnnouncementsByTop")
    public List<Announcement> findAnnouncementsByTop();
}
