layui.define(function (exports) {
    'use strict';
    var apiRootURL = '/api';
    var categoryCenterURL = apiRootURL + '/category-center/v1';
    var modelCenterURL = apiRootURL + '/model-center/v1';

    return exports('settings', {
        apiURLs: {
            categoryCenter: {
                domainCategory: categoryCenterURL + '/domain-categories',
                domainResource: categoryCenterURL + '/domain-resources'
            },
            modelCenter: {
                databaseConnection: modelCenterURL + '/database-connections',
                getTablesURL: function (dbCnnName) {
                    return this.databaseConnection + '/' + dbCnnName + '/tables';
                },
                getTableFieldsURL: function(dbCnnName, tableName){
                    return this.getTablesURL(dbCnnName) + '/' + tableName + '/fields';
                },
                modelDef: modelCenterURL + '/model-definitions',
                model: modelCenterURL + '/models',
                queryDef: modelCenterURL + '/query-definitions',
                query: modelCenterURL + '/queries',
                project: modelCenterURL + '/models/Project'
            }
        }
    });
});