layui.use(['gtc', 'gtc-data-edit', 'settings'], function () {
    'use strict';
    // configurations
    var QUERY_RESULT_FULL_CSS_CLS = 'layui-col-xs12';
    var QUERY_RESULT_HALF_CSS_CLS = 'layui-col-xs7';

    var settings = layui.settings;
    var gtc = layui.gtc;
    var QueryMeta = gtc.QueryMeta;

    var QueryMetaTree = class_QueryMetaTree_extends(gtc.DomainResourceTree);
    var AnonymousQuery = class_AnonymousQuery();
    return new QueryMetaTree();

    function class_QueryMetaTree_extends(DomainResourceTree) {
        function Constructor() {
            DomainResourceTree.call(this, 'query-tree', 'query-edit', 'save-query-edit', 'cancel-query-edit');
            this.queryPreviewer$ = $('#query-previewer');
            this.queryParams$ = $('#query-parameters');
            this.queryResult$ = $('#query-result');
            this.queryStatement$ = $('#query-statement');
            this.queryMetaQueryStatement$ = $('#query-queryStatement');

            var _this = this;
            $('#preview-query').click(function () {
                _this.previewQuery();
            });
            $('#query-back').click(function () {
                _this.backToPreview();
            });
            $('#query-execute').click(function () {
                _this.executeQuery();
            });
            initDbConnOptions();
        }

        var parentProto = DomainResourceTree.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;
        override.updateFormFromData = function (detached) {
            parentProto.updateFormFromData.call(this, detached);
            $('#query-queryName').attr('disabled', !detached);
        };
        override.refreshPreview = function (treeNode) {
            var data = treeNode._data;
            if (!data) {
                this.treePreviewer$.hide();
                return;
            }
            var _this = this;
            setTimeout(function () {
                if (treeNode.isParent) {
                    _this.showNodeDetail('业务分类', [
                        {key: 'ID：', value: data.id},
                        {key: '名称：', value: data.name},
                        {key: '描述：', value: data.description}
                    ]);
                } else {
                    try {
                        var queryDef = gtc.getData(settings.apiURLs.modelCenter.queryDef + '/' + data.key);
                    } catch (e) {
                        queryDef = new QueryMeta();
                    }
                    _this.showNodeDetail('查询定义', [
                        {key: '名称：', value: queryDef.queryName},
                        {key: '描述：', value: queryDef.description},
                        {key: '查询语言：', value: queryDef.queryLanguage},
                        {key: '数据库连接：', value: queryDef.databaseConnectionName}
                    ]);
                }
            });
        };
        override.getEditableDataConstructor = function () {
            return QueryMeta;
        };
        override.getEditableDataTypeDescription = function () {
            return '查询';
        };
        override.getResourceTypeName = function () {
            return 'query';
        };
        override.getEditableDataURL = function () {
            return settings.apiURLs.modelCenter.queryDef;
        };

        proto.previewQuery = function () {
            this.queryResult$
                .removeClass(QUERY_RESULT_HALF_CSS_CLS).removeClass(QUERY_RESULT_FULL_CSS_CLS)
                .val('');
            this.queryStatement$.val(this.queryMetaQueryStatement$.val());

            var queryParams = parseQueryParams(this.queryMetaQueryStatement$.val());
            if (queryParams.length) {
                var queryParams$ = this.queryParams$.find('tbody')
                    .empty();
                queryParams.forEach(function (queryParam) {
                    $('<tr>' +
                        '  <td>' + queryParam + '</td>' +
                        '  <td><input id="query-param-' + queryParam + '" title="' + queryParam + '"></td>' +
                        '</tr>')
                        .appendTo(queryParams$);
                });
                this.queryParams$.show();
                this.queryResult$.addClass(QUERY_RESULT_HALF_CSS_CLS);
            } else {
                this.queryParams$.hide();
                this.queryResult$.addClass(QUERY_RESULT_FULL_CSS_CLS);
                this.executeQuery();
            }
            this.edit$.hide();
            this.queryPreviewer$.show();
        };

        proto.backToPreview = function () {
            this.queryPreviewer$.hide();
            this.edit$.show();
        };

        proto.executeQuery = function () {
            var anonymousQuery = new AnonymousQuery(this.editableData);
            this.queryParams$.find('tbody tr input[id^=query-param-]')
                .each(function (i, input) {
                    setAnonymousQueryPramsByInput(anonymousQuery, input);
                });

            var _this = this;
            setTimeout(function () {
                try {
                    var widget = gtc.showWaiting('正在执行查询');
                    var reply = gtc.postData(settings.apiURLs.modelCenter.query, anonymousQuery);
                    _this.queryResult$.val(JSON.stringify(reply.data, null, 2));
                } catch (e) {
                    gtc.showError('查询执行失败');
                } finally {
                    gtc.hideWaiting(widget);
                }
            });
        };

        return Constructor;

        function initDbConnOptions() {
            try {
                var reply = gtc.getData(settings.apiURLs.modelCenter.databaseConnection);
                var dbConnSelect$ = $('#query-databaseConnectionName');
                var data = reply.data || [];
                [].forEach.call(data, function (dbConn) {
                    $('<option value="' + dbConn.name + '">' + dbConn.description + '</option>')
                        .appendTo(dbConnSelect$);
                });
            } catch (e) {
                gtc.showError('读取数据库连接列表失败');
            }
        }

        function parseQueryParams(statement) {
            if (!statement || !statement.length) return [];

            var paramNames = statement
                .replace(/".*"/g, '-')
                .replace(/'.*'/g, '-')
                .match(/:[A-Za-z_]\w+/g);
            if (!paramNames || !paramNames.length) return [];

            var dict = {};
            paramNames.forEach(function (paramName) {
                dict[paramName] = true;
            });
            return Object.keys(dict)
                .map(function (key) {
                    return key.slice(1);
                });
        }

        function setAnonymousQueryPramsByInput(anonymousQuery, input) {
            var REAL_REGEX = /^(0\.?|-?[1-9][0-9]{0,19}\.?|-?0?\.[0-9]{0,20}|-?[1-9][0-9]{0,19}\.[0-9]{0,20})$/;
            var STR_LITERAL_REGEX = /^'.*'$/;

            var input$ = $(input);
            var value = input$.val();
            if (value === '') {
                value = null;
            } else if (value === 'true') {
                value = true;
            } else if (value === 'false') {
                value = false;
            } else if (value.match(STR_LITERAL_REGEX)) {
                value = value.slice(1, value.length - 2);
            } else if (value.match(REAL_REGEX)) {
                value *= 1;
            }
            anonymousQuery.parameter(input$.attr('title'), value);
        }
    }

    function class_AnonymousQuery() {
        function Constructor(queryMeta) {
            if (!queryMeta) {
                queryMeta = {};
            }
            this.statement = queryMeta.queryStatement || null;
            this.language = queryMeta.queryLanguage || null;
            this.parameters = null;
            this.databaseConnectionName = queryMeta.databaseConnectionName || null;
        }

        var proto = Constructor.prototype;
        proto.parameter = function (key, value) {
            if (this.parameters == null) {
                this.parameters = {};
            }
            if (value === undefined) return this.parameters[key];

            this.parameters[key] = value;
            return this;
        };

        return Constructor;
    }
});