layui.use(['gtc', 'gtc-data-edit', 'settings'], function () {
    'use strict';
    // configurations
    var SELECTED_ELM_CLS = 'selected';
    var DBCNN_TREE_ELM_ID = 'project-tree';
    var DBCNN_TAB_ELM_ID = 'project-table';

    var TITLE_ELM_ID = 'title';
    var CRUMB_ELM_ID = 'crumb-2';

    var settings = layui.settings;
    var gtc = layui.gtc;

    var ProjectEdit = class_ProjectEdit_extends(gtc.DataEdit);
    return new ProjectEdit();

    function Project() {
        this.description = this.name = this.id = null;
    }

    function class_ProjectEdit_extends(DataEdit) {
        var TR_CLASS_READONLY = 'readonly';

        function Constructor() {
            DataEdit.call(this, 'project-edit', 'save-project-edit', 'cancel-project-edit');

            this.tree$ = $('#' + DBCNN_TREE_ELM_ID);
            this.insertion$ = $('#project-insertion');
            this._cachedData = null;
            this._dataTableCols = [[
                {field: 'name', title: '名称', edit: 'text', minWidth: 150},
                {field: 'description', title: '描述', edit: 'text', minWidth: 150},
                {toolbar: '#toolbar', fixed: 'right', width: 100}
            ]];
            this.initDataTable();
            setTimeout(this.reloadDataTable.bind(this), 0);
            var _this = this;
            this.insertion$.click(function () {
                _this.tree$.find('li input.' + SELECTED_ELM_CLS).removeClass(SELECTED_ELM_CLS);
                _this.insertion$.find('input').addClass(SELECTED_ELM_CLS);
                _this.editableData = new Project();
                _this.updateFormFromData();
                _this.beginEditing();
            })
        }

        var parentProto = DataEdit.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;

        override.getBoundInputIdPrefix = function () {
            return 'project-';
        };
        override.getEditableDataURL = function () {
            return settings.apiURLs.modelCenter.project;
        };
        override.outputDataToService = function () {
            var isNew = !$('#project-id').val();
            var url = this.getEditableDataURL();
            if (!isNew) {
                url += '/' + this.editableData.id;
            }
            try {
                (isNew ? gtc.postData : gtc.putData)(url, this.editableData);
            } catch (e) {
                this.message = e;
                return false;
            }
            return true;
        };
        override.rollbackEditing = function () {
            this._inputDataFromCache();
            this.updateFormFromData();
        };
        override.beginEditing = function () {
            this.tree$.hide();
            this.edit$.show();
            var title = '项目编辑';
            var crumb$ = $('#' + CRUMB_ELM_ID);
            crumb$.find('span').html(title);
            crumb$.show();
            $('#' + TITLE_ELM_ID + ' span').html(title);
        };
        override.endEditing = function () {
            this.reloadDataTable();
            this.edit$.hide();
            this.tree$.show();
            $('#' + CRUMB_ELM_ID).hide();
            $('#' + TITLE_ELM_ID + ' span').html('项目');
        };

        proto.initDataTable = function () {
            this._dataTable = layui.table.render({
                elem: '#' + DBCNN_TAB_ELM_ID,
                page: true,
                cols: this._dataTableCols,
                url: this.getEditableDataURL(),
                headers: {
                    "Page-Base": "1"
                },
                request: {
                    pageName: 'page',
                    limitName: 'size'
                },
                parseData: this.transformData.bind(this),
                done: this.onRenderDone.bind(this)
            });

            var _this = this;


            layui.table.on('tool(project)', function (obj) {
                switch (obj.event) {
                    case 'edit':
                        _this.editableData = obj.data;
                        _this.updateFormFromData();
                        _this.beginEditing();
                        break;
                    case 'del':
                        layer.confirm("确认删除【" + obj.data.name + "】吗？",
                            function () {
                                var widget = gtc.showWaiting("文件删除中...");
                                try {
                                    gtc.deleteData(_this.getEditableDataURL() + '/' + obj.data.id);
                                    _this._dataTable.reload();
                                } catch (e) {
                                    gtc.showError("文件删除失败");
                                } finally {
                                    gtc.hideWidget(widget);
                                }
                            });
                        break;
                    default:
                        break;
                }
            });
        };
        proto.reloadDataTable = function () { // todo
            try {
                this._dataTable.reload();
            } catch (e) {
                layer.msg('读取项目列表失败');
            }
        };
        proto.transformData = function (pageResult) {
            pageResult.msg = '';
            pageResult.code = 0;
            pageResult.count = ((pageResult
                .meta || {})
                .page || {})
                .totalElements || 0;
            return pageResult;
        };
        proto.onRenderDone = function () {
            $('#' + DBCNN_TREE_ELM_ID + ' tr')
                .addClass(TR_CLASS_READONLY)
                .find('input, select').attr('disabled', true);
        };
        proto._inputDataFromService = function () {
            var reply = gtc.getData(this.getEditableDataURL());
            if ((reply.code || reply.status) >= 400) {
                layer.msg(reply.message);
            } else {
                this.editableData = reply.data;
                this.updateFormFromData();
            }
        };
        proto._inputDataFromCache = function () {
            this.editableData = JSON.parse(JSON.stringify(this._cachedData));
        };
        proto._outputDataToCache = function () {
            this._cachedData = JSON.parse(JSON.stringify(this.editableData));
        };
        return Constructor;
    }
});