layui.use(['gtc', 'gtc-data-edit', 'settings'], function () {
    'use strict';
    // configurations
    var TREE_ELM_ID = 'model-tree';
    var PREVIEWER_ELM_ID = TREE_ELM_ID + '-previewer';
    var EDITOR_ELM_ID = 'model-edit';
    var NEW_ELM_ID = 'model-new';
    var FROM_TAB_ELM_ID = 'model-from-table';
    var GUIDE_ELM_ID = 'model-guide';
    var PREV_BTN_ID = 'guide-prev';
    var NEXT_BTN_ID = 'guide-next';
    var CANCEL_BTN_ID = 'guide-cancel';
    var SAVE_EDIT_ID = 'save-model-edit';
    var CANCEL_EDIT_ID = 'cancel-model-edit';
    var PREV_EDIT_ELM_ID = 'prev-model-edit';

    var FROM_DBS_ELM_ID = 'from-databases';
    var FROM_DB_ELM_CLS = 'from-database';
    var SELECTED_ELM_CLS = 'selected';

    var FROM_TABS_ELM_ID = 'from-tables';
    var FROM_TAB_ELM_CLS = 'from-table';

    var MODEL_NAME_ELM_ID = 'model-entityName';
    var MODEL_DB_ELM_ID = 'model-databaseConnectionName';
    var MODEL_DESC_ELM_ID = 'model-description';
    var MODEL_TAB_ELM_ID = 'model-tableName';

    var TITLE_ELM_ID = 'title';
    var CRUMB_ELM_ID = 'crumb-2';

    var INITIAL_ELM_ID_POSTFIX = '-2';

    // import
    var settings = layui.settings;
    var gtc = layui.gtc;
    var EntityMeta = gtc.EntityMeta;
    var FieldMeta = gtc.FieldMeta;

    // Classes
    var ModelDefGuide = class_ModelDefGuide();
    var State = class_State();
    var StoppedState = class_StoppedState_extends(State);
    var StartedState = class_StartedState_extends(State);
    var ImportTableState = class_ImportTableState_extends(State);
    var FieldsDefState = class_FieldsDefState_extends(State);

    var EntityMetaTree = class_EntityMetaTree_extends(gtc.DomainResourceTree);
    var EntityMetaValidator = class_EntityMetaValidator();
    var FieldMetaValidator = class_FieldMetaValidator();

    // export
    var entityMetaTree = new EntityMetaTree();
    gtc.listModels = listModels.bind(null, entityMetaTree.zTreeObj);
    gtc.listDateFormats = listDateFormats;
    return entityMetaTree;

    function class_ModelDefGuide() {
        function Constructor() {
            var _this = this;
            $('#' + PREV_BTN_ID + ',#' + PREV_EDIT_ELM_ID).click(function () {
                _this._state.backward();
            });
            $('#' + CANCEL_BTN_ID + ',#' + CANCEL_EDIT_ID).click(function () {
                _this.deactivate();
            });
            $('#' + NEXT_BTN_ID).click(function () {
                _this._state.forward();
            });
            this._state = new StoppedState(this);
            this._state.activate();
        }

        var proto = Constructor.prototype;

        proto.setState = function (state, fromState) {
            var oldState = this._state;
            if (state == null || oldState === state) return;

            if (oldState != null) {
                oldState.deactivate();
            }
            this._state = state;
            state.activate(fromState);
        };
        proto.getState = function () {
            return this._state;
        };
        proto.activate = function (fromState) {
            if (this._state instanceof StoppedState) {
                this._state.forward();
            }
        };
        proto.deactivate = function () {
            if (this._state instanceof StoppedState) return;
            this._state.reset();
        };

        return Constructor;
    }

    function class_State() {
        function Constructor(modelDefGuide, prevState) {
            this.modelDefGuide = modelDefGuide;
            this.prevState = prevState;
            this.tree$ = $('#' + TREE_ELM_ID);
            this.new$ = $('#' + NEW_ELM_ID);
            this.fromTable$ = $('#' + FROM_TAB_ELM_ID);
            this.edit$ = $('#' + EDITOR_ELM_ID);
            this.prev$ = $('#' + PREV_BTN_ID);
            this.next$ = $('#' + NEXT_BTN_ID);
            this.cancel$ = $('#' + CANCEL_BTN_ID);
            this.guide$ = $('#' + GUIDE_ELM_ID);
            this.previewer$ = $('#' + PREVIEWER_ELM_ID);
            this.crumb$ = $('#' + CRUMB_ELM_ID);
            this.title$ = $('#' + TITLE_ELM_ID);
        }

        var proto = Constructor.prototype;

        proto.getTitle = function () {
            return '模型定义';
        };
        proto.activate = function (fromState) {
            var title = this.getTitle();
            this.crumb$.find('span').html(title);
            this.title$.find('span').html(title);
        };
        proto.deactivate = function () {
        };
        proto.forward = function (modelDef) {
        };
        proto.backward = function (modelDef) {
            this.modelDefGuide.setState(this.prevState, this);
        };
        proto.reset = function () {
            var initState = this;
            while (initState.prevState) {
                initState = initState.prevState;
            }
            this.modelDefGuide.setState(initState, this);
        };

        return Constructor;
    }

    function class_StoppedState_extends(State) {
        function Constructor(modelDefGuide, prevState) {
            State.call(this, modelDefGuide, prevState);
        }

        var parentProto = State.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;

        override.activate = function (fromState) {
            parentProto.activate.call(this, fromState);
            this.crumb$.hide();
            this.new$.hide();
            this.edit$.hide();
            this.guide$.hide();
            this.fromTable$.hide();
            this.tree$.show();
        };
        override.deactivate = function () {
            this.crumb$.show();
            this.tree$.hide();
            this.previewer$.hide();
        };
        override.forward = function () {
            this.modelDefGuide.setState(new StartedState(this.modelDefGuide, this), this);
        };

        return Constructor;
    }

    function class_StartedState_extends(State) {
        function Constructor(modelDefGuide, prevState) {
            State.call(this, modelDefGuide, prevState);
            this.databaseList$ = $('#' + FROM_DBS_ELM_ID);
        }

        var parentProto = State.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;

        override.getTitle = function () {
            return '创建模型';
        };
        override.activate = function (fromState) {
            parentProto.activate.call(this, fromState);
            if (this.isDatabaseListEmpty()) {
                setTimeout(this.refreshDatabaseList.bind(this), 0);
            }
            if (fromState instanceof StoppedState) {
                $('.' + FROM_DB_ELM_CLS + '.' + SELECTED_ELM_CLS).removeClass(SELECTED_ELM_CLS);
                $('input[name=model-new-mode]:first').trigger('click');
            }
            this.prev$.hide();
            this.new$.show();
            this.cancel$.show();
            this.next$.show();
            this.guide$.show();
        };
        override.deactivate = function () {
            this.new$.hide();
            this.guide$.hide();
        };
        override.forward = function (modelDef) {
            var selectionSetCount = $('.' + FROM_DB_ELM_CLS + '.' + SELECTED_ELM_CLS).length;
            if (1 !== selectionSetCount) {
                gtc.showError('请选择数据库连接');
                return;
            }
            var mode = $('input[name=model-new-mode]')
                .filter(function (i, element) {
                    return element.checked;
                })
                .val();
            var nextState;
            switch (mode) {
                case 'fromScratch':
                    nextState = new FieldsDefState(this.modelDefGuide, this);
                    break;
                case 'fromTable':
                    nextState = new ImportTableState(this.modelDefGuide, this);
                    break;
                default:
                    nextState = this;
            }
            this.modelDefGuide.setState(nextState, this);
        };
        proto.isDatabaseListEmpty = function () {
            return !this.databaseList$.find('li').length;
        };
        proto.refreshDatabaseList = function () {
            var databaseList$ = this.databaseList$;
            this.tableList$ = $('#' + FROM_TABS_ELM_ID);

            databaseList$.empty();
            try {
                var widget = gtc.showWaiting('正在刷新数据库列表');
                gtc.getData(settings.apiURLs.modelCenter.databaseConnection).data
                    .forEach(function (dbCnn) {
                        $('<li>')
                            .addClass(FROM_DB_ELM_CLS)
                            .html(dbCnn.name)
                            .appendTo(databaseList$)
                            .click(function () {
                                onClickDbLi(this, databaseList$)
                            })
                    });
            } catch (e) {
                gtc.showError('数据库列表刷新失败');
            } finally {
                gtc.hideWaiting(widget);
            }
        };

        function onClickDbLi(clickedLi, ul$) {
            ul$.find('li').removeClass(SELECTED_ELM_CLS);
            $(clickedLi).addClass(SELECTED_ELM_CLS);
        }

        return Constructor;
    }

    function class_ImportTableState_extends(State) {
        function Constructor(modelDefGuide, prevState) {
            State.call(this, modelDefGuide, prevState);
            this.databaseList$ = $('#' + FROM_DBS_ELM_ID);
            this.tableList$ = $('#' + FROM_TABS_ELM_ID);
        }

        var parentProto = State.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;

        override.getTitle = function () {
            return '由已有表创建模型';
        };
        override.activate = function (fromState) {
            parentProto.activate.call(this, fromState);
            if (fromState instanceof StartedState) {
                $('#' + MODEL_NAME_ELM_ID + INITIAL_ELM_ID_POSTFIX).val(null);
                $('#' + MODEL_DESC_ELM_ID + INITIAL_ELM_ID_POSTFIX).val(null);
                setTimeout(this.refreshTableList.bind(this), 0);
            }
            this.fromTable$.show();
            this.prev$.show();
            this.next$.show();
            this.cancel$.show();
            this.guide$.show();
        };
        override.deactivate = function () {
            this.fromTable$.hide();
            this.guide$.hide();
        };
        override.forward = function (modelDef) {
            var name = $('#' + MODEL_NAME_ELM_ID + INITIAL_ELM_ID_POSTFIX).val();
            if (name == null || !name.length) {
                gtc.showError('模型名称不得为空');
                return;
            }
            var selectionSetCount = $('.' + FROM_TAB_ELM_CLS + '.' + SELECTED_ELM_CLS).length;
            if (1 !== selectionSetCount) {
                gtc.showError('请选择需要映射的表');
                return;
            }
            this.modelDefGuide.setState(new FieldsDefState(this.modelDefGuide, this), this);
        };

        proto.refreshTableList = function () {
            var tableList$ = this.tableList$;
            var selectedDbLi = this.databaseList$.find('.' + SELECTED_ELM_CLS);

            this.tableList$.empty();
            try {
                var widget = gtc.showWaiting('正在刷新数据库表列表');
                gtc.getData(settings.apiURLs.modelCenter.getTablesURL($(selectedDbLi).html())).data
                    .forEach(function (tableName) {
                        $('<li>')
                            .addClass(FROM_TAB_ELM_CLS)
                            .html(tableName)
                            .appendTo(tableList$)
                            .click(function () {
                                onClickTableLi(this, tableList$);
                            })
                    });
            } catch (e) {
                gtc.showError('数据库表刷新失败');
            } finally {
                gtc.hideWaiting(widget);
            }
        };

        function onClickTableLi(clickedLi, ul$) {
            ul$.find('li').removeClass(SELECTED_ELM_CLS);
            $(clickedLi).addClass(SELECTED_ELM_CLS);
        }

        return Constructor;
    }


    function class_FieldsDefState_extends(State) {
        function Constructor(modelDefGuide, prevState) {
            State.call(this, modelDefGuide, prevState);
        }

        var parentProto = State.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;

        override.getTitle = function () {
            return '模型定义编辑';
        };
        override.activate = function (fromState) {
            parentProto.activate.call(this, fromState);

            var dbCnnName = $('.' + FROM_DB_ELM_CLS + '.' + SELECTED_ELM_CLS).html();
            var tableName = $('.' + FROM_TAB_ELM_CLS + '.' + SELECTED_ELM_CLS).html();
            var name = $('#' + MODEL_NAME_ELM_ID + INITIAL_ELM_ID_POSTFIX).val();
            var description = $('#' + MODEL_DESC_ELM_ID + INITIAL_ELM_ID_POSTFIX).val();

            var fromImportTableState = this.prevState instanceof ImportTableState;
            [MODEL_NAME_ELM_ID, MODEL_DESC_ELM_ID, MODEL_TAB_ELM_ID].forEach(function (elementId) {
                $('#' + elementId).attr('disabled', fromImportTableState);
            });

            entityMetaTree.editNewNode({
                entityName: name,
                databaseConnectionName: dbCnnName,
                tableName: tableName,
                description: description
            });
            this.crumb$.show();
            this.edit$.show();
        };
        override.deactivate = function () {
            this.edit$.hide();
        };
        // override.forward = function (modelDef) {
        //     this.modelDefGuide.setState(new ImportTableState(this.modelDefGuide, this));
        // };
        override.backward = function () {
            entityMetaTree.rollbackEditing();
            entityMetaTree.endEditing(true);
            parentProto.backward.call(this);
        };

        return Constructor;
    }


    function class_EntityMetaTree_extends(DomainResourceTree) {
        var TR_CLASS_READONLY = 'readonly';

        function Constructor() {
            DomainResourceTree.call(this, TREE_ELM_ID, EDITOR_ELM_ID, SAVE_EDIT_ID, CANCEL_EDIT_ID);

            this._divToScript();

            this._fieldMetaTableCols = [[
                {field: 'name', title: '名称', edit: 'text', minWidth: 150},
                {field: 'description', title: '描述', edit: 'text', minWidth: 150},
                {field: 'type', title: '类型', toolbar: '#field-type', minWidth: 150},
                {field: 'asId', title: '是否作为主键', toolbar: '#field-asId', minWidth: 120},
                {field: 'columnName', title: '数据库列名', edit: 'text', minWidth: 150},
                {field: 'unique', title: '是否值唯一', toolbar: '#field-unique', minWidth: 120},
                {field: 'nullable', title: '可否为空', toolbar: '#field-nullable', minWidth: 90},
                {field: 'length', title: '字段长度', templet: '#field-number', minWidth: 120},
                {field: 'precision', title: '数值精度', templet: '#field-number', minWidth: 120},
                {field: 'scale', title: '数值尺度', templet: '#field-number', minWidth: 120},
                {field: 'defaultValue', title: '默认值', edit: 'text', minWidth: 120},
                // {field: 'valueGenerator', title: '值生成器', edit: 'text', minWidth: 90},
                // {field: 'valueGeneratorStrategy', title: '值生成策略', edit: 'text', minWidth: 150},
                // {field: 'temporalType', title: '日期时间种类', toolbar: '#field-temporalType', minWidth: 150},
                {field: 'dateTimeFormat', title: '日期时间格式', toolbar: '#field-dateTimeFormat', minWidth: 200},
                // {field: 'embedded', title: '是否嵌入', toolbar: '#field-embedded', minWidth: 90},
                // {field: 'embeddedTable', title: '嵌入的表名', edit: 'text', minWidth: 150},
                {field: 'foreignReference', title: '关联类型', toolbar: '#field-foreignReference', minWidth: 90},
                {field: 'cascadeType', title: '级联类型', toolbar: '#field-cascadeType', minWidth: 90},
                {field: 'fetchType', title: '数据获取类型', toolbar: '#field-fetchType', minWidth: 120},
                {field: 'referencedBy', title: '对方模型字段名', edit: 'text', minWidth: 150},
                // {field: 'referenceTable', title: '关系表名', edit: 'text', minWidth: 150},
                {field: 'serializeUsing', title: '序列化方式', toolbar: '#field-serializeUsing', minWidth: 120},
                {toolbar: '#toolbar', fixed: 'right', width: 100}
            ]];

            this._initDbConnOptions();
            this._initFieldMetaTable();
            var _this = this;
            $('#add-field').click(function () {
                _this.updateDataFromForm();
                _this.editableData.fields.push(new FieldMeta());
                _this._reloadTable();
                _this._refreshTable();
            });
            this.modelDefGuide = new ModelDefGuide();
        }

        var parentProto = DomainResourceTree.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        var override = proto;
        proto.constructor = Constructor;

        override.onClickAddNode = function (treeNode, event) {
            this.modelDefGuide.activate();
            this._parentNode = treeNode;
        };
        override.beforeSave = function () {
            this.updateDataFromForm();
            return this._validateEdit();
        };
        override.beginEditing = function (treeNode) {
            parentProto.beginEditing.call(this, treeNode);
            var title = new FieldsDefState().getTitle();
            var crumb$ = $('#' + CRUMB_ELM_ID);
            crumb$.find('span').html(title);
            crumb$.show();
            $('#' + TITLE_ELM_ID + ' span').html(title);
        };
        override.endEditing = function (keepUi) {
            if (keepUi) {
                this.beingEditedNode = null;
            } else {
                parentProto.endEditing.call(this);
            }
            $('#' + CRUMB_ELM_ID).hide();
            $('#' + TITLE_ELM_ID + ' span').html(new StoppedState().getTitle());
        };
        override.cancelEdit = function () {
            parentProto.cancelEdit.call(this);
            this.modelDefGuide.deactivate();
        };
        override.getEditableDataConstructor = function () {
            return EntityMeta;
        };
        override.getEditableDataTypeDescription = function () {
            return '模型';
        };
        override.getResourceTypeName = function () {
            return 'model';
        };
        override.getEditableDataURL = function () {
            return settings.apiURLs.modelCenter.modelDef;
        };
        override.refreshPreview = function (treeNode) {
            var data = treeNode._data;
            if (!data) {
                this.treePreviewer$.hide();
                return;
            }
            var _this = this;
            setTimeout(function () {
                if (treeNode.isParent) {
                    _this.showNodeDetail('业务分类', [
                        {key: 'ID：', value: data.id},
                        {key: '名称：', value: data.name},
                        {key: '描述：', value: data.description}
                    ]);
                } else {
                    try {
                        var modelDef = gtc.getData(settings.apiURLs.modelCenter.modelDef + '/' + data.key);
                    } catch (e) {
                        modelDef = new EntityMeta();
                    }
                    _this.showNodeDetail('模型定义', [
                        {key: '名称：', value: modelDef.entityName},
                        {key: '描述：', value: modelDef.description},
                        {key: '数据库表名：', value: modelDef.tableName},
                        {key: '数据库连接：', value: modelDef.databaseConnectionName}
                    ]);
                }
            });
        };
        override.updateDataFromNode = function (treeNode) {
            parentProto.updateDataFromNode.call(this, treeNode);

            var initialData = treeNode._from;
            var editableData = this.editableData;
            if (initialData) {
                editableData.description = initialData.description;
                editableData.databaseConnectionName = initialData.databaseConnectionName;
                if (initialData.tableName != null) {
                    editableData.tableName = initialData.tableName;
                    var tableFieldsUrl = settings.apiURLs.modelCenter.getTableFieldsURL(
                        editableData.databaseConnectionName, editableData.tableName);
                    try {
                        var widget = gtc.showWaiting('正在读取模型字段信息');
                        var result = gtc.getData(tableFieldsUrl);
                        if (result.data) {
                            editableData.fields = result.data;
                        }
                    } catch (e) {
                        gtc.showError('读取表字段信息失败');
                    } finally {
                        gtc.hideWaiting(widget);
                    }
                }
            }
            delete treeNode._from;
        };
        override.updateFormFromData = function (detached) {
            parentProto.updateFormFromData.call(this, detached);
            var prevBtn$ = $('#' + PREV_EDIT_ELM_ID);
            if (detached) {
                prevBtn$.show();
            } else {
                $('#' + MODEL_NAME_ELM_ID).attr('disabled', true);
                prevBtn$.hide();
            }
            this._renewTable();
            this._refreshTable();
        };
        override.updateDataFromForm = function () {
            var fields = this.editableData.fields;
            $('#entity-meta tbody>tr').each(function (iField, tr) {
                var tr$ = $(tr);
                if (tr$.hasClass(TR_CLASS_READONLY)) return;

                tr$.find('td:has(input,select)').each(function (_, td) {
                    var td$ = $(td);
                    var fieldName = td$.attr('data-field');
                    var input$ = td$.find('input,select');
                    var valueType = input$.attr("value-type");
                    var newValue = input$.val();
                    if (newValue === '') {
                        newValue = null;
                    } else {
                        newValue = parseValue(newValue, valueType);
                    }
                    var field = fields[iField];
                    field[fieldName] = newValue;
                    delete field.LAY_TABLE_INDEX;
                });

            });
        };
        proto.editNewNode = function (initialData) {
            var fromData = initialData || {};

            var newNode = this.zTreeObj.addNodes(this._parentNode,
                {
                    id: null,
                    pId: this._parentNode && this._parentNode.id,
                    name: fromData.entityName || null,
                    isParent: this.isCategoriesOnly(),
                    _data: null,
                    _from: initialData ? {
                        databaseConnectionName: fromData.databaseConnectionName || null,
                        tableName: fromData.tableName || null,
                        description: fromData.description || null
                    } : null
                })[0];
            this.updateDataFromNode(newNode);
            this.updateFormFromData(true);
            this.beginEditing(newNode);
        };
        proto._divToScript = function () {
            var divContainer$ = $('.div-to-script');
            if (!divContainer$.length) {
                return;
            }
            var scriptIdsAttrName = 'script-ids';
            var scriptIdAttrName = 'script-id';
            var fieldAttrPrefix = 'field-';
            var valueTypeAttrName = 'value-type';
            divContainer$.find('[' + scriptIdsAttrName + ']')
                .each(splitScriptIdsElement)
                .remove();

            divContainer$.find('[' + scriptIdAttrName + ']')
                .each(scriptIdDivElementToScriptElement)
                .remove();

            function splitScriptIdsElement(i, div) {
                $(div).attr(scriptIdsAttrName).split(',').forEach(function (scriptId) {
                    $('<div ' + scriptIdAttrName + '="' + scriptId + '">' + $(div).html() + '</div>')
                        .appendTo(div.parentElement);
                });
            }

            function scriptIdDivElementToScriptElement(i, div) {
                var div$ = $(div);
                var fieldName = div$.attr(scriptIdAttrName).substring(fieldAttrPrefix.length);
                var expressions = {};
                div$.find('select')
                    .each(function (iSelectElement, selectElement) {
                        var selectElement$ = $(selectElement);
                        var valueType = selectElement$.attr(valueTypeAttrName);
                        selectElement$.find('option')
                            .each(function (iOptionElement, optionElement) {
                                var optionValue = $(optionElement).val();
                                var isBlank = optionValue == null || optionValue === '';
                                var expression = '{{d.' + fieldName;
                                if (isBlank) {
                                    expression += '==null';
                                } else {
                                    expression += '===';
                                    switch (valueType) {
                                        case 'bool':
                                        case 'int':
                                        case 'float':
                                            expression += optionValue;
                                            break;
                                        default:
                                            expression += JSON.stringify(optionValue);
                                            break;
                                    }
                                }
                                expression += '?"selected":""}}';
                                var key = 'selected-' + iSelectElement + '-option-' + iOptionElement;
                                $(optionElement).attr(key, '');
                                expressions[key] = expression;
                            });
                    });
                var scriptText = Object.keys(expressions)
                    .reduce(function (html, key) {
                            var expr = expressions[key];
                            return html.replace(key + '=""', expr);
                        },
                        div$.html());
                $('<script>')
                    .attr({
                        id: div$.attr(scriptIdAttrName),
                        type: "text/html"
                    })
                    .text(scriptText)
                    .appendTo(divContainer$[0]);
            }
        };
        proto._initDbConnOptions = function () {
            try {
                var reply = gtc.getData(settings.apiURLs.modelCenter.databaseConnection);
                var dbConnSelect$ = $('#' + MODEL_DB_ELM_ID);
                var data = reply.data || [];
                [].forEach.call(data, function (dbConn) {
                    $('<option value="' + dbConn.name + '">' + dbConn.description + '</option>')
                        .appendTo(dbConnSelect$);
                });
            } catch (e) {
                gtc.showError('读取数据库连接列表失败');
            }
        };
        proto._initFieldMetaTable = function (data) {
            this._fieldMetaTable = layui.table.render({
                elem: '#field-meta-table',
                limit: 999,
                cols: this._fieldMetaTableCols,
                data: data || []
            });

            var _this = this;
            layui.table.on('tool(fields)', function (obj) {
                var fields = _this.editableData.fields;
                var fieldIndex = 1 * obj.tr.selector.match(/data-index="(\d+)"/)[1];
                switch (obj.event) {
                    case 'del':
                        layer.confirm('真的删除行么', function (index) {
                            obj.del();
                            fields.splice(fieldIndex, 1);
                            _this._reloadTable();
                            _this._refreshTable();
                            layer.close(index);
                        });
                        break;
                    case 'dup':
                        _this.updateDataFromForm();
                        var fieldMeta = fields[fieldIndex];
                        var newFieldMeta = JSON.parse(JSON.stringify(fieldMeta));
                        fields.splice(fieldIndex, 0, newFieldMeta);
                        _this._reloadTable();
                        _this._refreshTable();
                        break;
                    default:
                        break;
                }
            });
        };
        proto._renewTable = function () {
            var fields = this.editableData ? this._flattenFields(this.editableData.fields) : [];
            this._initFieldMetaTable(fields);
            this._updateFieldTypeInputsFromData(fields);
        };
        proto._reloadTable = function () {
            var fields = this.editableData ? this.editableData.fields : [];
            this._fieldMetaTable.reload({data: fields});
            this._updateFieldTypeInputsFromData(fields);
        };
        proto._refreshTable = function () {
            var fieldSelectors = ['proId', 'createTime', 'modifyTime', 'enabled']
                .map(function (field) {
                    return 'div:contains(' + field + ')';
                });
            $('#' + EDITOR_ELM_ID + ' tr:has(' + fieldSelectors.join(',') + ')')
                .addClass(TR_CLASS_READONLY)
                .each(function (i, tr) {
                    var tr$ = $(tr);
                    var dataIndex = tr$.attr('data-index');
                    $('.layui-table-fixed .layui-table-body tbody tr[data-index=' + dataIndex + '] a').hide();
                })
                .find('input, select').attr('disabled', true);
        };
        proto._flattenFields = function (fields, strategy) {
            fields.forEach(function (field) {
                Object.keys(field).forEach(function (key) {
                    var value = field[key];
                    if (Array.isArray(value)) {
                        field[key] = (strategy || defaultStrategy)(value);
                    }
                });
            });
            return fields;

            function defaultStrategy(array) {
                return array == null || !array.length ? null : array[0];
            }
        };
        proto._updateFieldTypeInputsFromData = function (fields) {
            var tableIndex = this._fieldMetaTable.config.index;
            $('div[lay-filter=LAY-table-' + tableIndex + '] .layui-table-body tr').each(function (i, tr) {
                var field = fields[i];
                if (field == null) return;

                $(tr).find('td')
                    .each(function (_, td) {
                        var td$ = $(td);
                        var propertyName = td$.attr('data-field');
                        if ('type' === propertyName) {
                            td$.find('dl dd[lay-value=' + field.type + ']').trigger('click');
                        }

                        td$.find('div.layui-table-cell>input[type=number]')
                            .each(function (_, input) {
                                var propertyValue = field[propertyName];
                                if (null != propertyValue) {
                                    $(input).val(propertyValue)
                                }
                            });
                    });
            })
        };
        proto._validateEdit = function () {
            return new EntityMetaValidator(this.editableData).validate();
        };

        return Constructor;
    }

    function class_EntityMetaValidator() {
        var NAME_REGEX = /^[A-Za-z_][A-Za-z0-9_]{0,31}$/;

        function Constructor(entityMeta) {
            this.entityMeta = entityMeta;
            this.warningMessages = [];
        }

        var proto = Constructor.prototype;

        proto.validate = function () {
            var warningMessages = this.warningMessages;
            warningMessages.splice(0, warningMessages.length);
            try {
                var valid = this.validateEntityName() &&
                    this.validateDescription() &&
                    this.validateTableName() &&
                    this.validateDbCnnName() &&
                    this.validateFields();
                if (valid) {
                    if (warningMessages.length > 0) {
                        gtc.showError(warningMessages.join('\n'));
                    }
                } else {
                    gtc.showError('校验失败');
                }
                return valid;
            } catch (e) {
                gtc.showError(e);
                return false;
            }
        };
        proto.validateEntityName = function () {
            var key = '模型名称';
            var value = this.entityMeta.entityName;
            assertNonBlank(key, value);
            assertNoLongerThan(key, value, 32);
            assertMatch(key, value, NAME_REGEX);
            return true;
        };
        proto.validateDescription = function () {
            var key = '描述';
            var value = this.entityMeta.description;
            assertNoLongerThan(key, value, 255);
            return true;
        };
        proto.validateTableName = function () {
            var key = '表名';
            var value = this.entityMeta.tableName;
            assertNoLongerThan(key, value, 32);
            if (value != null && value.length > 0) {
                assertMatch(key, value, NAME_REGEX);
            }
            return true;
        };
        proto.validateDbCnnName = function () {
            var key = '数据库连接名';
            var value = this.entityMeta.databaseConnectionName;
            assertNonBlank(key, value);
            return true;
        };
        proto.validateFields = function () {
            var fields = this.entityMeta.fields;
            var _this = this;
            return this.validateFieldsByName(fields) &&
                this.validateFieldsByDescription(fields) &&
                this.validateFieldsByAsId(fields) &&
                this.validateFieldsByAsId(fields) &&
                this.validateFieldsByColumnName(fields) &&
                fields.reduce(function (prevValid, field) {
                    return prevValid && new FieldMetaValidator(field, _this).validate();
                }, true);
        };
        proto.validateFieldsByName = function () {
            var fields = this.entityMeta.fields;
            var fieldNames = fields.map(function (field, i) {
                var key = '第' + (i + 1) + '个字段的名称';
                var value = field.name;
                assertNonBlank(key, value);
                assertMatch(key, value, NAME_REGEX, '字段名称');
                return value;
            });
            assertUnique('字段名称', fieldNames, defaultEqualityTester);
            return true;
        };
        proto.validateFieldsByDescription = function () {
            var fields = this.entityMeta.fields;
            fields.forEach(function (field) {
                var key = '字段' + field.name + '的描述';
                var value = field.description;
                assertNoLongerThan(key, value, 32);
            });
            return true;
        };
        proto.validateFieldsByAsId = function () {
            var fields = this.entityMeta.fields;
            var fieldIds = fields.filter(function (field) {
                return field.asId;
            });
            if (fieldIds.length === 1) return true;
            throw '主键字段的数量不等于1';
        };
        proto.validateFieldsByColumnName = function () {
            var fields = this.entityMeta.fields;
            var fieldColumnNames = fields.map(function (field) {
                var key = '字段' + field.name + '的列名';
                var value = field.columnName;
                if (value == null || value === '') return field.name;
                assertMatch(key, value, NAME_REGEX, '列名');
                return value;
            });
            assertUnique('列名', fieldColumnNames, defaultEqualityTester);
            return true;
        };
        proto.addWarning = function (warningMessage) {
            this.warningMessages.push(warningMessage);
        };

        return Constructor;
    }

    function class_FieldMetaValidator() {
        var INTEGER_REGEX = /^(0|-?[1-9][0-9]{0,9})$/;
        var REAL_REGEX = /^(0\.?|-?[1-9][0-9]{0,19}\.?|-?0?\.[0-9]{0,20}|-?[1-9][0-9]{0,19}\.[0-9]{0,20})$/;
        var BOOLEAN_REGEX = /^(t(rue)?|f(alse)?|1|0)$/i;

        function Constructor(field, entityMetaValidator) {
            this.field = field;
            this.entityMetaValidator = entityMetaValidator;

            if (field.type == null) {
                if (field.asId) {
                    this.isString = true;
                    this.isNull = false;
                } else {
                    this.isNull = true;
                }
            } else {
                this.isNull = false;
                switch (field.type.toLowerCase()) {
                    case 'int':
                    case 'integer':
                        this.isInteger = true;
                        break;
                    case 'float':
                    case 'double':
                    case 'real':
                    case 'decimal':
                        this.isReal = true;
                        break;
                    case 'bool':
                    case 'boolean':
                        this.isBoolean = true;
                        break;
                    case 'str':
                    case 'string':
                    case 'text':
                    case 'char':
                    case 'character':
                        this.isString = true;
                        break;
                    case 'date':
                    case 'time':
                    case 'datetime':
                    case 'timestamp':
                        this.isDateTime = true;
                        break;
                    default:
                        this.isPrime = false;
                        break;
                }
                if (this.isInteger || this.isReal) {
                    this.isNumber = true;
                }
                if (!this.isNull && this.isPrime == null) {
                    this.isPrime = true;
                }
            }
        }

        var proto = Constructor.prototype;

        proto.validate = function () {
            return this.validateUsingAsId() &&
                this.validateUsingType() &&
                this.validateUsingForeignReference();
        };
        proto.validateUsingAsId = function () {
            var field = this.field;
            var fieldName = field.name;
            var fieldType = field.type;
            if (field.asId) {
                if (field.nullable === true) throw '字段' + fieldName + '作为主键时【可否为空】不得为“是”';
                if (field.unique === false) throw '字段' + fieldName + '作为主键时【是否值唯一】不得为“否”';
                if (fieldType != null) {
                    this.entityMetaValidator.addWarning('字段' + fieldName + '作为主键时不建议指定字段类型');
                }
            } else {
                assertNonBlank('字段' + fieldName + '的类型', fieldType);
            }
            return true;
        };
        proto.validateUsingType = function () {
            return this.validateByLengthUsingType() &&
                this.validateByScaleUsingType() &&
                this.validateByPrecisionUsingType() &&
                this.validateByDefaultValueUsingType() &&
                this.validateByDateTimeFormatUsingType() &&
                this.validateByForeignReferenceUsingType();
        };
        proto.validateByLengthUsingType = function () {
            var field = this.field;
            var fieldLength = field.length;
            if (fieldLength == null) return true;

            if (!this.isString) throw '非字符串字段' + field.name + '不得设置长度';

            if (fieldLength < 1) throw '字段' + field.name + '长度不得小于1';

            return true;
        };
        proto.validateByScaleUsingType = function () {
            var field = this.field;
            var fieldScale = field.scale;
            if (fieldScale == null) return true;

            if (!this.isNumber) throw '非数字字段' + field.name + '不得设置尺度';

            if (fieldScale < 0) throw '字段' + field.name + '尺度不得小于1';

            return true;
        };
        proto.validateByPrecisionUsingType = function () {
            var field = this.field;
            var fieldPrecision = field.precision;
            if (fieldPrecision == null) return true;

            if (!this.isReal) throw '非实数字段' + field.name + '不得设置精度';

            if (fieldPrecision < 0) throw '字段' + field.name + '精度不得小于1';

            return true;
        };
        proto.validateByDefaultValueUsingType = function () {
            var field = this.field;
            var fieldDefault = field.defaultValue;
            if (fieldDefault == null) return true;

            var nonMatchMessage = '字段' + field.name + '的默认值格式与字段类型不符';
            if (this.isNull) {
                throw '未指定类型的字段' + field.name + '不得设置默认值';
            } else if (false === this.isPrime) {
                throw '非基本类型字段' + field.name + '不得设置默认值';
            } else if (this.isInteger) {
                if (!fieldDefault.match(INTEGER_REGEX)) throw nonMatchMessage;
            } else if (this.isReal) {
                if (!fieldDefault.match(REAL_REGEX)) throw nonMatchMessage;
            } else if (this.isBoolean) {
                if (!fieldDefault.match(BOOLEAN_REGEX)) throw nonMatchMessage;
            }
            return true;
        };
        proto.validateByDateTimeFormatUsingType = function () {
            var field = this.field;
            if (field.dateTimeFormat == null) {
                if (this.isDateTime) throw '日期时间型字段' + field.name + '必需设置日期时间格式';
            } else if (!this.isDateTime) {
                throw '非日期时间型字段' + field.name + '不得设置日期时间格式';
            }
            return true;
        };
        proto.validateByForeignReferenceUsingType = function () {
            var field = this.field;
            var fieldReference = field.foreignReference;
            if (fieldReference == null) {
                if (false === this.isPrime) throw '非基本类型字段' + field.name + '必需设置关联类型';
            } else {
                switch (fieldReference) {
                    case 'ONETOONE':
                    case 'ONETOMANY':
                        if (true === this.isPrime) throw '基本类型字段' + field.name + '不可设置关联类型为一对一或一对多';
                        break;
                    case 'MANYTOONE':
                    case 'MANYTOMANY':
                        break;
                    default:
                        throw '字段' + field.name + '的关联类型无效';
                }
            }
            return true;
        };
        proto.validateUsingForeignReference = function () {
            var field = this.field;
            var fieldReference = field.foreignReference;
            var messagePrefix = '字段' + field.name;
            var fieldCascadeType = field.cascadeType && field.cascadeType.length > 0 ? field.cascadeType[0] : null;
            if (fieldReference == null) {
                if (fieldCascadeType != null && fieldCascadeType !== '') throw messagePrefix + '不得设置级联类型';
                if (field.fetchType != null) throw messagePrefix + '不得设置数据获取类型';
                if (field.referencedBy != null) throw messagePrefix + '不得设置引用本字段的模型';
                if (field.referenceTable != null) throw messagePrefix + '不得设置引用表名';
            } else {
                if (field.fetchType == null) {
                    this.entityMetaValidator.addWarning(messagePrefix + '的数据获取类型为空');
                }
                if ((fieldCascadeType == null || fieldCascadeType === '') &&
                    fieldReference.match(/^ONETO/)) {
                    this.entityMetaValidator.addWarning(messagePrefix + '的级联类型为空');
                }
            }
            return true;
        };
        return Constructor;
    }

    function listModels(zTreeObj) {
        var models = ['int', 'float', 'bool', 'string', 'date', 'time', 'timestamp'];
        zTreeObj.getNodes().forEach(fetchResourcesFromNode.bind(null, models));
        var thisModel = $('#model-entityName').val();
        if (models.indexOf(thisModel) < 0) {
            models.push(thisModel);
        }
        return models;
    }

    function listDateFormats() {
        return ["yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyy-M-d H:m:s", "yyyy/M/d H:m:s",
            "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-M-d", "yyyy/M/d", "MM-dd", "MM/dd", "M-d", "M/d",
            "HH:mm:ss", "H:m:s", "HH:mm", "H:m"];
    }

    function fetchResourcesFromNode(reources, treeNode) {
        if (treeNode == null) return;
        if ((treeNode._data || {}).key !== undefined) {
            reources.push(treeNode._data.key);
        }

        if (treeNode.children == null) return;
        treeNode.children.forEach(fetchResourcesFromNode.bind(null, reources));
    }

    function assertNonBlank(key, value) {
        if (value != null && value.length > 0) return true;
        throw key + '不得为空';
    }

    function assertNoLongerThan(key, value, len) {
        if (value == null || value.length <= len) return true;
        throw key + '长度不得超过' + len;
    }

    function assertMatch(key, value, regex, description) {
        if (value.match(regex)) return true;
        throw key + (description ? '不符合' + description : '不是合法') + '的格式';
    }

    function assertUnique(key, values, equalityTester) {
        if (!equalityTester) {
            equalityTester = blankIgnoredEqualityTester;
        }
        values.forEach(function (left, iLeft) {
            values.forEach(function (right, iRight) {
                if (iLeft === iRight || !equalityTester(left, right)) return;
                throw key + '不唯一';
            })
        });
        return true;
    }

    function defaultEqualityTester(left, right) {
        return left === right;
    }

    function blankIgnoredEqualityTester(left, right, onNonBlankEqualityTester) {
        var leftBlank = left == null || left === '';
        var rightBlank = right == null || right === '';
        return leftBlank && rightBlank ||
            !leftBlank && !rightBlank && (onNonBlankEqualityTester || defaultEqualityTester)(left, right);
    }

    function parseValue(valueString, valueType) {
        var typedValue = null;
        switch (valueType) {
            case 'int':
                typedValue = valueString * 1;
                typedValue = typedValue < 0 ? Math.ceil(typedValue) : Math.floor(typedValue);
                break;
            case 'float':
                typedValue = valueString * 1;
                break;
            case 'bool':
                if (valueString.match(/^(t(rue)?|1)$/i)) {
                    typedValue = true;
                } else if (valueString.match(/^(f(alse)?|0)$/i)) {
                    typedValue = false;
                }
                break;
            default:
                typedValue = valueString;
                break;
        }
        return typedValue;
    }
});