layui.define(['table', 'form', 'settings'], function (exports) {
    'use strict';
    return exports('gtc', {
        request: request,
        getData: request.bind(null, 'get'),
        postData: request.bind(null, 'post'),
        putData: request.bind(null, 'put'),
        patchData: request.bind(null, 'patch'),
        deleteData: request.bind(null, 'delete'),
        showWaiting: showWaiting,
        hideWaiting: hideWaiting,
        showError: showError,
        showMessage: showMessage,
        bindTimeout: bindTimeout
    });

    function request(method, url, data, kwargs) {
        var option = {
            url: url,
            type: method,
            contentType: "application/json; charset=utf-8",
            dataType: "json",
            async: false,
            success: function (reply) {
                result = reply;
            },
            fail: function (ex) {
                throw ex;
            }
        };
        if (kwargs != null) {
            Object.keys(kwargs).forEach(function (key) {
                option[key] = kwargs[key];
            });
        }
        var result = null;
        if (data !== undefined) {
            option.data = option.contentType.match(/json/i) ? JSON.stringify(data) : data;
        }
        $.ajax(option);
        return result;
    }

    function showWaiting(message) {
        return layer.msg(message, {
            icon: 16,
            shade: [0.5, '#f5f5f5'],
            scrollbar: false,
            offset: 'auto'
        });
    }

    function hideWaiting(widget) {
        layer.close(widget);
    }

    function showError(message) {
        layer.alert(message, {btn: ['确定']});
    }

    function showMessage(message) {
        layer.msg(message, {btn: ['确定']});
    }

    function bindTimeout(func) {
        return function () {
            var _arguments = arguments;
            var _this = this;
            setTimeout(function () {
                func.apply(_this, _arguments);
            });
        }
    }
});
