layui.define(['gtc', 'table', 'form', 'settings'], function (exports) {
    'use strict';
    var settings = layui.settings;
    var gtc = layui.gtc;
    var AbstractData = class_AbstractData();
    var DomainCategory = class_DomainCategory_extends(AbstractData);
    var DomainResource = class_DomainResource_extends(AbstractData);
    var DataEdit = class_DataEdit();
    var DomainTree = class_DomainTree_extends(DataEdit);

    gtc.DatabaseConnection = DatabaseConnection;
    gtc.AbstractData = AbstractData;
    gtc.DomainCategory = DomainCategory;
    gtc.DomainCategorySlice = DomainCategorySlice;
    gtc.DomainResource = DomainResource;
    gtc.EntityMeta = class_EntityMeta_extends(AbstractData);
    gtc.FieldMeta = FieldMeta;
    gtc.QueryMeta = class_QueryMeta_extends(AbstractData);
    gtc.DataEdit = DataEdit;
    gtc.DomainTree = DomainTree;
    gtc.DomainResourceTree = class_DomainResourceTree_extends(DomainTree);

    return exports('gtc-data-edit', {});


    function DatabaseConnection() {
        this.sqlDialect = this.jdbcPassword = this.jdbcUser = this.jdbcUrl = this.jdbcDriver
            = this.description = this.name = null;
    }

    function class_AbstractData() {
        function Constructor() {
        }

        var proto = Constructor.prototype;

        proto.getId = function () {
            return this.id;
        };
        proto.setId = function (id) {
            this.id = id;
        };
        proto.getParentCategory = function () {
            return this.parentCategory;
        };
        proto.setParentCategory = function (parentCategory) {
            this.parentCategory = parentCategory;
        };
        return Constructor;
    }

    function class_DomainCategory_extends(AbstractData) {
        function Constructor(parentCategory) {
            this.id = this.name = this.description = null;
            this.parentCategory = parentCategory ? new DomainCategorySlice(parentCategory) : null;
            this.childCategories = [];
            this.resources = [];
        }

        var proto = Constructor.prototype = Object.create(AbstractData.prototype);
        proto.constructor = Constructor;

        return Constructor;
    }

    function DomainCategorySlice(domainCategory) {
        this.id = (domainCategory || {id: null}).id;
    }

    function class_DomainResource_extends(AbstractData) {
        function Constructor(domainCategory) {
            this.resourceType = this.key = this.id = null;
            this.domainCategory = new DomainCategorySlice(domainCategory);
        }

        var proto = Constructor.prototype = Object.create(AbstractData.prototype);
        proto.constructor = Constructor;

        proto.getParentCategory = function () {
            return this.domainCategory;
        };
        proto.setParentCategory = function (parentCategory) {
            this.domainCategory = parentCategory;
        };

        return Constructor;
    }

    function class_EntityMeta_extends(AbstractData) {
        function Constructor(domainCategory) {
            this.databaseConnectionName = this.entityName = this.description = this.embeddable = this.tableName = null;
            this.fields = [];
            this.domainCategory = new DomainCategorySlice(domainCategory);
        }

        var proto = Constructor.prototype = Object.create(AbstractData.prototype);
        proto.constructor = Constructor;

        proto.getId = function () {
            return this.entityName;
        };
        proto.setId = function (entityName) {
            this.entityName = entityName;
        };
        proto.getParentCategory = function () {
            return this.domainCategory;
        };
        proto.setParentCategory = function (parentCategory) {
            this.domainCategory = parentCategory;
        };

        return Constructor;
    }

    function FieldMeta() {
        this.referenceTable = this.referencedBy = this.fetchType = this.foreignReference
            = this.embeddedTable = this.embedded
            = this.dateTimeFormat = this.temporalType
            = this.valueGeneratorStrategy = this.valueGenerator = this.defaultValue
            = this.scale = this.precision = this.length
            = this.nullable = this.unique = this.columnName = this.asId
            = this.type = this.description = this.name = this.id = null;
        this.cascadeType = [];
    }

    function class_QueryMeta_extends(AbstractData) {
        function Constructor(domainCategory) {
            this.databaseConnectionName = this.queryStatement = this.queryLanguage = this.description = this.queryName = null;
            this.domainCategory = new DomainCategorySlice(domainCategory);
        }

        var proto = Constructor.prototype = Object.create(AbstractData.prototype);
        proto.constructor = Constructor;

        proto.getId = function () {
            return this.queryName;
        };
        proto.setId = function (entityName) {
            this.queryName = entityName;
        };
        proto.getParentCategory = function () {
            return this.domainCategory;
        };
        proto.setParentCategory = function (parentCategory) {
            this.domainCategory = parentCategory;
        };

        return Constructor;
    }

    function class_DataEdit() {
        function Constructor(editId, saveEditId, cancelEditId) {
            this.edit$ = $('#' + editId);
            this.editableData = null;
            this.message = '';

            var saveEdit$ = this.saveEdit$ = $('#' + saveEditId);
            var cancelEdit$ = this.cancelEdit$ = $('#' + cancelEditId);
            this.bindFormToData();
            saveEdit$.click(gtc.bindTimeout(this.saveEdit.bind(this)));
            cancelEdit$.click(gtc.bindTimeout(this.cancelEdit.bind(this)));
        }

        var proto = Constructor.prototype;

        proto.getBoundInputIdPrefix = function () {
            return '';
        };
        proto.getEditableDataURL = function () {
            // abstract;
        };
        proto.bindFormToData = function () {
            var _this = this;
            var boundInputIdPrefix = this.getBoundInputIdPrefix();
            var boundInputAttrPattern = '[id^=' + boundInputIdPrefix + ']';
            this.edit$
                .find('input' + boundInputAttrPattern +
                    ',textarea' + boundInputAttrPattern +
                    ',select' + boundInputAttrPattern)
                .change(function (event) {
                    var elem$ = $(event.target);
                    _this.editableData[elem$.attr('id').substring(boundInputIdPrefix.length)] = elem$.val();
                });
        };
        proto.saveEdit = function () {
            if (!this.beforeSave()) return;

            var waitWidget = gtc.showWaiting('拼命执行中...');
            if (this._saved = this.outputDataToService()) {
                this.onSaveSucceeded();
            } else {
                this.onSaveFailed();
            }
            gtc.hideWaiting(waitWidget);
        };
        proto.beforeSave = function () {
            this.updateDataFromForm();
            return true;
        };
        proto.onSaveSucceeded = function () {
            gtc.showMessage('保存成功');
        };
        proto.onSaveFailed = function () {
            gtc.showError(this.message);
        };
        proto.cancelEdit = function () {
            if (!this._saved) {
                this.rollbackEditing();
            }
            this.endEditing();
        };
        proto.updateDataFromForm = function () {
            // abstract;
        };
        proto.updateFormFromData = function (detached) {
            var editableData = this.editableData;
            if (editableData) {
                var boundInputIdPrefix = this.getBoundInputIdPrefix();
                var boundInputAttrPattern = '[id^=' + boundInputIdPrefix + ']';
                this.edit$.find('input' + boundInputAttrPattern + ',textarea' + boundInputAttrPattern)
                    .each(function (_, inputElement) {
                        var fieldName = inputElement.id.substring(boundInputIdPrefix.length);
                        $(inputElement).val(editableData ? editableData[fieldName] : null);
                    });
                this.edit$.find('select' + boundInputAttrPattern)
                    .each(function (_, selectElement) {
                        var fieldName = selectElement.id.substring(boundInputIdPrefix.length);
                        var fieldValue = editableData ? editableData[fieldName] : null;
                        var select$ = $(selectElement);
                        select$.find('option').attr('selected', false);
                        if (fieldValue == null) {
                            select$.val(null);
                        } else {
                            select$.find('option[value=' + fieldValue + ']').attr('selected', true);
                        }
                        select$.trigger('change');
                    });
            }
        };
        proto.outputDataToService = function () {
            return true;
        };
        proto.rollbackEditing = function () {
            // abstract
        };
        proto.beginEditing = function (treeNode) {
            this._saved = false;
        };
        proto.endEditing = function () {
            // abstract
        };

        return Constructor;
    }

    function class_DomainTree_extends(DataEdit) {
        function Constructor(treeId, editId, saveEditId, cancelEditId) {
            'use strict';
            DataEdit.call(this, editId, saveEditId, cancelEditId);

            this.tree$ = $('#' + treeId);
            this.treePreviewer$ = $('#' + treeId + '-previewer');
            this.previewerTile$ = this.treePreviewer$.find('h3');
            this.previewerAttributes$ = this.treePreviewer$.find('table tbody');
            this._className = "dark";
            this.beingEditedNode = null;

            var setting = {
                view: {
                    addHoverDom: gtc.bindTimeout(this.addHoverDom.bind(this)),
                    removeHoverDom: gtc.bindTimeout(this.removeHoverDom.bind(this)),
                    selectedMulti: false
                },
                data: {
                    keep: {
                        parent: true
                    }
                },
                edit: {
                    enable: true,
                    removeTitle: '删除',
                    renameTitle: '修改',
                    showRemoveBtn: this.canShowRemoveBtn.bind(this),//todo
                    showRenameBtn: this.canShowRenameBtn.bind(this),//todo
                    drag: {
                        isMove: true,
                        isCopy: false
                    }
                },
                callback: {
                    onClick: gtc.bindTimeout(this.onClick.bind(this)),
                    beforeDrag: this.beforeDrag.bind(this),
                    beforeEditName: this.beforeEditName.bind(this),
                    beforeRename: this.beforeRename.bind(this),
                    onRename: gtc.bindTimeout(this.onRename.bind(this)),
                    beforeRemove: this.beforeRemove.bind(this),
                    onRemove: gtc.bindTimeout(this.onRemove.bind(this)),
                    onDrop: gtc.bindTimeout(this.onDrop.bind(this))
                }
            };
            var rootCategories = gtc.getData(this.getRootCategoryURI()).data;
            var _this = this;
            this.zTreeObj = $.fn.zTree.init(_this.tree$, setting,
                rootCategories.map(function (rootCategory) {
                    return _this.categoryToNode(rootCategory, false);
                }));
        }

        var FieldRole = Constructor.FieldRole = {
            ID: 'id',
            KEY: 'key',
            VALUE: 'value',
            NAME: 'name',
            DESCRIPTION: 'description',
            RESOURCES: 'resources',
            CHILD_CATEGORIES: 'childCategories',
            PARENT_CATEGORY: 'parentCategory'
        };

        var parentProto = DataEdit.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;
        override.getBoundInputIdPrefix = function () {
            return this.getResourceTypeName() + '-';
        };
        override.getEditableDataURL = function () {
            return this.getRootCategoryURL();
        };
        override.onSaveSucceeded = function () {
            this.updateNodeFromData(this.beingEditedNode, this.getIdFromEditableData(this.editableData));
            gtc.showMessage('保存成功');
        };
        override.outputDataToService = function () {
            var treeNode = this.beingEditedNode;
            var editableData = this.editableData;
            var isNew = !treeNode._data;
            var url = this.getEditableDataURL();
            if (!isNew) {
                url += '/' + this.getIdFromEditableData(editableData);
            }
            try {
                (isNew ? gtc.postData : gtc.putData)(url, editableData);
            } catch (e) {
                this.message = e;
                return false;
            }
            return true;
        };
        override.rollbackEditing = function () {
            if (this.beingEditedNode._data == null) {
                this.zTreeObj.removeNode(this.beingEditedNode);
            }
        };
        override.beginEditing = function (treeNode) {
            parentProto.beginEditing.call(this, treeNode);
            this.beingEditedNode = treeNode;
            this.treePreviewer$.hide();
            this.tree$.hide();
            this.edit$.show();
        };
        override.endEditing = function () {
            this.beingEditedNode = null;
            this.edit$.hide();
            this.tree$.show();
        };
        proto.editableDataFieldNameByRole = function (fieldRole) {
            return fieldRole;
        };
        proto.editableDataFieldValueByRole = function (editableData, fieldRole) {
            var fieldName = this.editableDataFieldNameByRole(fieldRole);
            return fieldName && editableData[fieldName];
        };
        proto.isCategoriesOnly = function () {
            return true;
        };
        proto.getEditableDataConstructor = function () {
            return DomainCategory;
        };
        proto.getDraggableDataConstructor = function () {
            return this.getEditableDataConstructor();
        };
        proto.getEditableDataTypeDescription = function () {
            return '业务分类';
        };
        proto.getResourceTypeName = function () {
            return '';
        };
        proto.getRootCategoryURL = function () {
            return settings.apiURLs.categoryCenter.domainCategory;
        };
        proto.getRootCategoryURI = function () {
            return this.getRootCategoryURL() + (this.isCategoriesOnly() ? '' : '?type=' + this.getResourceTypeName());
        };
        proto.getDomainResourceURL = function () {
            return settings.apiURLs.categoryCenter.domainResource;
        };
        proto.getDraggableDataURL = function () {
            return this.getEditableDataURL();
        };
        proto.categoryToNode = function (category, expand) {
            var name = this.editableDataFieldValueByRole(category, FieldRole.NAME);
            var description = this.editableDataFieldValueByRole(category, FieldRole.DESCRIPTION);
            var childCategories = this.editableDataFieldValueByRole(category, FieldRole.CHILD_CATEGORIES) || [];
            var resources = this.editableDataFieldValueByRole(category, FieldRole.RESOURCES) || [];
            var _this = this;
            return {
                name: description == null ? name : name + ' (' + description + ')',
                open: !!expand,
                children: childCategories
                    .map(function (childCategory) {
                        return _this.categoryToNode(childCategory, expand);
                    })
                    .concat(resources
                        .map(function (resource) {
                            return {
                                name: _this.editableDataFieldValueByRole(resource, FieldRole.KEY),
                                isParent: false,
                                _data: resource
                            };
                        })
                    ),
                _data: _this.categoryToNodeData(category)
            }
        };
        proto.onClick = function (event, treeId, treeNode) {
            this.refreshPreview(treeNode);
        };
        proto.canShowRemoveBtn = function (treeId, treeNode) {
            return !treeNode.isParent || this.isCategoriesOnly();
        };
        proto.canShowRenameBtn = function (treeId, treeNode) {
            return !treeNode.isParent || this.isCategoriesOnly();
        };
        proto.beforeDrag = function (treeId, treeNodes) {
            var treeNode = treeNodes[0];
            return treeNode._data && (!treeNode.isParent || this.isCategoriesOnly());
        };
        proto.beforeEditName = function (treeId, treeNode) {
            if (this.isCategoriesOnly() !== treeNode.isParent) {
                return false;
            }
            this._className = (this._className === "dark" ? "" : "dark");
            this.zTreeObj.selectNode(treeNode);
            this.updateDataFromNode(treeNode);
            this.updateFormFromData();
            this.beginEditing(treeNode);
            return false;
        };
        proto.beforeRename = function (treeId, treeNode, newName, isCancel) {
        };
        proto.onRename = function (event, treeId, treeNode, isCancel) {
        };
        proto.addHoverDom = function (treeId, treeNode) {
            if (this.beingEditedNode != null || !treeNode.isParent) {
                return;
            }
            var sObj = $("#" + treeNode.tId + "_span");
            var addBtnSelector = "#addBtn_" + treeNode.tId;
            if (treeNode.editNameFlag || $(addBtnSelector).length > 0) return;

            var addStr = "<span class='button add' id='addBtn_" + treeNode.tId
                + "' title='增加" + this.getEditableDataTypeDescription() + "' onfocus='this.blur();'></span>";
            sObj.after(addStr);

            var _this = this;
            $(addBtnSelector).click(function (event) {
                _this.onClickAddNode(treeNode, event);
                return false;
            });
        };
        proto.onClickAddNode = function (treeNode, event) {
            var defaultName = '新增' + this.getEditableDataTypeDescription();
            var newNode = this.zTreeObj.addNodes(treeNode,
                {
                    id: null,
                    pId: treeNode && treeNode.id,
                    name: defaultName,
                    isParent: this.isCategoriesOnly(),
                    _data: null
                })[0];
            this.updateDataFromNode(newNode);
            this.updateFormFromData(true);
            this.beginEditing(newNode);
        };
        proto.removeHoverDom = function (treeId, treeNode) {
            if (this.beingEditedNode != null || !treeNode.isParent) {
                return;
            }
            $("#addBtn_" + treeNode.tId).unbind().remove();
        };
        proto.beforeRemove = function (treeId, treeNode) {
            if (this.isCategoriesOnly() !== treeNode.isParent) {
                return false;
            }
            this._className = (this._className === "dark" ? "" : "dark");
            this.zTreeObj.selectNode(treeNode);
            return confirm("确认删除" + this.getEditableDataTypeDescription() + '“' + treeNode.name + "”吗？");
        };
        proto.onRemove = function (e, treeId, treeNode) {
            var data = treeNode._data;
            var _this = this;
            var waitWidget = gtc.showWaiting('执行删除中...');
            try {
                gtc.deleteData(_this.getEditableDataURL() + '/' +
                    (_this.isCategoriesOnly() ? _this.getIdFromEditableData(data) : data.key));
            } catch (e) {
                gtc.showError('删除失败，请刷新页面');
            }
            gtc.hideWaiting(waitWidget);
            _this.treePrevittewer$.hide();
        };
        proto.onDrop = function (event, treeId, treeNodes, targetNode) {
            var treeNode = treeNodes[0];
            var data = treeNode._data;
            var parentNode = treeNode.getParentNode();
            this.setParentCategoryToEditableData(data, parentNode ? new DomainCategorySlice(parentNode._data) : null);
            var _this = this;
            var waitWidget = gtc.showWaiting('执行移动中...');
            try {
                gtc.putData(_this.getDraggableDataURL() + '/' + _this.getIdFromDraggableData(data), data);
            } catch (e) {
                gtc.showError('移动失败，请刷新页面');
            }
            gtc.hideWaiting(waitWidget);
        };
        proto.getIdFromEditableData = function (data) {
            if (data == null) {
                return null;
            }
            return this.getEditableDataConstructor().prototype.getId.call(data);
        };
        proto.getIdFromDraggableData = function (data) {
            if (data == null) {
                return null;
            }
            return this.getDraggableDataConstructor().prototype.getId.call(data);
        };
        proto.setIdToEditableData = function (data, id) {
            if (data == null) {
                return;
            }
            this.getEditableDataConstructor().prototype.setId.call(data, id);
        };
        proto.setParentCategoryToEditableData = function (data, parentCategory) {
            if (data == null) {
                return;
            }
            this.getEditableDataConstructor().prototype.setParentCategory.call(data, parentCategory);
        };
        proto.categoryToNodeData = function (category) {
            var nodeData = new DomainCategory(category.parentCategory);
            nodeData.name = category.name;
            nodeData.description = category.description;
            nodeData.id = category.id;
            return nodeData;
        };
        proto.updateDataFromNode = function () {
            // abstract;
        };
        proto.updateNodeFromData = function (treeNode, editableDataId) {
            // abstract
        };
        proto.refreshPreview = function (treeNode) {
            // abstract
        };
        proto.showNodeDetail = function (title, attributes) {
            this.previewerTile$.html(title);
            var attributes$ = this.previewerAttributes$;
            attributes$.find('tr').empty();
            (attributes || []).forEach(function (attr) {
                var value = attr.value == null ? '' : attr.value;
                $('<tr>' +
                    '  <td class="previewer-key">' + attr.key + '</td>' +
                    '  <td class="previewer-value">' + value + '</td>' +
                    '</tr>')
                    .appendTo(attributes$);
            });
            this.treePreviewer$.show();
        };

        return Constructor;
    }

    function class_DomainResourceTree_extends(DomainTree) {
        function Constructor(treeId, editId, saveEditId, cancelEditId) {
            DomainTree.call(this, treeId, editId, saveEditId, cancelEditId);
        }

        var proto = Constructor.prototype = Object.create(DomainTree.prototype);
        proto.constructor = Constructor;

        proto.isCategoriesOnly = function () {
            return false;
        };
        proto.getDraggableDataURL = function () {
            return settings.apiURLs.categoryCenter.domainResource;
        };
        proto.getDraggableDataConstructor = function () {
            return DomainResource;
        };
        proto.updateDataFromNode = function (treeNode) {
            var editableData;
            if (treeNode._data) {
                editableData = gtc.getData(this.getEditableDataURL() + '/' + treeNode._data.key);
            } else {
                var EditableDataConstructor = this.getEditableDataConstructor();
                editableData = new EditableDataConstructor(treeNode.getParentNode()._data);
                this.setIdToEditableData(editableData, treeNode.name);
            }
            this.editableData = editableData;
        };
        proto.updateNodeFromData = function (treeNode, editableDataId) {
            if (!treeNode._data) {
                var parentData = treeNode.getParentNode()._data;
                var domainResource = treeNode._data = new DomainResource(parentData);
                domainResource.key = editableDataId;
                var resources = gtc.getData(settings.apiURLs.categoryCenter.domainCategory + '/' +
                    parentData.id + '?type=' + this.getResourceTypeName()).resources || [];
                var resource = null;
                var i;
                for (i = resources.length - 1; i >= 0; i--) {
                    resource = resources[i];
                    if (resource.key === editableDataId) {
                        treeNode.id = resource.id;
                        break;
                    }
                }
            }
            treeNode.name = editableDataId;
            this.zTreeObj.updateNode(treeNode);
        };
        return Constructor;
    }
});
