layui.use(['gtc', 'gtc-data-edit', 'settings'], function () {
    'use strict';
    // configurations
    var SELECTED_ELM_CLS = 'selected';
    var DBCNN_TREE_ELM_ID = 'connection-tree';
    var DBCNN_TAB_ELM_ID = 'connection-table';

    var DBCNN_NAME_ELM_ID = 'connection-name';
    var DBCNN_DRIVER_ELM_ID = 'connection-jdbcDriver';
    var DBCNN_DIALECT_ELM_ID = 'connection-sqlDialect';

    var TITLE_ELM_ID = 'title';
    var CRUMB_ELM_ID = 'crumb-2';

    var settings = layui.settings;
    var gtc = layui.gtc;
    var DatabaseConnection = gtc.DatabaseConnection;

    var DatabaseConnectionEdit = class_DatabaseConnectionEdit_extends(gtc.DataEdit);
    return new DatabaseConnectionEdit();

    function class_DatabaseConnectionEdit_extends(DataEdit) {
        var TR_CLASS_READONLY = 'readonly';

        var JDBC_DRIVERS = [
            'com.mysql.jdbc.Driver',
            'oracle.jdbc.driver.OracleDriver',
            'org.postgresql.Driver'
        ];
        var SQL_DIALECTS = {
            'com.mysql.jdbc.Driver': [
                'org.hibernate.dialect.MySQLDialect',
                'org.hibernate.dialect.MySQLInnoDBDialect',
                'org.hibernate.dialect.MySQLMyISAMDialect'
            ],
            'oracle.jdbc.driver.OracleDriver': [
                'org.hibernate.dialect.OracleDialect',
                'org.hibernate.dialect.Oracle9iDialect',
                'org.hibernate.dialect.Oracle10gDialect'
            ],
            'org.postgresql.Driver': [
                'org.hibernate.dialect.PostgreSQLDialect'
            ]
        };

        function Constructor() {
            DataEdit.call(this, 'connection-edit', 'save-connection-edit', 'cancel-connection-edit');

            this.tree$ = $('#' + DBCNN_TREE_ELM_ID);
            this.insertion$ = $('#connection-insertion');
            this._cachedData = null;
            this._dbConnTableCols = [[
                {field: 'name', title: '名称', edit: 'text', minWidth: 150},
                {field: 'description', title: '描述', edit: 'text', minWidth: 150},
                {field: 'jdbcUrl', title: 'JDBC URL', edit: 'text', minWidth: 300},
                {toolbar: '#toolbar', fixed: 'right', width: 100}
            ]];
            this.initDbConnTable();
            this._initEditor();
            setTimeout(this.reloadDbConnTable.bind(this), 0);
            var _this = this;
            this.insertion$.click(function () {
                _this.tree$.find('li input.' + SELECTED_ELM_CLS).removeClass(SELECTED_ELM_CLS);
                _this.insertion$.find('input').addClass(SELECTED_ELM_CLS);
                _this.editableData = new DatabaseConnection();
                _this.updateFormFromData();
                _this.beginEditing();
            })
        }

        var parentProto = DataEdit.prototype;
        var proto = Constructor.prototype = Object.create(parentProto);
        proto.constructor = Constructor;
        var override = proto;

        override.getBoundInputIdPrefix = function () {
            return 'connection-';
        };
        override.getEditableDataURL = function () {
            return settings.apiURLs.modelCenter.databaseConnection;
        };
        override.outputDataToService = function () {
            var dbConn = this.editableData;
            var isNew = !$('#' + DBCNN_NAME_ELM_ID).attr('disabled');
            var url = this.getEditableDataURL();
            if (!isNew) {
                url += '/' + this.dbConn.name;
            }
            try {
                (isNew ? gtc.postData : gtc.putData)(url, dbConn);
            } catch (e) {
                this.message = e;
                return false;
            }
            return true;
        };
        override.rollbackEditing = function () {
            this._inputDataFromCache();
            this.updateFormFromData();
        };
        override.beginEditing = function () {
            this.tree$.hide();
            this.edit$.show();
            var persisted = this.editableData.name != null;
            this.edit$.find('#' + DBCNN_NAME_ELM_ID).attr('disabled', persisted);
            var title = '数据连接编辑';
            var crumb$ = $('#' + CRUMB_ELM_ID);
            crumb$.find('span').html(title);
            crumb$.show();
            $('#' + TITLE_ELM_ID + ' span').html(title);
        };
        override.endEditing = function () {
            this.reloadDbConnTable();
            this.edit$.hide();
            this.tree$.show();
            $('#' + CRUMB_ELM_ID).hide();
            $('#' + TITLE_ELM_ID + ' span').html('数据库连接');
        };

        proto.reloadDbConnTable = function () {
            try {
                var dbConns = gtc.getData(this.getEditableDataURL()).data;
                if (dbConns) {
                    this._dbConnTable.reload({data: this._dbConns = dbConns});
                    $('#' + DBCNN_TREE_ELM_ID + ' tr')
                        .addClass(TR_CLASS_READONLY)
                        .find('input, select').attr('disabled', true);
                }
            } catch (e) {
                layer.msg('读取数据库连接列表失败');
            }
        };
        proto.initDbConnTable = function (data) {
            this._dbConnTable = layui.table.render({
                elem: '#' + DBCNN_TAB_ELM_ID,
                limit: 999,
                cols: this._dbConnTableCols,
                data: data || []
            });

            var _this = this;
            layui.table.on('tool(dbConns)', function (obj) {
                var dbConns = _this._dbConns;
                var dbConnIndex = 1 * obj.tr.selector.match(/data-index="(\d+)"/)[1];
                switch (obj.event) {
                    case 'edit':
                        _this.editableData = dbConns[dbConnIndex];
                        _this.updateFormFromData();
                        _this.beginEditing();
                        break;
                    case 'del':
                        layer.confirm('真的删除行么', function (index) {
                            obj.del();
                            fields.splice(dbConnIndex, 1);
                            _this.reloadDbConnTable();
                            layer.close(index);
                        });
                        break;
                    default:
                        break;
                }
            });
        };
        proto._initEditor = function () {
            var driverSelect$ = $('#' + DBCNN_DRIVER_ELM_ID);
            var sqlDialect$ = $('#' + DBCNN_DIALECT_ELM_ID);
            JDBC_DRIVERS.forEach(function (driver) {
                $('<option value="' + driver + '">' + driver + '</option>')
                    .appendTo(driverSelect$);
                driverSelect$.change(function () {
                    sqlDialect$.empty();
                    (SQL_DIALECTS[driverSelect$.val()] || []).forEach(function (dialect) {
                        $('<option value="' + dialect + '">' + dialect + '</option>')
                            .appendTo(sqlDialect$);
                    })
                });
            });
            $('#test-connection').click(this.testConnection.bind(this));
        };
        proto._inputDataFromService = function () {
            var reply = gtc.getData(this.getEditableDataURL());
            if ((reply.code || reply.status) >= 400) {
                layer.msg(reply.message);
            } else {
                this.editableData = reply.data;
                this.updateFormFromData();
            }
        };
        proto._inputDataFromCache = function () {
            this.editableData = JSON.parse(JSON.stringify(this._cachedData));
        };
        proto._outputDataToCache = function () {
            this._cachedData = JSON.parse(JSON.stringify(this.editableData));
        };
        proto.testConnection = function () {
            try {
                var widget = gtc.showWaiting('正在测试数据库连接');
                if (JSON.stringify(gtc.patchData(this.getEditableDataURL(), this.editableData))) {
                    gtc.showMessage('数据库连接测试成功');
                } else {
                    gtc.showError('数据库连接测试失败');
                }
            } catch (e) {
                gtc.showError('数据库连接测试失败');
            } finally {
                gtc.hideWaiting(widget);
            }
        };

        return Constructor;
    }
});