layui.use(['gtc', 'settings', 'gtc-data-edit'], function () {
    'use strict';
    var settings = layui.settings;
    var gtc = layui.gtc;
    var DomainCategory = gtc.DomainCategory;

    var DomainCategoryTree = class_DomainCategoryTree_extends(gtc.DomainTree);
    return new DomainCategoryTree();

    function class_DomainCategoryTree_extends(DomainTree) {
        function Constructor() {
            DomainTree.call(this, 'category-tree', 'category-edit', 'save-category-edit', 'cancel-category-edit');

            $('#category-create').click(this.onClickAddNode.bind(this, null));
        }

        var proto = Constructor.prototype = Object.create(DomainTree.prototype);
        proto.constructor = Constructor;
        var override = proto;

        override.isCategoriesOnly = function () {
            return true;
        };
        override.getEditableDataConstructor = function () {
            return DomainCategory;
        };
        override.getEditableDataTypeDescription = function () {
            return '业务分类';
        };
        override.getEditableDataURL = function () {
            return settings.apiURLs.categoryCenter.domainCategory;
        };
        override.getResourceTypeName = function () {
            return 'category';
        };
        override.updateDataFromNode = function (treeNode) {
            var domainCategory = treeNode._data;
            if (domainCategory == null) {
                var EditableDataConstructor = this.getEditableDataConstructor();
                var parentNode = treeNode.getParentNode();
                domainCategory = parentNode == null ? new EditableDataConstructor() :
                    new EditableDataConstructor(parentNode._data);
                domainCategory.name = domainCategory.description = treeNode.name;
            }
            this.editableData = domainCategory;
        };
        override.updateNodeFromData = function (treeNode, editableDataId) {
            var editableData = this.editableData;
            if (!treeNode._data) {
                this.setIdToEditableData(editableData, editableDataId);
                treeNode._data = editableData;
            }
            treeNode.name = editableData.name + ' (' + editableData.description + ')';
            this.zTreeObj.updateNode(treeNode);
        };
        override.refreshPreview = function (treeNode) {
            var data = treeNode._data;
            if (data) {
                this.showNodeDetail('业务分类', [
                    {key: 'ID：', value: data.id},
                    {key: '名称：', value: data.name},
                    {key: '描述：', value: data.description}
                ]);
            } else {
                this.treePreviewer$.hide();
            }
        };
        return Constructor;
    }
});