/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.ui.web;

import cn.gtmap.gtc.ui.client.MicroRestClient;
import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.MethodNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore
@RestController
@RequestMapping(value={"/api"})
public class ApiController {
    private static final Logger log = LoggerFactory.getLogger(ApiController.class);
    private final MicroRestClient microRestClient;
    private final String baseUrlRegex;
    private final Map<String, String> apiServices;

    @Autowired
    public ApiController(MicroRestClient microRestClient, Map<String, String> apiServices) {
        this.microRestClient = microRestClient;
        this.apiServices = apiServices;
        String[] baseURLs = this.getClass().getAnnotation(RequestMapping.class).value();
        String regex = null;
        switch (baseURLs.length) {
            case 0: {
                break;
            }
            case 1: {
                regex = baseURLs[0].replaceAll("^\\/", "").replaceAll("\\/$", "");
                break;
            }
            default: {
                regex = String.format("(%s)", Arrays.stream(baseURLs).map(url -> String.format("(%s)", url.replaceAll("^\\/", "").replaceAll("\\/$", ""))).reduce((urls, url) -> String.format("%s|%s", urls, url)).orElse(""));
            }
        }
        this.baseUrlRegex = Strings.isNullOrEmpty(regex) ? "" : regex + '/';
    }

    @RequestMapping(value={"{serviceName}/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public Object accessDatabaseConnection(@PathVariable String serviceName, @RequestParam Map<String, String> requestParams, @RequestHeader Map<String, String> requestHeaders, @RequestBody(required=false) String requestBody, HttpServletRequest request) throws URISyntaxException, IOException, MethodNotSupportedException {
        String requestMethod;
        String path = request.getServletPath().replaceFirst(String.format("^\\/?%s%s\\/?", this.baseUrlRegex, serviceName), "");
        log.info(path);
        String profiledServiceName = this.apiServices.getOrDefault(serviceName, serviceName);
        String requestLocation = this.microRestClient.getServiceLocation(profiledServiceName, path);
        switch (requestMethod = request.getMethod().toUpperCase()) {
            case "GET": {
                return this.microRestClient.get(requestLocation, requestParams, requestHeaders);
            }
            case "POST": {
                return this.microRestClient.post(requestLocation, requestParams, requestHeaders, (Object)requestBody);
            }
            case "PUT": {
                return this.microRestClient.put(requestLocation, requestParams, requestHeaders, (Object)requestBody);
            }
            case "PATCH": {
                return this.microRestClient.patch(requestLocation, requestParams, requestHeaders, (Object)requestBody);
            }
            case "DELETE": {
                return this.microRestClient.delete(requestLocation, requestParams, requestHeaders);
            }
        }
        throw new MethodNotSupportedException(requestMethod);
    }
}

