/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.ui.configure;

import cn.gtmap.gtc.ui.interceptor.CommonInterceptor;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebConfig
extends WebMvcConfigurerAdapter {
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new CommonInterceptor()).addPathPatterns(new String[]{"/**"});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"classpath:/static/"});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        StringHttpMessageConverter converter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        converters.add((HttpMessageConverter<?>)converter);
    }

    @Bean
    public RestTemplate getRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        List messageConverters = restTemplate.getMessageConverters();
        int i = messageConverters.size();
        while (i-- > 0) {
            if (!(messageConverters.get(i) instanceof StringHttpMessageConverter)) continue;
            messageConverters.remove(i);
            messageConverters.add(i, new StringHttpMessageConverter(StandardCharsets.UTF_8));
            break;
        }
        return restTemplate;
    }

    @Bean
    public HttpClient getHttpClient() {
        return HttpClients.createDefault();
    }

    @Bean(value={"apiServices"})
    @ConfigurationProperties(prefix="app.services")
    public Map<String, String> getApiServices() {
        return new HashMap<String, String>();
    }
}

