/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.http.exception.ResourceException;
import cn.gtmap.gtc.model.domain.entity.QueryMeta;
import cn.gtmap.gtc.model.service.QueryMetaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="v1QueryMetaController")
@RequestMapping(value={"/v1/query-definitions"})
@Api(value="\u67e5\u8be2\u5b9a\u4e49\u7ba1\u7406")
public class QueryMetaController {
    private static final Logger log = LoggerFactory.getLogger(QueryMetaController.class);
    private final QueryMetaService queryMetaService;

    @Autowired
    public QueryMetaController(QueryMetaService queryMetaService) {
        this.queryMetaService = queryMetaService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5b9a\u4e49\u521b\u5efa")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public String insert(@ApiParam(value="\u67e5\u8be2\u5b9a\u4e49") @RequestBody QueryMeta queryMeta) {
        QueryMeta query = this.queryMetaService.insert(queryMeta);
        return query.getQueryName();
    }

    @ApiOperation(value="\u67e5\u8be2\u5b9a\u4e49\u67e5\u8be2")
    @GetMapping
    public PageResult<QueryMeta> list(@ApiParam(value="\u5173\u952e\u8bcd") @RequestParam(value="q", required=false) String keyword, @PageableDefault Pageable pageable) {
        Page queryMetaPage;
        Page page = queryMetaPage = keyword == null ? this.queryMetaService.list(pageable) : this.queryMetaService.list(keyword, pageable);
        if (queryMetaPage == null) {
            throw new ResourceException("\u672a\u67e5\u627e\u5230\u67e5\u8be2\u5b9a\u4e49", HttpStatus.NOT_FOUND);
        }
        return PageResult.from((Page)queryMetaPage);
    }

    @ApiOperation(value="\u5355\u4e2a\u67e5\u8be2\u5b9a\u4e49\u67e5\u8be2")
    @GetMapping(value={"{queryName}"})
    public QueryMeta get(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName) {
        QueryMeta query = this.queryMetaService.get(queryName);
        if (query == null) {
            throw new ResourceException("\u672a\u67e5\u627e\u5230\u67e5\u8be2\u5b9a\u4e49" + queryName, HttpStatus.NOT_FOUND);
        }
        return query;
    }

    @ApiOperation(value="\u67e5\u8be2\u5b9a\u4e49\u66f4\u65b0")
    @PutMapping(value={"{queryName}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName, @ApiParam(value="\u67e5\u8be2\u5b9a\u4e49") @RequestBody QueryMeta queryMeta) {
        queryMeta.setQueryName(queryName);
        this.queryMetaService.update(queryMeta);
    }

    @ApiOperation(value="\u67e5\u8be2\u5b9a\u4e49\u5220\u9664")
    @DeleteMapping(value={"{queryName}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName) {
        this.queryMetaService.delete(queryName);
    }
}

