/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.http.exception.ResourceException;
import cn.gtmap.gtc.model.domain.dto.AnonymousQuery;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityCrudServiceQueryServiceSelfImpl;
import cn.gtmap.gtc.model.service.QueryMetaService;
import cn.gtmap.gtc.model.service.QueryService;
import cn.gtmap.gtc.model.service.QueryServicePeerImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u67e5\u8be2")
@CrossOrigin(origins={"*"}, allowCredentials="false")
@RestController(value="v1QueryController")
@RequestMapping(value={"/v1/queries"})
public class QueryController {
    private static final Logger log = LoggerFactory.getLogger(QueryController.class);
    private final QueryService localQueryService;
    private final QueryService remoteQueryService;
    private final QueryMetaService queryMetaService;
    private final CoordinationService coordinationService;

    @Autowired
    public QueryController(EntityCrudServiceQueryServiceSelfImpl entityCrudServiceQueryServiceSelfImpl, QueryServicePeerImpl queryServicePeerImpl, QueryMetaService queryMetaService, CoordinationService coordinationService) {
        this.localQueryService = entityCrudServiceQueryServiceSelfImpl;
        this.remoteQueryService = queryServicePeerImpl;
        this.queryMetaService = queryMetaService;
        this.coordinationService = coordinationService;
    }

    @ApiOperation(value="\u4f9d\u636e\u533f\u540d\u7684\u67e5\u8be2\u67e5\u8be2")
    @PostMapping
    public PageResult<Object> listByQueryStatement(@ApiParam(value="\u67e5\u8be2\u53c2\u6570") @RequestBody AnonymousQuery anonymousQuery, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @PageableDefault Pageable pageable) {
        QueryService queryService = this.getQueryServiceByDbConnName(anonymousQuery.getDatabaseConnectionName(), redirected);
        Page resultPage = queryService.listByAnonymousQuery(anonymousQuery.getStatement(), anonymousQuery.getParameters(), anonymousQuery.getLanguage(), anonymousQuery.getDatabaseConnectionName(), pageable);
        if (resultPage == null) {
            throw new ResourceException("\u67e5\u8be2\u5931\u8d25", HttpStatus.NOT_FOUND);
        }
        return PageResult.from((Page)resultPage);
    }

    @ApiOperation(value="\u4f9d\u636e\u547d\u540d\u7684\u67e5\u8be2\u67e5\u8be2")
    @PostMapping(value={"{queryName}"})
    public PageResult<Object> listByNamedQuery(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName, @ApiParam(value="\u67e5\u8be2\u53c2\u6570") @RequestBody Map<String, Object> queryParams, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @PageableDefault Pageable pageable) {
        QueryService queryService = this.getQueryServiceByQueryName(queryName, redirected);
        Page resultPage = queryService.listByNamedQuery(queryName, queryParams, pageable);
        if (resultPage == null) {
            throw new ResourceException("\u67e5\u8be2\u5931\u8d25", HttpStatus.NOT_FOUND);
        }
        return PageResult.from((Page)resultPage);
    }

    private QueryService getQueryServiceByDbConnName(String dbConnName, boolean redirected) {
        if (redirected) {
            return this.localQueryService;
        }
        return this.coordinationService.canHandle(dbConnName) ? this.localQueryService : this.remoteQueryService;
    }

    private QueryService getQueryServiceByQueryName(String queryName, boolean redirected) {
        if (redirected) {
            return this.localQueryService;
        }
        String dbConnName = this.queryMetaService.get(queryName).getDatabaseConnectionName();
        return this.coordinationService.canHandle(dbConnName) ? this.localQueryService : this.remoteQueryService;
    }
}

