/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.model.domain.dto.EntityTreeMeta;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.model.service.EntityTreeCrudService;
import cn.gtmap.gtc.model.service.EntityTreeCrudServicePeerImpl;
import cn.gtmap.gtc.model.service.EntityTreeCrudServiceSelfImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6a21\u578b\u6811\u5b9e\u4f8b\u7ba1\u7406")
@RestController(value="v1EntityTreeCrudController")
@RequestMapping(value={"/v1/model-trees"})
public class EntityTreeCrudController {
    private final EntityTreeCrudService localEntityTreeCrudService;
    private final EntityTreeCrudService remoteEntityTreeCrudService;
    private final EntityMetaService entityMetaService;
    private final CoordinationService coordinationService;

    @Autowired
    public EntityTreeCrudController(EntityTreeCrudServiceSelfImpl entityTreeCrudServiceSelfImpl, EntityTreeCrudServicePeerImpl entityTreeCrudServicePeerImpl, EntityMetaService entityMetaService, CoordinationService coordinationService) {
        this.localEntityTreeCrudService = entityTreeCrudServiceSelfImpl;
        this.remoteEntityTreeCrudService = entityTreeCrudServicePeerImpl;
        this.entityMetaService = entityMetaService;
        this.coordinationService = coordinationService;
    }

    @ApiOperation(value="\u6a21\u578b\u6811\u6839\u8282\u70b9\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"{modelName}"})
    public PageResult<Object> listRoots(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u952e\u7684\u5b57\u6bb5") @RequestParam(required=false) String keyField, @ApiParam(value="\u7236\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String parentField, @ApiParam(value="\u5b50\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String childrenField, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        EntityTreeCrudService entityTreeCrudService = this.getEntityTreeCrudService(modelName, redirected);
        EntityTreeMeta treeMeta = new EntityTreeMeta(modelName, keyField, parentField, childrenField);
        List roots = entityTreeCrudService.listRoots(treeMeta);
        return PageResult.from((List)roots);
    }

    @ApiOperation(value="\u6a21\u578b\u6811\u8282\u70b9\u4fdd\u5b58")
    @PutMapping(value={"{modelName}/**"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void save(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u952e\u7684\u5b57\u6bb5") @RequestParam(required=false) String keyField, @ApiParam(value="\u7236\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String parentField, @ApiParam(value="\u5b50\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String childrenField, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @RequestBody String jsonString, HttpServletRequest request) {
        String tailPath = this.getTailPath(modelName, request);
        EntityTreeCrudService entityTreeCrudService = this.getEntityTreeCrudService(modelName, redirected);
        EntityTreeMeta treeMeta = new EntityTreeMeta(modelName, keyField, parentField, childrenField);
        entityTreeCrudService.save(treeMeta, tailPath, jsonString);
    }

    @ApiOperation(value="\u6a21\u578b\u6811\u8282\u70b9\u67e5\u8be2")
    @GetMapping(value={"{modelName}/**"})
    public Object get(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u952e\u7684\u5b57\u6bb5") @RequestParam(required=false) String keyField, @ApiParam(value="\u7236\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String parentField, @ApiParam(value="\u5b50\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String childrenField, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, HttpServletRequest request) {
        String tailPath = this.getTailPath(modelName, request);
        EntityTreeCrudService entityTreeCrudService = this.getEntityTreeCrudService(modelName, redirected);
        EntityTreeMeta treeMeta = new EntityTreeMeta(modelName, keyField, parentField, childrenField);
        return entityTreeCrudService.get(treeMeta, tailPath);
    }

    @ApiOperation(value="\u6a21\u578b\u6811\u8282\u70b9\u5220\u9664")
    @DeleteMapping(value={"{modelName}/**"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u952e\u7684\u5b57\u6bb5") @RequestParam(required=false) String keyField, @ApiParam(value="\u7236\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String parentField, @ApiParam(value="\u5b50\u8282\u70b9\u7684\u5b57\u6bb5") @RequestParam(required=false) String childrenField, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, HttpServletRequest request) {
        String tailPath = this.getTailPath(modelName, request);
        EntityTreeCrudService entityTreeCrudService = this.getEntityTreeCrudService(modelName, redirected);
        EntityTreeMeta treeMeta = new EntityTreeMeta(modelName, keyField, parentField, childrenField);
        entityTreeCrudService.delete(treeMeta, tailPath);
    }

    private EntityTreeCrudService getEntityTreeCrudService(String entityName, boolean redirected) {
        if (redirected) {
            return this.localEntityTreeCrudService;
        }
        String dbConnName = this.entityMetaService.get(entityName).getDatabaseConnectionName();
        return this.coordinationService.canHandle(dbConnName) ? this.localEntityTreeCrudService : this.remoteEntityTreeCrudService;
    }

    private String getTailPath(String modelName, HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String headPathRegex = String.format("^(\\/[\\w-]+)*\\/%s", modelName);
        return servletPath.replaceFirst(headPathRegex, "");
    }
}

