/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.http.exception.ResourceException;
import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.service.EntityMetaService;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="v1EntityMetaController")
@RequestMapping(value={"/v1/model-definitions"})
@Api(value="\u6a21\u578b\u5b9a\u4e49\u7ba1\u7406")
public class EntityMetaController {
    private static final Logger log = LoggerFactory.getLogger(EntityMetaController.class);
    private final EntityMetaService entityMetaService;
    private final ObjectMapper objectMapper;

    @Autowired
    public EntityMetaController(EntityMetaService entityMetaService, ObjectMapper objectMapper) {
        this.entityMetaService = entityMetaService;
        this.objectMapper = objectMapper;
    }

    @ApiOperation(value="\u6a21\u578b\u5b9a\u4e49\u521b\u5efa")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public String insert(@RequestBody EntityMeta entityMeta) {
        EntityMeta meta = this.entityMetaService.insert(entityMeta);
        return meta.getEntityName();
    }

    @Deprecated
    @ApiOperation(value="\u6a21\u578b\u5b9a\u4e49\u6279\u91cf\u521b\u5efa\u6216\u4fee\u6539\u6216\u5220\u9664")
    @PatchMapping
    public PageResult<EntityMeta> writeMetas(@RequestBody Map<String, Map<String, Object>> entityMetas) throws IOException {
        LinkedHashMap<String, EntityMeta> metaMap = new LinkedHashMap<String, EntityMeta>();
        for (Map.Entry<String, Map<String, Object>> entry : entityMetas.entrySet()) {
            Map<String, Object> value = entry.getValue();
            metaMap.put(entry.getKey(), value == null ? null : (EntityMeta)this.objectMapper.readValue(this.objectMapper.writeValueAsString(value), EntityMeta.class));
        }
        List metas = this.entityMetaService.writeMetas(metaMap);
        return PageResult.from((List)metas);
    }

    @ApiOperation(value="\u6a21\u578b\u5b9a\u4e49\u67e5\u8be2")
    @GetMapping
    public PageResult<EntityMeta> list(@ApiParam(value="\u6a21\u578b\u5173\u952e\u8bcd") @RequestParam(value="q", required=false) String keyword, @ApiParam(value="\u662f\u5426\u8fd4\u56de\u5b57\u6bb5\u4fe1\u606f") @RequestParam(value="expand", required=false, defaultValue="true") Boolean shouldExpand, @PageableDefault(sort={"entityName"}) Pageable pageable) {
        Page entityMetaPage;
        Page page = entityMetaPage = keyword == null ? this.entityMetaService.list(shouldExpand.booleanValue(), pageable) : this.entityMetaService.list(keyword, shouldExpand.booleanValue(), pageable);
        if (entityMetaPage == null) {
            throw new ResourceException("\u672a\u67e5\u627e\u5230\u6a21\u578b\u5b9a\u4e49", HttpStatus.NOT_FOUND);
        }
        return PageResult.from((Page)entityMetaPage);
    }

    @ApiOperation(value="\u5355\u4e2a\u6a21\u578b\u5b9a\u4e49\u67e5\u8be2")
    @GetMapping(value={"{entityName}"})
    public EntityMeta get(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String entityName) {
        EntityMeta meta = this.entityMetaService.get(entityName);
        if (meta == null) {
            throw new ResourceException("\u672a\u627e\u5230\u6a21\u578b\u5b9a\u4e49", HttpStatus.NOT_FOUND);
        }
        return meta;
    }

    @ApiOperation(value="\u6a21\u578b\u5b9a\u4e49\u4fee\u6539")
    @PutMapping(value={"{entityName}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String entityName, @ApiParam(value="\u6a21\u578b\u5b9a\u4e49") @RequestBody EntityMeta entityMeta) {
        entityMeta.setEntityName(entityName);
        this.entityMetaService.update(entityMeta);
    }

    @ApiOperation(value="\u6a21\u578b\u5b9a\u4e49\u5220\u9664")
    @DeleteMapping(value={"{entityName}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String entityName) {
        this.entityMetaService.delete(entityName);
    }
}

