/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.http.exception.ResourceException;
import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.domain.helpers.CascadeSorter;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityCrudService;
import cn.gtmap.gtc.model.service.EntityCrudServicePeerImpl;
import cn.gtmap.gtc.model.service.EntityCrudServiceQueryServiceSelfImpl;
import cn.gtmap.gtc.model.service.EntityMetaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6a21\u578b\u5b9e\u4f8b\u7ba1\u7406")
@CrossOrigin(origins={"*"}, allowCredentials="false")
@RestController(value="v1EntityCrudController")
@RequestMapping(value={"/v1/models"})
public class EntityCrudController {
    private final String defaultCascadeSorts;
    private final EntityCrudService localEntityCrudService;
    private final EntityCrudService remoteEntityCrudService;
    private final EntityMetaService entityMetaService;
    private final CoordinationService coordinationService;

    @Autowired
    public EntityCrudController(EntityCrudServiceQueryServiceSelfImpl entityCrudServiceQueryServiceSelfImpl, EntityCrudServicePeerImpl entityCrudServicePeerImpl, EntityMetaService entityMetaService, CoordinationService coordinationService, @Value(value="${app.entityCurd.read.defaultCascadeSorts:}") String defaultCascadeSorts) {
        this.localEntityCrudService = entityCrudServiceQueryServiceSelfImpl;
        this.remoteEntityCrudService = entityCrudServicePeerImpl;
        this.entityMetaService = entityMetaService;
        this.coordinationService = coordinationService;
        this.defaultCascadeSorts = defaultCascadeSorts;
    }

    @ApiOperation(value="\u6a21\u578b\u5b9e\u4f8b\u521b\u5efa")
    @PostMapping(value={"{modelName}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Serializable insert(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8b") @RequestBody String requestBody) {
        Serializable entityId = this.getEntityCrudService(modelName, redirected).insert(modelName, requestBody);
        if (entityId == null) {
            throw new ResourceException("\u6a21\u578b\u5b9e\u4f8b\u521b\u5efa\u5931\u8d25", HttpStatus.NOT_FOUND);
        }
        return entityId;
    }

    @ApiOperation(value="\u540c\u4e00\u5b9a\u4e49\u7684\u5168\u90e8\u6a21\u578b\u5b9e\u4f8b\u67e5\u8be2")
    @GetMapping(value={"{modelName}"})
    public PageResult<Object> list(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u9879\u76eeID") @RequestParam(value="proId", required=false) String proId, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @PageableDefault Pageable pageable) {
        Page entityPage;
        EntityCrudService entityCrudService = this.getEntityCrudService(modelName, redirected);
        Page page = entityPage = proId == null ? entityCrudService.list(modelName, pageable) : entityCrudService.list(modelName, proId, pageable);
        if (entityPage == null) {
            throw new ResourceException("\u672a\u67e5\u627e\u5230\u6a21\u578b\u5b9e\u4f8b", HttpStatus.NOT_FOUND);
        }
        return PageResult.from((Page)entityPage);
    }

    @ApiOperation(value="\u5355\u4e2a\u6a21\u578b\u5b9e\u4f8b\u67e5\u8be2")
    @GetMapping(value={"{modelName}/{modelId}/**"})
    public Object get(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, HttpServletRequest request) {
        Object entity;
        String servletPath = request.getServletPath();
        String headPathRegex = String.format("^(\\/[\\w-]+)*\\/%s\\/%s", modelName, modelId);
        String tailPath = servletPath.replaceFirst(headPathRegex, "");
        EntityCrudService entityCrudService = this.getEntityCrudService(modelName, redirected, request.getParameterMap());
        Object object = entity = tailPath.length() == 0 ? entityCrudService.get(modelName, (Serializable)((Object)modelId), new String[0]) : entityCrudService.get(modelName, (Serializable)((Object)modelId), tailPath.replaceFirst("^\\/", "").split("\\/"));
        if (entity == null) {
            throw new ResourceException("\u672a\u67e5\u627e\u5230\u6a21\u578b\u5b9e\u4f8b", HttpStatus.NOT_FOUND);
        }
        return entity;
    }

    @ApiOperation(value="\u6a21\u578b\u5b9e\u4f8b\u66f4\u65b0")
    @PutMapping(value={"{modelName}/{modelId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8b") @RequestBody String requestBody) {
        this.getEntityCrudService(modelName, redirected).update(modelName, (Serializable)((Object)modelId), requestBody);
    }

    @ApiOperation(value="\u6a21\u578b\u5b9e\u4f8b\u90e8\u5206\u5b57\u6bb5\u66f4\u65b0")
    @PatchMapping(value={"{modelName}/{modelId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateFields(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8b") @RequestBody String requestBody) {
        this.getEntityCrudService(modelName, redirected).updateFields(modelName, (Serializable)((Object)modelId), requestBody);
    }

    @ApiOperation(value="\u6a21\u578b\u5b9e\u4f8b\u5220\u9664")
    @DeleteMapping(value={"{modelName}/{modelId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        this.getEntityCrudService(modelName, redirected).delete(modelName, (Serializable)((Object)modelId));
    }

    @Cacheable(value={"localEntityCrudService"})
    public EntityCrudService getLocalEntityCrudService(@NotNull CascadeSorter cascadeSorter) {
        Class<EntityCrudService> entityCrudServiceClass = EntityCrudService.class;
        Object serviceProxy = Proxy.newProxyInstance(entityCrudServiceClass.getClassLoader(), new Class[]{entityCrudServiceClass}, (proxy, method, args) -> {
            String methodName = method.getName();
            Object result = method.invoke((Object)this.localEntityCrudService, args);
            if ("get".equals(methodName)) {
                cascadeSorter.cascadeSort(result);
            }
            return result;
        });
        return (EntityCrudService)serviceProxy;
    }

    private EntityCrudService getEntityCrudService(String entityName, boolean redirected) {
        return this.getEntityCrudService(entityName, redirected, Collections.emptyMap());
    }

    private EntityCrudService getEntityCrudService(String entityName, boolean redirected, Map<String, String[]> parameterMap) {
        EntityMeta entityMeta;
        if (!(redirected || null != (entityMeta = this.entityMetaService.get(entityName)) && this.coordinationService.canHandle(entityMeta.getDatabaseConnectionName()))) {
            return this.remoteEntityCrudService;
        }
        if (parameterMap != null && !parameterMap.isEmpty()) {
            return this.getLocalEntityCrudService(CascadeSorter.of(parameterMap));
        }
        if (!this.defaultCascadeSorts.isEmpty()) {
            return this.getLocalEntityCrudService(CascadeSorter.of((String)this.defaultCascadeSorts));
        }
        return this.localEntityCrudService;
    }
}

