/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web.v1;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.http.exception.ResourceException;
import cn.gtmap.gtc.model.domain.entity.DatabaseConnection;
import cn.gtmap.gtc.model.domain.entity.EntityFieldMeta;
import cn.gtmap.gtc.model.exception.DatabaseConnectionException;
import cn.gtmap.gtc.model.service.DatabaseConnectionService;
import cn.gtmap.gtc.model.service.DatabaseMetaService;
import cn.gtmap.gtc.model.service.DatabaseMetaServicePeerImpl;
import cn.gtmap.gtc.model.service.DatabaseMetaServiceSelfImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u6570\u636e\u5e93\u8fde\u63a5\u7ba1\u7406")
@RestController(value="v1DatabaseConnectionController")
@RequestMapping(value={"/v1/database-connections"})
public class DatabaseConnectionController {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConnectionController.class);
    private final DatabaseConnectionService databaseConnectionService;
    private final DatabaseMetaService remoteDatabaseMetaService;
    private final DatabaseMetaService localDatabaseMetaService;

    public DatabaseConnectionController(@Autowired DatabaseMetaServiceSelfImpl databaseMetaServiceSelfImpl, @Autowired DatabaseMetaServicePeerImpl databaseMetaServicePeerImpl) {
        this.databaseConnectionService = databaseMetaServiceSelfImpl;
        this.localDatabaseMetaService = databaseMetaServiceSelfImpl;
        this.remoteDatabaseMetaService = databaseMetaServicePeerImpl;
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u521b\u5efa")
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public String insert(@ApiParam(value="\u6570\u636e\u5e93\u8fde\u63a5", required=true) @RequestBody DatabaseConnection databaseConnection) {
        return this.databaseConnectionService.insert(databaseConnection).getName();
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u67e5\u8be2")
    @GetMapping
    public PageResult<DatabaseConnection> list(@PageableDefault(sort={"name"}) Pageable pageable) {
        Page databaseConnectionPage = this.databaseConnectionService.list(pageable);
        if (databaseConnectionPage == null) {
            throw new ResourceException("\u672a\u67e5\u627e\u5230\u6570\u636e\u5e93\u8fde\u63a5", HttpStatus.NOT_FOUND);
        }
        return PageResult.from((Page)databaseConnectionPage);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u6d4b\u8bd5")
    @PatchMapping
    public boolean validate(@ApiParam(value="\u6570\u636e\u5e93\u8fde\u63a5", required=true) @RequestBody DatabaseConnection databaseConnection) {
        try {
            return this.databaseConnectionService.validate(databaseConnection);
        }
        catch (DatabaseConnectionException ex) {
            return false;
        }
    }

    @ApiOperation(value="\u5355\u4e2a\u6570\u636e\u5e93\u8fde\u63a5\u67e5\u8be2")
    @GetMapping(value={"{name}"})
    public DatabaseConnection get(@ApiParam(value="\u540d\u79f0") @PathVariable String name) {
        DatabaseConnection connection = this.databaseConnectionService.get(name);
        if (connection == null) {
            throw new ResourceException("\u672a\u67e5\u627e\u5230\u6570\u636e\u5e93\u8fde\u63a5", HttpStatus.NOT_FOUND);
        }
        return connection;
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u66f4\u65b0")
    @PutMapping(value={"{name}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void update(@ApiParam(value="\u540d\u79f0") @PathVariable String name, @ApiParam(value="\u6570\u636e\u5e93\u8fde\u63a5") @RequestBody DatabaseConnection databaseConnection) {
        databaseConnection.setName(name);
        this.databaseConnectionService.update(databaseConnection);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u5220\u9664")
    @DeleteMapping(value={"{name}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@ApiParam(value="\u540d\u79f0") @PathVariable String name) {
        this.databaseConnectionService.delete(name);
    }

    @ApiIgnore
    @GetMapping(value={"{databaseConnectionName}/tables"})
    public PageResult<String> listDatabaseTables(@PathVariable String databaseConnectionName, Pageable pageable, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        DatabaseMetaService databaseMetaService = this.getDatabaseMetaService(redirected);
        Page tables = databaseMetaService.listDatabaseTables(databaseConnectionName, pageable);
        return PageResult.from((Page)tables);
    }

    @ApiIgnore
    @GetMapping(value={"{databaseConnectionName}/tables/{tableName}/fields"})
    public PageResult<EntityFieldMeta> listTableFields(@PathVariable String databaseConnectionName, @PathVariable String tableName, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        DatabaseMetaService databaseMetaService = this.getDatabaseMetaService(redirected);
        List fieldMetas = databaseMetaService.listTableFields(databaseConnectionName, tableName);
        return PageResult.from((List)fieldMetas);
    }

    private DatabaseMetaService getDatabaseMetaService(boolean redirected) {
        return redirected ? this.localDatabaseMetaService : this.remoteDatabaseMetaService;
    }
}

