/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web;

import cn.gtmap.gtc.model.service.CoordinationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore(value="\u670d\u52a1\u96c6\u7fa4\u5185\u90e8\u4f7f\u7528")
@RequestMapping(value={"/shards"})
@RestController
public class ShardController {
    private static final Logger log = LoggerFactory.getLogger(ShardController.class);
    private final CoordinationService coordinationService;

    @Autowired
    public ShardController(CoordinationService coordinationService) {
        this.coordinationService = coordinationService;
    }

    @PutMapping(value={"{shardName}"})
    public void reloadShard(@PathVariable String shardName, @RequestParam Long version) {
        this.coordinationService.updateShardBySelf(shardName, version);
    }

    @DeleteMapping(value={"{shardName}"})
    public void removeShard(@PathVariable String shardName) {
        this.coordinationService.deleteShardBySelf(shardName);
    }
}

