/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web;

import cn.gtmap.gtc.model.common.result.BaseResult;
import cn.gtmap.gtc.model.domain.entity.QueryMeta;
import cn.gtmap.gtc.model.exception.MetaException;
import cn.gtmap.gtc.model.service.QueryMetaService;
import cn.gtmap.gtc.utils.Debugger;
import cn.gtmap.gtc.utils.HttpUtils;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/query-def"})
@Deprecated
public class QueryMetaController {
    private static final Logger log = LoggerFactory.getLogger(QueryMetaController.class);
    private final QueryMetaService queryMetaService;

    @Autowired
    public QueryMetaController(QueryMetaService queryMetaService) {
        this.queryMetaService = queryMetaService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping
    public BaseResult<QueryMeta> insert(@ApiParam(value="\u67e5\u8be2\u5b9a\u4e49") @RequestBody QueryMeta queryMeta) {
        QueryMeta query = null;
        try (Debugger debugger = new Debugger(log, new String[0]);){
            query = this.queryMetaService.insert(queryMeta);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)query, (String[])new String[]{"\u521b\u5efa\u6210\u529f", "\u521b\u5efa\u5931\u8d25"});
            return baseResult;
        }
        catch (RuntimeException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)query, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping
    public BaseResult<List<QueryMeta>> list(@ApiParam(value="\u5173\u952e\u8bcd") @RequestParam(value="q", required=false, defaultValue="") String keyword, @ApiParam(value="\u5206\u9875\u9875\u7801") @RequestParam(value="page", required=false, defaultValue="-1") int pageNumber, @ApiParam(value="\u5206\u9875\u5185\u8bb0\u5f55\u6570") @RequestParam(value="size", required=false, defaultValue="20") int pageSize, @ApiParam(value="\u591a\u4e2a\u6392\u5e8f\u6761\u4ef6\u3002\u4f8b\u5982\uff1aorderBy-description=true\uff0c\u8868\u793a\u6309description\u5b57\u6bb5\u5347\u5e8f\u6392\u5e8f") @RequestParam Map<String, String> requestParams) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            String errorMessage = "\u672a\u67e5\u627e\u5230\u67e5\u8be2\u5b9a\u4e49";
            Map orderBy = HttpUtils.toOrderByMap(requestParams);
            if (!"".equals(keyword)) {
                BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Page)this.queryMetaService.list(keyword, pageNumber, pageSize, orderBy), (String[])new String[]{null, errorMessage});
                return baseResult;
            }
            if (pageNumber <= 0 || pageSize <= 0) {
                BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)this.queryMetaService.list(), (String[])new String[]{null, errorMessage});
                return baseResult;
            }
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Page)this.queryMetaService.list(pageNumber, pageSize, orderBy), (String[])new String[]{null, errorMessage});
            return baseResult;
        }
        catch (MetaException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"{queryName}"})
    public BaseResult<QueryMeta> get(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName) {
        QueryMeta query = null;
        try (Debugger debugger = new Debugger(log, new String[0]);){
            query = this.queryMetaService.get(queryName);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)query, (String[])new String[]{"\u67e5\u8be2\u6210\u529f", "\u672a\u67e5\u8be2\u5230\u7ed3\u679c"});
            return baseResult;
        }
        catch (RuntimeException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)query, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PutMapping(value={"{queryName}"})
    public BaseResult<QueryMeta> update(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName, @ApiParam(value="\u67e5\u8be2\u5b9a\u4e49") @RequestBody QueryMeta queryMeta) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            queryMeta.setQueryName(queryName);
            this.queryMetaService.update(queryMeta);
            BaseResult baseResult = BaseResult.makeResult((Object)null);
            return baseResult;
        }
        catch (RuntimeException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DeleteMapping(value={"{queryName}"})
    public BaseResult<QueryMeta> delete(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            this.queryMetaService.delete(queryName);
            BaseResult baseResult = BaseResult.makeResult((Object)null);
            return baseResult;
        }
        catch (RuntimeException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }
}

