/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web;

import cn.gtmap.gtc.model.common.result.BaseResult;
import cn.gtmap.gtc.model.domain.dto.AnonymousQuery;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityCrudServiceQueryServiceSelfImpl;
import cn.gtmap.gtc.model.service.QueryMetaService;
import cn.gtmap.gtc.model.service.QueryService;
import cn.gtmap.gtc.model.service.QueryServicePeerImpl;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/query"})
@Deprecated
public class QueryController {
    private final QueryService localQueryService;
    private final QueryService remoteQueryService;
    private final QueryMetaService queryMetaService;
    private final CoordinationService coordinationService;

    @Autowired
    public QueryController(EntityCrudServiceQueryServiceSelfImpl entityCrudServiceQueryServiceSelfImpl, QueryServicePeerImpl queryServicePeerImpl, QueryMetaService queryMetaService, CoordinationService coordinationService) {
        this.localQueryService = entityCrudServiceQueryServiceSelfImpl;
        this.remoteQueryService = queryServicePeerImpl;
        this.queryMetaService = queryMetaService;
        this.coordinationService = coordinationService;
    }

    @PostMapping
    public BaseResult<List<Object>> listByQueryStatement(@ApiParam(value="\u5206\u9875\u9875\u7801") @RequestParam(value="page", required=false, defaultValue="-1") int pageNumber, @ApiParam(value="\u5206\u9875\u5185\u8bb0\u5f55\u6570") @RequestParam(value="size", required=false, defaultValue="20") int pageSize, @ApiParam(value="\u67e5\u8be2\u53c2\u6570") @RequestBody AnonymousQuery anonymousQuery, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        QueryService queryService = this.getQueryServiceByDbConnName(anonymousQuery.getDatabaseConnectionName(), redirected);
        Map queryParams = anonymousQuery.getParameters();
        String queryStatement = anonymousQuery.getStatement();
        String queryLanguage = anonymousQuery.getLanguage();
        String dbConnName = anonymousQuery.getDatabaseConnectionName();
        List entities = pageNumber <= 0 || pageSize <= 0 ? queryService.listByAnonymousQuery(queryStatement, queryParams, queryLanguage, dbConnName) : queryService.listByAnonymousQuery(queryStatement, queryParams, queryLanguage, dbConnName, pageNumber, pageSize);
        return BaseResult.makeResult((Object)entities);
    }

    @PostMapping(value={"{queryName}"})
    public BaseResult<List<Object>> listByNamedQuery(@ApiParam(value="\u67e5\u8be2\u540d\u79f0") @PathVariable String queryName, @ApiParam(value="\u5206\u9875\u9875\u7801") @RequestParam(value="page", required=false, defaultValue="-1") int pageNumber, @ApiParam(value="\u5206\u9875\u5185\u8bb0\u5f55\u6570") @RequestParam(value="size", required=false, defaultValue="20") int pageSize, @ApiParam(value="\u67e5\u8be2\u53c2\u6570") @RequestBody Map<String, Object> queryParams, @ApiIgnore @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        QueryService queryService = this.getQueryServiceByQueryName(queryName, redirected);
        List entities = pageNumber <= 0 || pageSize <= 0 ? queryService.listByNamedQuery(queryName, queryParams) : queryService.listByNamedQuery(queryName, queryParams, pageNumber, pageSize);
        return BaseResult.makeResult((Object)entities);
    }

    private QueryService getQueryServiceByDbConnName(String dbConnName, boolean redirected) {
        if (redirected) {
            return this.localQueryService;
        }
        return this.coordinationService.canHandle(dbConnName) ? this.localQueryService : this.remoteQueryService;
    }

    private QueryService getQueryServiceByQueryName(String queryName, boolean redirected) {
        if (redirected) {
            return this.localQueryService;
        }
        String dbConnName = this.queryMetaService.get(queryName).getDatabaseConnectionName();
        return this.coordinationService.canHandle(dbConnName) ? this.localQueryService : this.remoteQueryService;
    }
}

