/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web;

import cn.gtmap.gtc.model.common.result.BaseResult;
import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.exception.MetaException;
import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.utils.Debugger;
import cn.gtmap.gtc.utils.HttpUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/model-def"})
@Deprecated
public class EntityMetaController {
    private static final Logger log = LoggerFactory.getLogger(EntityMetaController.class);
    private final EntityMetaService entityMetaService;
    private final ObjectMapper objectMapper;

    @Autowired
    public EntityMetaController(EntityMetaService entityMetaService, ObjectMapper objectMapper) {
        this.entityMetaService = entityMetaService;
        this.objectMapper = objectMapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping
    public BaseResult<EntityMeta> insert(@RequestBody EntityMeta entityMeta) {
        EntityMeta meta = null;
        try (Debugger debugger = new Debugger(log, new String[0]);){
            meta = this.entityMetaService.insert(entityMeta);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)meta, (String[])new String[]{"\u521b\u5efa\u6210\u529f", "\u521b\u5efa\u5931\u8d25"});
            return baseResult;
        }
        catch (MetaException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)meta, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PatchMapping
    public BaseResult<List<EntityMeta>> writeMetas(@RequestBody Map<String, Map<String, Object>> entityMetas) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            LinkedHashMap<String, EntityMeta> metaMap = new LinkedHashMap<String, EntityMeta>();
            for (Map.Entry<String, Map<String, Object>> entry : entityMetas.entrySet()) {
                Map<String, Object> value = entry.getValue();
                metaMap.put(entry.getKey(), value == null ? null : (EntityMeta)this.objectMapper.readValue(this.objectMapper.writeValueAsString(value), EntityMeta.class));
            }
            List metas = this.entityMetaService.writeMetas(metaMap);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)metas, (String[])new String[]{"\u5199\u5165\u6210\u529f", "\u5199\u5165\u5931\u8d25"});
            return baseResult;
        }
        catch (MetaException | IOException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping
    public BaseResult<List<EntityMeta>> list(@ApiParam(value="\u6a21\u578b\u5173\u952e\u8bcd") @RequestParam(value="q", required=false, defaultValue="") String keyword, @ApiParam(value="\u5206\u9875\u9875\u7801") @RequestParam(value="page", required=false, defaultValue="-1") int pageNumber, @ApiParam(value="\u5206\u9875\u5185\u8bb0\u5f55\u6570") @RequestParam(value="size", required=false, defaultValue="20") int pageSize, @ApiParam(value="\u662f\u5426\u8fd4\u56de\u5b57\u6bb5\u4fe1\u606f") @RequestParam(value="expand", required=false, defaultValue="true") Boolean shouldExpand, @ApiParam(value="\u591a\u4e2a\u6392\u5e8f\u6761\u4ef6\u3002\u4f8b\u5982\uff1aorderBy-description=true\uff0c\u8868\u793a\u6309description\u5b57\u6bb5\u5347\u5e8f\u6392\u5e8f") @RequestParam Map<String, String> requestParams) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            String errorMessage = "\u672a\u67e5\u627e\u5230\u6a21\u578b\u5b9a\u4e49";
            Map orderBy = HttpUtils.toOrderByMap(requestParams);
            if (!"".equals(keyword)) {
                BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Page)this.entityMetaService.list(keyword, pageNumber, pageSize, orderBy, shouldExpand.booleanValue()), (String[])new String[]{null, errorMessage});
                return baseResult;
            }
            if (pageNumber <= 0 || pageSize <= 0) {
                BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)this.entityMetaService.list(shouldExpand.booleanValue()), (String[])new String[]{null, errorMessage});
                return baseResult;
            }
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Page)this.entityMetaService.list(pageNumber, pageSize, orderBy, shouldExpand.booleanValue()), (String[])new String[]{null, errorMessage});
            return baseResult;
        }
        catch (MetaException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"{entityName}"})
    public BaseResult<EntityMeta> get(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String entityName) {
        EntityMeta meta = null;
        try (Debugger debugger = new Debugger(log, new String[0]);){
            meta = this.entityMetaService.get(entityName);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)meta, (String[])new String[]{null, "\u672a\u627e\u5230\u6a21\u578b\u5b9a\u4e49"});
            return baseResult;
        }
        catch (MetaException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)meta, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PutMapping(value={"{entityName}"})
    public BaseResult<EntityMeta> update(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String entityName, @ApiParam(value="\u6a21\u578b\u5b9a\u4e49") @RequestBody EntityMeta entityMeta) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            entityMeta.setEntityName(entityName);
            this.entityMetaService.update(entityMeta);
            BaseResult baseResult = BaseResult.makeResult((Object)null);
            return baseResult;
        }
        catch (MetaException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DeleteMapping(value={"{entityName}"})
    public BaseResult<EntityMeta> delete(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String entityName) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            this.entityMetaService.delete(entityName);
            BaseResult baseResult = BaseResult.makeResult((Object)null);
            return baseResult;
        }
        catch (MetaException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }
}

