/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web;

import cn.gtmap.gtc.model.common.result.BaseResult;
import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.CoordinationServiceImpl;
import cn.gtmap.gtc.model.service.EntityCrudService;
import cn.gtmap.gtc.model.service.EntityCrudServicePeerImpl;
import cn.gtmap.gtc.model.service.EntityCrudServiceQueryServiceSelfImpl;
import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.utils.Debugger;
import cn.gtmap.gtc.utils.HttpUtils;
import com.google.common.base.Strings;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/model"})
@Deprecated
public class EntityCrudController {
    private static final Logger log = LoggerFactory.getLogger(EntityCrudController.class);
    private final EntityCrudService localEntityCrudService;
    private final EntityCrudService remoteEntityCrudService;
    private final EntityMetaService entityMetaService;
    private final CoordinationService coordinationService;

    @Autowired
    public EntityCrudController(EntityCrudServiceQueryServiceSelfImpl localEntityCrudService, EntityCrudServicePeerImpl remoteEntityCrudService, EntityMetaService entityMetaService, CoordinationServiceImpl coordinationServiceImpl) {
        this.localEntityCrudService = localEntityCrudService;
        this.remoteEntityCrudService = remoteEntityCrudService;
        this.entityMetaService = entityMetaService;
        this.coordinationService = coordinationServiceImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"{modelName}"})
    public BaseResult<Serializable> insert(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8b") @RequestBody String requestBody) {
        Serializable entityId = null;
        try (Debugger debugger = new Debugger(log, new String[0]);){
            entityId = this.getEntityCrudService(modelName, redirected).insert(modelName, requestBody);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)entityId, (String[])new String[]{"", "\u521b\u5efa\u5931\u8d25"});
            return baseResult;
        }
        catch (EntityCrudException ex) {
            return BaseResult.makeResultDependingOnExistence(entityId, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"{modelName}"})
    public BaseResult<List<Object>> list(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u9879\u76eeID") @RequestParam(value="proId", required=false, defaultValue="") String proId, @ApiParam(value="\u5206\u9875\u9875\u7801") @RequestParam(value="page", required=false, defaultValue="-1") int pageNumber, @ApiParam(value="\u5206\u9875\u5185\u8bb0\u5f55\u6570") @RequestParam(value="size", required=false, defaultValue="20") int pageSize, @ApiParam(value="\u591a\u4e2a\u6392\u5e8f\u6761\u4ef6\u3002\u4f8b\u5982\uff1aorderBy-fieldOne=true\uff0c\u8868\u793a\u6309fieldOne\u5b57\u6bb5\u5347\u5e8f\u6392\u5e8f") @RequestParam Map<String, String> requestParams, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        Map orderBy = HttpUtils.toOrderByMap(requestParams);
        try (Debugger debugger = new Debugger(log, new String[0]);){
            List entities = null;
            boolean noPage = pageNumber <= 0 || pageSize <= 0 || requestParams.isEmpty();
            boolean noProId = Strings.isNullOrEmpty((String)proId);
            EntityCrudService entityCrudService = this.getEntityCrudService(modelName, redirected);
            switch ((noPage ? 0 : 1) | (noProId ? 0 : 2)) {
                case 0: {
                    entities = entityCrudService.list(modelName);
                    break;
                }
                case 1: {
                    entities = entityCrudService.list(modelName, pageNumber, pageSize, orderBy);
                    break;
                }
                case 2: {
                    entities = entityCrudService.list(modelName, proId);
                    break;
                }
                case 3: {
                    entities = entityCrudService.list(modelName, proId, pageNumber, pageSize, orderBy);
                    break;
                }
            }
            BaseResult baseResult = BaseResult.makeResult(entities);
            return baseResult;
        }
        catch (EntityCrudException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"{modelName}/{modelId}/**"})
    public BaseResult<Object> get(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, HttpServletRequest request) {
        Object entity = null;
        try (Debugger debugger = new Debugger(log, new String[0]);){
            String servletPath = request.getServletPath();
            String headPathRegex = String.format("^(\\/\\w+)*\\/%s\\/%s", modelName, modelId);
            String tailPath = servletPath.replaceFirst(headPathRegex, "");
            EntityCrudService entityCrudService = this.getEntityCrudService(modelName, redirected);
            if (tailPath.length() == 0) {
                entity = entityCrudService.get(modelName, (Serializable)((Object)modelId), new String[0]);
            } else {
                String[] tailSegments = tailPath.replaceFirst("^\\/", "").split("\\/");
                entity = entityCrudService.get(modelName, (Serializable)((Object)modelId), tailSegments);
            }
            BaseResult baseResult = BaseResult.makeResult((Object)entity);
            return baseResult;
        }
        catch (EntityCrudException ex) {
            return BaseResult.makeResultDependingOnExistence(entity, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PutMapping(value={"{modelName}/{modelId}"})
    public BaseResult<Object> update(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8b") @RequestBody String requestBody) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            this.getEntityCrudService(modelName, redirected).update(modelName, (Serializable)((Object)modelId), requestBody);
            BaseResult baseResult = BaseResult.makeResult(null);
            return baseResult;
        }
        catch (EntityCrudException ex) {
            return BaseResult.makeResultDependingOnExistence(null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PatchMapping(value={"{modelName}/{modelId}"})
    public BaseResult<Object> updateFields(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8b") @RequestBody String requestBody) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            this.getEntityCrudService(modelName, redirected).updateFields(modelName, (Serializable)((Object)modelId), requestBody);
            BaseResult baseResult = BaseResult.makeResult(null);
            return baseResult;
        }
        catch (EntityCrudException ex) {
            return BaseResult.makeResultDependingOnExistence(null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @DeleteMapping(value={"{modelName}/{modelId}"})
    public BaseResult<Object> delete(@ApiParam(value="\u6a21\u578b\u540d\u79f0") @PathVariable String modelName, @ApiParam(value="\u6a21\u578b\u5b9e\u4f8bID") @PathVariable String modelId, @RequestHeader(value="Peer-Redirected", defaultValue="false") boolean redirected) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            this.getEntityCrudService(modelName, redirected).delete(modelName, (Serializable)((Object)modelId));
            BaseResult baseResult = BaseResult.makeResult(null);
            return baseResult;
        }
        catch (EntityCrudException ex) {
            return BaseResult.makeResultDependingOnExistence(null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    private EntityCrudService getEntityCrudService(String entityName, boolean redirected) {
        if (redirected) {
            return this.localEntityCrudService;
        }
        String dbConnName = this.entityMetaService.get(entityName).getDatabaseConnectionName();
        return this.coordinationService.canHandle(dbConnName) ? this.localEntityCrudService : this.remoteEntityCrudService;
    }
}

