/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web;

import cn.gtmap.gtc.model.common.result.BaseResult;
import cn.gtmap.gtc.model.domain.entity.DatabaseConnection;
import cn.gtmap.gtc.model.service.DatabaseConnectionService;
import cn.gtmap.gtc.utils.Debugger;
import cn.gtmap.gtc.utils.HttpUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/database-connection"})
@Deprecated
public class DatabaseConnectionController {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConnectionController.class);
    private final DatabaseConnectionService databaseConnectionService;

    public DatabaseConnectionController(@Autowired DatabaseConnectionService databaseConnectionService) {
        this.databaseConnectionService = databaseConnectionService;
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u8fde\u63a5\u521b\u5efa")
    @PostMapping
    public BaseResult<DatabaseConnection> insert(@ApiParam(value="\u6570\u636e\u5e93\u8fde\u63a5", required=true) @RequestBody DatabaseConnection databaseConnection) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            DatabaseConnection connection = this.databaseConnectionService.insert(databaseConnection);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)connection, (String[])new String[]{null, "\u5199\u5165\u5931\u8d25"});
            return baseResult;
        }
    }

    @GetMapping
    public BaseResult<List<DatabaseConnection>> list(@ApiParam(value="\u5206\u9875\u9875\u7801") @RequestParam(value="page", required=false, defaultValue="-1") int pageNumber, @ApiParam(value="\u5206\u9875\u5185\u8bb0\u5f55\u6570") @RequestParam(value="size", required=false, defaultValue="20") int pageSize, @ApiParam(value="\u591a\u4e2a\u6392\u5e8f\u6761\u4ef6\u3002\u4f8b\u5982\uff1aorderBy-description=true\uff0c\u8868\u793a\u6309description\u5b57\u6bb5\u5347\u5e8f\u6392\u5e8f") @RequestParam Map<String, String> requestParams) {
        try {
            String errorMessage = "\u672a\u67e5\u627e\u5230\u6570\u636e\u5e93\u8fde\u63a5";
            Map orderBy = HttpUtils.toOrderByMap(requestParams);
            if (pageNumber <= 0 || pageSize <= 0) {
                return BaseResult.makeResultDependingOnExistence((Object)this.databaseConnectionService.list(), (String[])new String[]{null, errorMessage});
            }
            return BaseResult.makeResultDependingOnExistence((Page)this.databaseConnectionService.list(pageNumber, pageSize, orderBy), (String[])new String[]{null, errorMessage});
        }
        catch (RuntimeException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    @GetMapping(value={"{name}"})
    public BaseResult<DatabaseConnection> get(@ApiParam(value="\u540d\u79f0") @PathVariable String name) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            DatabaseConnection connection = this.databaseConnectionService.get(name);
            BaseResult baseResult = BaseResult.makeResultDependingOnExistence((Object)connection, (String[])new String[]{null, "\u672a\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5"});
            return baseResult;
        }
    }

    @PutMapping(value={"{name}"})
    public BaseResult<DatabaseConnection> update(@ApiParam(value="\u540d\u79f0") @PathVariable String name, @ApiParam(value="\u6570\u636e\u5e93\u8fde\u63a5") @RequestBody DatabaseConnection databaseConnection) {
        try {
            databaseConnection.setName(name);
            this.databaseConnectionService.update(databaseConnection);
            return BaseResult.makeResult((Object)null);
        }
        catch (RuntimeException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }

    @DeleteMapping(value={"{name}"})
    public BaseResult<DatabaseConnection> delete(@ApiParam(value="\u540d\u79f0") @PathVariable String name) {
        try {
            this.databaseConnectionService.delete(name);
            return BaseResult.makeResult((Object)null);
        }
        catch (RuntimeException ex) {
            return BaseResult.makeResultDependingOnExistence((Object)null, (String[])new String[]{null, ex.getMessage()});
        }
    }
}

