/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.web;

import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.model.service.HibernateCfgService;
import cn.gtmap.gtc.utils.Debugger;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@ApiIgnore(value="\u670d\u52a1\u5b9e\u4f8b\u5185\u90e8\u4f7f\u7528")
@RequestMapping(value={"/auxiliary"})
@Controller
public class AuxiliaryController {
    private static final Logger log = LoggerFactory.getLogger(AuxiliaryController.class);
    private final EntityMetaService entityMetaService;
    private final HibernateCfgService hibernateCfgService;

    @Autowired
    public AuxiliaryController(EntityMetaService entityMetaService, HibernateCfgService hibernateCfgService) {
        this.entityMetaService = entityMetaService;
        this.hibernateCfgService = hibernateCfgService;
    }

    @GetMapping(value={"{databaseConnectionName}/*.jar"})
    public void getJar(@PathVariable String databaseConnectionName, HttpServletResponse response) throws IOException {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            this.entityMetaService.getEntitiesAsJAR(databaseConnectionName, (OutputStream)response.getOutputStream());
        }
    }

    @GetMapping(value={"{databaseConnectionName}/hibernate-cfg.xml"})
    @ResponseBody
    public String getHibernateCfg(@PathVariable String databaseConnectionName) {
        try (Debugger debugger = new Debugger(log, new String[0]);){
            String string = this.hibernateCfgService.get(databaseConnectionName);
            return string;
        }
    }
}

