/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.model.domain.dto.AnonymousQuery;
import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.QueryMetaService;
import cn.gtmap.gtc.model.service.QueryService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class QueryServicePeerImpl
implements QueryService {
    private final CoordinationService coordinationService;
    private final QueryMetaService queryMetaService;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;

    @Autowired
    public QueryServicePeerImpl(CoordinationService coordinationService, QueryMetaService queryMetaService, ObjectMapper objectMapper, HttpClient httpClient) {
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.coordinationService = coordinationService;
        this.queryMetaService = queryMetaService;
    }

    public Page<Object> listByNamedQuery(String queryName, Map<String, Object> parameters, Pageable pageable) {
        try {
            String peerLocation = this.getPeerLocationByQueryName(queryName);
            HttpPost httpRequest = this.prepareRequest(peerLocation, parameters, pageable);
            return this.doRequest((HttpRequestBase)httpRequest).toPage();
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Page<Object> listByAnonymousQuery(String statement, Map<String, Object> parameters, String language, String databaseConnectionName, Pageable pageable) {
        try {
            String peerLocation = this.getPeerLocationByDbConnName(databaseConnectionName);
            AnonymousQuery anonymousQuery = new AnonymousQuery(statement, language, parameters, databaseConnectionName);
            HttpPost httpRequest = this.prepareRequest(peerLocation, (Object)anonymousQuery, pageable);
            return this.doRequest((HttpRequestBase)httpRequest).toPage();
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> HttpPost prepareRequest(String location, T requestEntity, Pageable pageable) throws URISyntaxException, IOException {
        if (pageable != null) {
            location = location + String.format("?page=%d&size=%d", pageable.getPageNumber(), pageable.getPageSize());
        }
        HttpPost httpPost = new HttpPost(new URI(location));
        httpPost.setHeader("Peer-Redirected", "true");
        String requestBOdy = this.objectMapper.writeValueAsString(requestEntity);
        httpPost.setEntity((HttpEntity)new StringEntity(requestBOdy, ContentType.APPLICATION_JSON));
        return httpPost;
    }

    private PageResult<Object> doRequest(HttpRequestBase httpRequest) throws IOException {
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
        return (PageResult)this.objectMapper.readValue(httpResponse.getEntity().getContent(), PageResult.class);
    }

    private String getPeerLocationByQueryName(String queryName) {
        String dbConnName = this.getShardNameByQueryName(queryName);
        String peerLocation = this.coordinationService.getPeerLocation(dbConnName);
        if (peerLocation == null) {
            throw new EntityCrudException("\u6ca1\u6709\u53ef\u7528\u7684\u8282\u70b9");
        }
        return String.format("%s/v1/queries/%s", peerLocation, queryName);
    }

    private String getPeerLocationByDbConnName(String dbConnName) {
        String peerLocation = this.coordinationService.getPeerLocation(dbConnName);
        if (peerLocation == null) {
            throw new EntityCrudException("\u6ca1\u6709\u53ef\u7528\u7684\u8282\u70b9");
        }
        return String.format("%s/v1/queries", peerLocation);
    }

    private String getShardNameByQueryName(String queryName) {
        return this.queryMetaService.get(queryName).getDatabaseConnectionName();
    }
}

