/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.category.client.v1.DomainResourceClient;
import cn.gtmap.gtc.category.common.dto.DomainResource;
import cn.gtmap.gtc.category.common.dto.ResourceType;
import cn.gtmap.gtc.model.domain.dao.QueryMetaRepository;
import cn.gtmap.gtc.model.domain.entity.QueryMeta;
import cn.gtmap.gtc.model.service.QueryMetaService;
import java.io.Serializable;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.Hibernate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueryMetaServiceImpl
implements QueryMetaService {
    private static final String DESC_FLD = "description";
    private static final String NAME_FLD = "queryName";
    private final QueryMetaRepository queryMetaRepository;
    private final DomainResourceClient domainResourceClient;
    private final ResourceType resourceType;

    @Autowired
    public QueryMetaServiceImpl(QueryMetaRepository queryMetaRepository, DomainResourceClient domainResourceClient) {
        this.queryMetaRepository = queryMetaRepository;
        this.domainResourceClient = domainResourceClient;
        this.resourceType = new ResourceType("query", null);
    }

    @Transactional
    public QueryMeta insert(QueryMeta queryMeta) {
        this.queryMetaRepository.saveAndFlush((Object)queryMeta);
        this.domainResourceClient.insert(this.newDomainResourc(queryMeta));
        return queryMeta;
    }

    @Transactional
    public QueryMeta get(String queryName) {
        QueryMeta queryMeta = (QueryMeta)this.queryMetaRepository.getOne((Serializable)((Object)queryName));
        this.fillCategory(queryMeta);
        Hibernate.initialize((Object)queryMeta);
        return queryMeta;
    }

    @Transactional
    public List<QueryMeta> list() {
        List queryMetas = this.queryMetaRepository.findAll();
        queryMetas.forEach(arg_0 -> this.fillCategory(arg_0));
        return queryMetas;
    }

    @Transactional
    public Page<QueryMeta> list(Pageable pageable) {
        Page queryMetas = this.queryMetaRepository.findAll(pageable);
        queryMetas.forEach(arg_0 -> this.fillCategory(arg_0));
        return queryMetas;
    }

    @Transactional
    public Page<QueryMeta> list(String keyWord, Pageable pageable) {
        String likeString = '%' + keyWord + '%';
        Specification specification = (root, query, cb) -> cb.or((Expression)cb.like(root.get(NAME_FLD).as(String.class), likeString), (Expression)cb.like(root.get(DESC_FLD).as(String.class), likeString));
        Page queryMetas = this.queryMetaRepository.findAll(specification, pageable);
        queryMetas.forEach(arg_0 -> this.fillCategory(arg_0));
        return queryMetas;
    }

    @Transactional
    public void update(QueryMeta queryMeta) {
        this.queryMetaRepository.saveAndFlush((Object)queryMeta);
        List resources = (List)this.domainResourceClient.list(queryMeta.getQueryName(), this.resourceType.getName()).getData();
        if (resources == null || resources.isEmpty()) {
            this.domainResourceClient.insert(this.newDomainResourc(queryMeta));
        } else {
            resources.stream().filter(resource -> !resource.getDomainCategory().getId().equals(queryMeta.getDomainCategory().getId())).forEach(resource -> this.domainResourceClient.update(resource.getId(), this.newDomainResourc(queryMeta)));
        }
    }

    @Transactional
    public void delete(String queryName) {
        QueryMeta queryMeta = (QueryMeta)this.queryMetaRepository.findOne((Serializable)((Object)queryName));
        if (queryMeta != null) {
            this.queryMetaRepository.delete((Object)queryMeta);
            List domainResources = (List)this.domainResourceClient.list(queryName, this.resourceType.getName()).getData();
            if (domainResources != null) {
                domainResources.forEach(resource -> this.domainResourceClient.delete(resource.getId()));
            }
        }
    }

    private DomainResource newDomainResourc(QueryMeta queryMeta) {
        return new DomainResource(null, queryMeta.getQueryName(), queryMeta.getDomainCategory(), this.resourceType);
    }

    private void fillCategory(QueryMeta queryMeta) {
        if (queryMeta.getDomainCategory() == null) {
            List domainResources = (List)this.domainResourceClient.list(queryMeta.getQueryName(), this.resourceType.getName()).getData();
            if (domainResources == null || domainResources.isEmpty()) {
                return;
            }
            queryMeta.setDomainCategory(((DomainResource)domainResources.get(0)).getDomainCategory());
        }
    }
}

