/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.model.domain.entity.DatabaseConnection;
import cn.gtmap.gtc.model.service.DatabaseConnectionService;
import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.model.service.HibernateCfgService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HibernateCfgServiceImpl
implements HibernateCfgService {
    private static final String CFG_TEMPLATE = "<?xml version='1.0' encoding='utf-8'?>\n<!DOCTYPE hibernate-configuration PUBLIC\n    \"-//Hibernate/Hibernate Configuration DTD 3.0//EN\"\n    \"http://www.hibernate.org/dtd/hibernate-configuration-3.0.dtd\">\n<hibernate-configuration>\n  <session-factory>\n    <property name=\"hibernate.c3p0.min_size\">4</property>\n    <property name=\"hibernate.c3p0.max_size\">8</property>\n    <property name=\"hibernate.c3p0.time_out\">1800</property>\n    <property name=\"hibernate.c3p0.max_statement\">50</property>\n    <property name=\"connection.driver_class\">%s</property>\n    <property name=\"connection.url\">%s</property>\n    <property name=\"connection.username\">%s</property>\n    <property name=\"connection.password\">%s</property>\n    <property name=\"dialect\">%s</property>\n    <property name=\"cache.provider_class\">org.hibernate.cache.internal.NoCacheProvider</property>\n    <property name=\"show_sql\">true</property>\n    <property name=\"hbm2ddl.auto\">update</property>\n    %s\n  </session-factory>\n</hibernate-configuration>";
    private final DatabaseConnectionService databaseConnectionService;
    private final EntityMetaService entityMetaService;

    @Autowired
    public HibernateCfgServiceImpl(DatabaseConnectionService connectionRepository, EntityMetaService entityMetaService) {
        this.databaseConnectionService = connectionRepository;
        this.entityMetaService = entityMetaService;
    }

    public String get(String databaseConnectionName) {
        DatabaseConnection connection = this.databaseConnectionService.get(databaseConnectionName);
        if (connection == null) {
            return null;
        }
        List entityMetas = this.entityMetaService.list();
        return String.format(CFG_TEMPLATE, connection.getJdbcDriver(), connection.getJdbcUrl().replaceAll("&", "&amp;"), connection.getJdbcUser(), connection.getJdbcPassword(), connection.getSqlDialect(), entityMetas.isEmpty() ? "" : entityMetas.stream().filter(entityMeta -> connection.getName().equals(entityMeta.getDatabaseConnectionName())).map(entityMeta -> String.format("<mapping class=\"%s.%s\"/>", "cn.gtmap.dynamic.entity", entityMeta.getEntityName())).reduce((strOne, strTwo) -> String.format("%s%s    %s", strOne, System.lineSeparator(), strTwo)).orElse(""));
    }
}

