/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.model.aspect.EntityMetaModifier;
import cn.gtmap.gtc.model.domain.dto.EntityTreeMeta;
import cn.gtmap.gtc.model.domain.helpers.EntityHelper;
import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.service.ConcurrencyService;
import cn.gtmap.gtc.model.service.EntityCrudServiceQueryServiceSelfImpl;
import cn.gtmap.gtc.model.service.EntityTreeCrudService;
import cn.gtmap.gtc.model.service.EntityTreeCrudServiceSelfImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EntityTreeCrudServiceSelfImpl
implements EntityTreeCrudService {
    private final EntityCrudServiceQueryServiceSelfImpl entityCrudService;
    private final Lock ormReadLock;
    private final ObjectMapper objectMapper;
    private final EntityMetaModifier entityMetaModifier;

    private static String[] splitPath(String path) {
        return path.replaceFirst("^\\/", "").split("\\/");
    }

    @Autowired
    public EntityTreeCrudServiceSelfImpl(EntityCrudServiceQueryServiceSelfImpl entityCrudService, ConcurrencyService concurrencyService, ObjectMapper objectMapper, EntityMetaModifier entityMetaModifier) {
        this.entityCrudService = entityCrudService;
        this.entityMetaModifier = entityMetaModifier;
        this.objectMapper = objectMapper;
        this.ormReadLock = concurrencyService.getOrmReadLock();
    }

    /*
     * Loose catch block
     */
    public List<Object> listRoots(EntityTreeMeta tree) {
        String entityName = tree.getEntityName();
        if (Strings.isNullOrEmpty((String)entityName)) {
            return Collections.emptyList();
        }
        try {
            List list;
            Object object;
            Session session;
            block20: {
                block21: {
                    session = this.entityCrudService.getSessionByEntityName(entityName);
                    object = null;
                    this.ormReadLock.lock();
                    list = EntityTreeQueryBuilder.access$300((EntityTreeQueryBuilder)EntityTreeQueryBuilder.access$200((EntityTreeQueryBuilder)EntityTreeQueryBuilder.access$100((EntityTreeQueryBuilder)new EntityTreeQueryBuilder(this, session, null), (EntityTreeMeta)tree))).getResultList();
                    if (session == null) break block20;
                    if (object == null) break block21;
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block20;
                }
                session.close();
            }
            return list;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (session != null) {
                            if (object != null) {
                                try {
                                    session.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                session.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (NoResultException ex) {
                    object = Collections.emptyList();
                    return object;
                }
                catch (Exception ex) {
                    throw this.entityCrudService.toCrudEntityException((Throwable)ex, "\u67e5\u8be2\u6a21\u578b\u6811\u6839\u8282\u70b9\u5217\u8868\u5931\u8d25", new Transaction[0]);
                }
            }
        }
        finally {
            this.ormReadLock.unlock();
        }
    }

    public void save(EntityTreeMeta tree, String path, String jsonString) {
        String entityName = tree.getEntityName();
        if (Strings.isNullOrEmpty((String)entityName) || Strings.isNullOrEmpty((String)path)) {
            throw new EntityCrudException("\u6a21\u578b\u540d\u6216\u8282\u70b9\u8def\u5f84\u65e0\u6548");
        }
        String[] keyChain = EntityTreeCrudServiceSelfImpl.splitPath((String)path);
        if (keyChain.length == 0) {
            throw new EntityCrudException("\u8282\u70b9\u8def\u5f84\u540d\u4e0d\u5f97\u4e3a\u7a7a");
        }
        try (Session session = this.entityCrudService.getSessionByEntityName(entityName);){
            this.ormReadLock.lock();
            Transaction transaction = session.beginTransaction();
            Class entityClass = this.entityCrudService.findEntityClass(entityName);
            Object parent = null;
            for (int parentLen = 1; parentLen < keyChain.length; ++parentLen) {
                String[] parentKeyChain = Arrays.copyOfRange(keyChain, 0, parentLen);
                parent = this.getOrInsertParent(session, tree, entityClass, parent, parentKeyChain);
            }
            this.updateOrInsert(session, tree, entityClass, parent, jsonString, keyChain);
            transaction.commit();
        }
        catch (ReflectiveOperationException ex) {
            throw this.entityCrudService.toCrudEntityException((Throwable)ex, "\u6a21\u578b\u53cd\u5c04\u9519\u8bef", new Transaction[0]);
        }
        catch (IOException ex) {
            throw this.entityCrudService.toCrudEntityException((Throwable)ex, ex.getMessage(), new Transaction[0]);
        }
        finally {
            this.ormReadLock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    public Object get(EntityTreeMeta tree, String path) {
        String entityName = tree.getEntityName();
        if (Strings.isNullOrEmpty((String)entityName) || Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        String[] keyChain = EntityTreeCrudServiceSelfImpl.splitPath((String)path);
        if (keyChain.length == 0) {
            throw new EntityCrudException("\u6a21\u578b\u6811\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        try {
            Object t;
            Throwable throwable;
            Session session;
            block21: {
                block22: {
                    session = this.entityCrudService.getSessionByEntityName(entityName);
                    throwable = null;
                    this.ormReadLock.lock();
                    t = this.selectOne(session, tree, keyChain).orElseThrow(() -> new EntityCrudException("\u6a21\u578b\u6811\u8282\u70b9\u4e0d\u5b58\u5728"));
                    if (session == null) break block21;
                    if (throwable == null) break block22;
                    try {
                        session.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block21;
                }
                session.close();
            }
            return t;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (session != null) {
                            if (throwable != null) {
                                try {
                                    session.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                session.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (NoResultException ex) {
                    throwable = null;
                    return throwable;
                }
                catch (Exception ex) {
                    throw this.entityCrudService.toCrudEntityException((Throwable)ex, "\u67e5\u8be2\u6a21\u578b\u6811\u8282\u70b9\u5931\u8d25", new Transaction[0]);
                }
            }
        }
        finally {
            this.ormReadLock.unlock();
        }
    }

    public void delete(EntityTreeMeta tree, String path) {
        String entityName = tree.getEntityName();
        if (Strings.isNullOrEmpty((String)entityName)) {
            throw new EntityCrudException("\u6a21\u578b\u540d\u79f0\u4e0d\u5f97\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)path)) {
            throw new EntityCrudException("\u6a21\u578b\u540d\u79f0\u548c\u8def\u5f84\u4e0d\u5f97\u4e3a\u7a7a");
        }
        String[] keyChain = EntityTreeCrudServiceSelfImpl.splitPath((String)path);
        if (keyChain.length == 0) {
            throw new EntityCrudException("\u8def\u5f84\u4e0d\u5f97\u4e3a\u7a7a");
        }
        try (Session session = this.entityCrudService.getSessionByEntityName(entityName);){
            this.ormReadLock.lock();
            Transaction transaction = session.beginTransaction();
            Object entity = this.selectOne(session, tree, keyChain).orElseThrow(() -> new EntityCrudException("\u6a21\u578b\u6811\u8282\u70b9\u4e0d\u5b58\u5728"));
            session.delete(entity);
            transaction.commit();
        }
        catch (ReflectiveOperationException ex) {
            throw this.entityCrudService.toCrudEntityException((Throwable)ex, "\u6a21\u578b\u53cd\u5c04\u9519\u8bef", new Transaction[0]);
        }
        finally {
            this.ormReadLock.unlock();
        }
    }

    private Object getOrInsertParent(Session session, EntityTreeMeta tree, Class<?> entityClass, Object parent, String ... keyChain) throws ReflectiveOperationException {
        return this.selectOne(session, tree, keyChain).orElseGet(() -> {
            try {
                Object entity = entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                EntityHelper.writeFieldOf(entity, (String)tree.getKeyField(), (Object)keyChain[keyChain.length - 1]);
                EntityHelper.writeFieldOf(entity, (String)tree.getParentField(), (Object)parent);
                this.entityMetaModifier.touch(entity);
                session.save(entity);
                return entity;
            }
            catch (ReflectiveOperationException ex) {
                throw this.entityCrudService.toCrudEntityException((Throwable)ex, "\u6a21\u578b\u53cd\u5c04\u9519\u8bef", new Transaction[0]);
            }
        });
    }

    private void updateOrInsert(Session session, EntityTreeMeta tree, Class<?> entityClass, Object parent, String jsonString, String ... keyChain) throws ReflectiveOperationException, IOException {
        Object entity = this.selectOne(session, tree, keyChain).orElseGet(() -> {
            try {
                Object newEntity = entityClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                EntityHelper.writeFieldOf(newEntity, (String)tree.getKeyField(), (Object)keyChain[keyChain.length - 1]);
                if (parent != null) {
                    EntityHelper.writeFieldOf(newEntity, (String)tree.getParentField(), (Object)parent);
                }
                return newEntity;
            }
            catch (ReflectiveOperationException ex) {
                throw this.entityCrudService.toCrudEntityException((Throwable)ex, "\u6a21\u578b\u53cd\u5c04\u9519\u8bef", new Transaction[0]);
            }
        });
        Object targetEntity = this.objectMapper.readValue(jsonString, entityClass);
        Field idField = (Field)EntityHelper.findIdField((Object)entity).orElseThrow(() -> new EntityCrudException("\u6a21\u578b\u65e0\u4e3b\u952e\u5b57\u6bb5"));
        Set fieldNames = Arrays.stream(entityClass.getDeclaredFields()).map(Field::getName).collect(Collectors.toSet());
        ImmutableSet ignoredFieldNames = ImmutableSet.of((Object)idField.getName(), (Object)tree.getKeyField(), (Object)tree.getParentField(), (Object)tree.getChildrenField(), (Object)"createTime", (Object)"modifyTime", (Object[])new String[0]);
        for (String fieldName : Sets.difference(fieldNames, (Set)ignoredFieldNames)) {
            EntityHelper.writeFieldOf((Object)entity, (String)fieldName, (Object)EntityHelper.readFieldOf((Object)targetEntity, (String)fieldName));
        }
        this.entityMetaModifier.touch(entity);
        session.save(entity);
    }

    private Optional<Object> selectOne(Session session, EntityTreeMeta tree, String ... keyChain) throws ClassNotFoundException {
        List results = EntityTreeQueryBuilder.access$300((EntityTreeQueryBuilder)EntityTreeQueryBuilder.access$400((EntityTreeQueryBuilder)EntityTreeQueryBuilder.access$100((EntityTreeQueryBuilder)new EntityTreeQueryBuilder(this, session, null), (EntityTreeMeta)tree), (String[])keyChain)).setMaxResults(1).getResultList();
        return results.isEmpty() ? Optional.empty() : Optional.of(results.get(0));
    }

    static /* synthetic */ EntityCrudServiceQueryServiceSelfImpl access$500(EntityTreeCrudServiceSelfImpl x0) {
        return x0.entityCrudService;
    }
}

