/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.model.domain.dto.EntityTreeMeta;
import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.exception.PeerUnreachableException;
import cn.gtmap.gtc.model.service.AbstractPeerService;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.model.service.EntityTreeCrudService;
import cn.gtmap.gtc.model.service.EntityTreeCrudServiceSelfImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class EntityTreeCrudServicePeerImpl
extends AbstractPeerService
implements EntityTreeCrudService {
    private final CoordinationService coordinationService;
    private final EntityMetaService entityMetaService;
    private final EntityTreeCrudService localEntityTreeCrudService;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;

    @Autowired
    public EntityTreeCrudServicePeerImpl(CoordinationService coordinationService, EntityMetaService entityMetaService, EntityTreeCrudServiceSelfImpl entityTreeCrudServiceSelfImpl, ObjectMapper objectMapper, HttpClient httpClient) {
        this.objectMapper = objectMapper;
        this.coordinationService = coordinationService;
        this.entityMetaService = entityMetaService;
        this.localEntityTreeCrudService = entityTreeCrudServiceSelfImpl;
        this.httpClient = httpClient;
    }

    public List<Object> listRoots(EntityTreeMeta tree) {
        String entityName = tree.getEntityName();
        try {
            String peerLocation = this.getPeerLocation(entityName, "/");
            PageResult pageResult = (PageResult)this.request(RequestMethod.GET, peerLocation, PageResult.class).orElseThrow(() -> new EntityCrudException("\u67e5\u8be2\u6839\u8282\u70b9\u5217\u8868\u5931\u8d25"));
            return (List)pageResult.getData();
        }
        catch (PeerUnreachableException ex) {
            return this.refreshLocalService(entityName).listRoots(tree);
        }
    }

    public void save(EntityTreeMeta tree, String path, String jsonString) {
        String entityName = tree.getEntityName();
        try {
            String peerLocation = this.getPeerLocation(entityName, path);
            this.request(RequestMethod.PUT, peerLocation, jsonString, Object.class);
        }
        catch (PeerUnreachableException ex) {
            this.refreshLocalService(entityName).save(tree, path, jsonString);
        }
    }

    public Object get(EntityTreeMeta tree, String path) {
        String entityName = tree.getEntityName();
        try {
            String peerLocation = this.getPeerLocation(entityName, path);
            return this.request(RequestMethod.GET, peerLocation, Object.class);
        }
        catch (PeerUnreachableException ex) {
            return this.refreshLocalService(entityName).get(tree, path);
        }
    }

    public void delete(EntityTreeMeta tree, String path) {
        String entityName = tree.getEntityName();
        try {
            String peerLocation = this.getPeerLocation(entityName, path);
            this.request(RequestMethod.DELETE, peerLocation, Object.class);
        }
        catch (PeerUnreachableException ex) {
            this.refreshLocalService(entityName).delete(tree, path);
        }
    }

    private EntityTreeCrudService refreshLocalService(String entityName) {
        String shardName = this.getShardNameByEntityName(entityName);
        Long version = this.coordinationService.getNextVersion();
        this.coordinationService.updateShardBySelf(shardName, version);
        return this.localEntityTreeCrudService;
    }

    private String getPeerLocation(String entityName, String path) {
        String peerLocation = this.coordinationService.getPeerLocation(this.getShardNameByEntityName(entityName));
        if (peerLocation == null) {
            throw new EntityCrudException("\u6ca1\u6709\u53ef\u7528\u7684\u8282\u70b9");
        }
        return String.format("%s/v1/model-trees/%s/%s", peerLocation, entityName, path.replaceFirst("^\\/", ""));
    }

    private String getShardNameByEntityName(String entityName) {
        return this.entityMetaService.get(entityName).getDatabaseConnectionName();
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }
}

