/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.category.client.v1.DomainResourceClient;
import cn.gtmap.gtc.category.common.dto.DomainResource;
import cn.gtmap.gtc.category.common.dto.ResourceType;
import cn.gtmap.gtc.model.domain.dao.EntityMetaRepository;
import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.domain.helpers.EntityBuilder;
import cn.gtmap.gtc.model.domain.helpers.EntityClassLoader;
import cn.gtmap.gtc.model.exception.MetaException;
import cn.gtmap.gtc.model.service.ConcurrencyService;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.utils.Debugger;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import org.hibernate.Hibernate;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TypeMismatchException;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.internal.StandardServiceRegistryImpl;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.retry.annotation.Retryable;
import org.springframework.transaction.annotation.Transactional;

@org.springframework.stereotype.Service
public class EntityMetaServiceImpl
implements EntityMetaService {
    private static final Logger log = LoggerFactory.getLogger(EntityMetaServiceImpl.class);
    private static final String DESC_FLD = "description";
    private static final String NAME_FLD = "entityName";
    private final String hibernateCfgUrl;
    private final String jarUrl;
    private final ResourceType resourceType;
    private final Map<String, EntityBuilder> entityBuilderMap;
    private final Map<String, StandardServiceRegistry> serviceRegistryMap;
    private final Map<String, SessionFactory> sessionFactoryMap;
    private final ObjectMapper objectMapper;
    private final EntityMetaRepository entityMetaRepository;
    private final Lock ormWriteLock;
    private final CoordinationService coordinationService;
    private final DomainResourceClient domainResourceClient;
    private boolean bootstrapped = false;

    @Autowired
    public EntityMetaServiceImpl(EntityMetaRepository entityMetaRepository, @Value(value="${server.port}") Integer port, ObjectMapper objectMapper, DomainResourceClient domainResourceClient, CoordinationService coordinationService, ConcurrencyService concurrencyService) {
        this.hibernateCfgUrl = String.format("http://127.0.0.1:%d/auxiliary/%%s/hibernate-cfg.xml", port);
        this.jarUrl = String.format("http://127.0.0.1:%d/auxiliary/%%s/%%s.jar", port);
        this.resourceType = new ResourceType("model", null);
        this.entityBuilderMap = new LinkedHashMap();
        this.serviceRegistryMap = new LinkedHashMap();
        this.sessionFactoryMap = new LinkedHashMap();
        this.objectMapper = objectMapper;
        this.entityMetaRepository = entityMetaRepository;
        this.ormWriteLock = concurrencyService.getOrmWriteLock();
        this.coordinationService = coordinationService;
        this.domainResourceClient = domainResourceClient;
    }

    public EntityBuilder getEntityBuilder(String databaseConnectionName) {
        return this.entityBuilderMap.getOrDefault(databaseConnectionName, null);
    }

    @Retryable
    public EntityMeta insert(EntityMeta entityMeta) {
        if (entityMeta.getEntityName() == null) {
            return null;
        }
        if (this.entityMetaRepository.findOne((Serializable)((Object)entityMeta.getEntityName())) != null) {
            return null;
        }
        this.entityMetaRepository.saveAndFlush((Object)entityMeta);
        this.domainResourceClient.insert(this.newDomainResource(entityMeta));
        this.coordinationService.updateShardByAll(entityMeta.getDatabaseConnectionName(), Long.valueOf(this.coordinationService.getNextVersion()));
        return entityMeta;
    }

    @Retryable
    public EntityMeta save(EntityMeta entityMeta) {
        if (entityMeta.getEntityName() == null) {
            return null;
        }
        if (this.entityMetaRepository.findOne((Serializable)((Object)entityMeta.getEntityName())) == null) {
            this.insert(entityMeta);
        } else {
            this.update(entityMeta);
        }
        return entityMeta;
    }

    @Transactional
    @Retryable
    public EntityMeta get(String entityName) {
        EntityMeta entityMeta = (EntityMeta)this.entityMetaRepository.getOne((Serializable)((Object)entityName));
        this.fillCategory(entityMeta);
        Hibernate.initialize((Object)entityMeta);
        Hibernate.initialize((Object)entityMeta.getFields());
        return entityMeta;
    }

    @Transactional
    @Retryable
    public List<EntityMeta> list(boolean shouldExpand) {
        try (Debugger debugger = new Debugger(log, new String[]{"loading entity classes"});){
            List entityMetas = this.entityMetaRepository.findAll();
            entityMetas.forEach(arg_0 -> this.fillCategory(arg_0));
            List list = shouldExpand ? this.expand(entityMetas) : entityMetas;
            return list;
        }
    }

    @Transactional
    @Retryable
    public Page<EntityMeta> list(boolean shouldExpand, Pageable pageable) {
        Page entityMetas = this.entityMetaRepository.findAll(pageable);
        entityMetas.forEach(arg_0 -> this.fillCategory(arg_0));
        return shouldExpand ? this.expand(entityMetas) : entityMetas;
    }

    @Transactional
    public Page<EntityMeta> list(String keyWord, boolean shouldExpand, Pageable pageable) {
        String likeString = '%' + keyWord + '%';
        Specification specification = (root, query, cb) -> cb.or((Expression)cb.like(root.get(NAME_FLD).as(String.class), likeString), (Expression)cb.like(root.get(DESC_FLD).as(String.class), likeString));
        Page entityMetas = this.entityMetaRepository.findAll(specification, pageable);
        entityMetas.forEach(arg_0 -> this.fillCategory(arg_0));
        return shouldExpand ? this.expand(entityMetas) : entityMetas;
    }

    @Retryable
    public void update(EntityMeta entityMeta) {
        if (entityMeta.getEntityName() == null || this.entityMetaRepository.findOne((Serializable)((Object)entityMeta.getEntityName())) == null) {
            return;
        }
        this.entityMetaRepository.saveAndFlush((Object)entityMeta);
        List resources = (List)this.domainResourceClient.list(entityMeta.getEntityName(), this.resourceType.getName()).getData();
        if (resources == null || resources.isEmpty()) {
            this.domainResourceClient.insert(this.newDomainResource(entityMeta));
        } else {
            resources.stream().filter(resource -> !resource.getDomainCategory().getId().equals(entityMeta.getDomainCategory().getId())).forEach(resource -> this.domainResourceClient.update(resource.getId(), this.newDomainResource(entityMeta)));
        }
        this.coordinationService.updateShardByAll(entityMeta.getDatabaseConnectionName(), Long.valueOf(this.coordinationService.getNextVersion()));
    }

    @Retryable
    public void delete(String entityName) {
        String dbConnName;
        EntityMeta entityMeta = (EntityMeta)this.entityMetaRepository.findOne((Serializable)((Object)entityName));
        if (entityMeta == null) {
            return;
        }
        this.entityMetaRepository.delete((Object)entityMeta);
        this.loadEntityClasses();
        List domainResources = (List)this.domainResourceClient.list(entityName, this.resourceType.getName()).getData();
        if (domainResources != null) {
            domainResources.forEach(resource -> this.domainResourceClient.delete(resource.getId()));
        }
        if (0L < this.entityMetaRepository.countAllByDatabaseConnectionName(dbConnName = entityMeta.getDatabaseConnectionName())) {
            this.coordinationService.updateShardByAll(dbConnName, Long.valueOf(this.coordinationService.getNextVersion()));
        } else {
            this.coordinationService.deleteShardByAll(dbConnName);
        }
    }

    @Retryable
    public List<EntityMeta> writeMetas(Map<String, EntityMeta> entityMetaMap) {
        Set pseudoDeletableShards;
        List deletableEntityMetas;
        List<String> entityNames;
        boolean shouldSave;
        List<EntityMeta> updatableEntityMetas = entityMetaMap.values().stream().filter(Objects::nonNull).collect(Collectors.toList());
        boolean bl = shouldSave = !updatableEntityMetas.isEmpty();
        if (shouldSave) {
            this.entityMetaRepository.save(updatableEntityMetas);
            updatableEntityMetas.forEach(entityMeta -> {
                List resources = (List)this.domainResourceClient.list(entityMeta.getEntityName(), this.resourceType.getName()).getData();
                if (resources == null || resources.isEmpty()) {
                    this.domainResourceClient.insert(this.newDomainResource(entityMeta));
                } else {
                    resources.stream().filter(resource -> !resource.getDomainCategory().getId().equals(entityMeta.getDomainCategory().getId())).forEach(resource -> this.domainResourceClient.update(resource.getId(), this.newDomainResource(entityMeta)));
                }
            });
        }
        boolean shouldDelete = !(entityNames = entityMetaMap.entrySet().stream().filter(entry -> entry.getValue() == null).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty();
        List list = deletableEntityMetas = shouldDelete ? this.entityMetaRepository.findAll(entityNames) : Collections.emptyList();
        if (shouldDelete) {
            this.entityMetaRepository.delete((Iterable)deletableEntityMetas);
            entityNames.forEach(entityName -> {
                entityMetaMap.remove(entityName);
                List resources = (List)this.domainResourceClient.list(entityName, this.resourceType.getName()).getData();
                if (resources != null) {
                    resources.forEach(resource -> this.domainResourceClient.delete(resource.getId()));
                }
            });
        }
        if (shouldSave) {
            this.entityMetaRepository.flush();
        }
        Sets.SetView updatableShards = shouldSave ? updatableEntityMetas.stream().map(EntityMeta::getDatabaseConnectionName).collect(Collectors.toSet()) : Collections.emptySet();
        Sets.SetView deletableShards = shouldDelete ? Sets.difference(deletableEntityMetas.stream().map(EntityMeta::getDatabaseConnectionName).collect(Collectors.toSet()), updatableShards) : Collections.emptySet();
        shouldDelete = !deletableShards.isEmpty();
        Set set = pseudoDeletableShards = shouldDelete ? this.entityMetaRepository.findAllByDatabaseConnectionNameIn((Iterable)deletableShards).stream().map(EntityMeta::getDatabaseConnectionName).collect(Collectors.toSet()) : Collections.emptySet();
        if (!pseudoDeletableShards.isEmpty()) {
            deletableShards = Sets.difference((Set)deletableShards, pseudoDeletableShards);
            updatableShards = Sets.union(updatableShards, pseudoDeletableShards);
        }
        deletableShards.forEach(arg_0 -> ((CoordinationService)this.coordinationService).deleteShardByAll(arg_0));
        updatableShards.forEach(shard -> this.coordinationService.updateShardByAll(shard, Long.valueOf(this.coordinationService.getNextVersion())));
        return updatableEntityMetas;
    }

    public void refresh() {
        List dbConnNames = this.coordinationService.listLocalHandledDatabaseConnectionNames();
        this.renewEntityBuilders((Iterable)dbConnNames);
        this.reNewHibernate((Iterable)dbConnNames);
    }

    public void getEntitiesAsJAR(String dbConnName, OutputStream byteArrayOutputStream) {
        try (JarOutputStream jarOutputStream = new JarOutputStream(byteArrayOutputStream);){
            String packageStr = "cn.gtmap.dynamic.entity".replace('.', '/');
            EntityBuilder entityBuilder = (EntityBuilder)this.entityBuilderMap.get(dbConnName);
            for (EntityMeta entityMeta : this.entityMetaRepository.findAllByDatabaseConnectionName(dbConnName)) {
                JarEntry classJarEntry = new JarEntry(String.format("%s/%s.class", packageStr, entityMeta.getEntityName()));
                jarOutputStream.putNextEntry(classJarEntry);
                jarOutputStream.write(entityBuilder.withEntityMeta(entityMeta).buildBytes());
                jarOutputStream.flush();
            }
        }
        catch (IOException ex) {
            this.handleException((Throwable)ex, "\u52a8\u6001\u751f\u6210\u5b9e\u4f53JAR\u5305\u5931\u8d25", new Transaction[0]);
        }
    }

    @Transactional
    public Serializable getTypedId(String entityName, String idAsString) {
        return this.convertIdFromString(idAsString, this.getIdType(entityName));
    }

    SessionFactory getSessionFactory(String databaseConnectionName) {
        return (SessionFactory)this.sessionFactoryMap.get(databaseConnectionName);
    }

    private DomainResource newDomainResource(EntityMeta entityMeta) {
        return new DomainResource(null, entityMeta.getEntityName(), entityMeta.getDomainCategory(), this.resourceType);
    }

    private Class<?> getIdType(String entityName) {
        return String.class;
    }

    private Serializable convertIdFromString(String entityId, Class<?> cls) {
        try {
            if (Integer.class.equals(cls)) {
                return (Serializable)this.objectMapper.readValue(entityId, cls);
            }
            if (String.class.equals(cls) || Date.class.equals(cls)) {
                return (Serializable)this.objectMapper.readValue('\"' + entityId + '\"', cls);
            }
            throw new TypeMismatchException(String.format("\u4e0d\u652f\u6301%s\u7c7b\u578b\u7684\u6a21\u578b\u5b9e\u4f8bID[%s]", cls.toString(), entityId));
        }
        catch (Exception ex) {
            log.error(ex.getMessage());
            return entityId;
        }
    }

    void bootstrapIfNeeded() {
        if (!this.bootstrapped) {
            this.loadEntityClasses();
            this.bootstrapped = true;
        }
    }

    private synchronized void loadEntityClasses() {
        try {
            List dbConnNames = this.coordinationService.listLocalHandledDatabaseConnectionNames();
            this.renewEntityBuilders((Iterable)dbConnNames);
            for (EntityMeta entityMeta : this.entityMetaRepository.findAllByDatabaseConnectionNameIn((Iterable)dbConnNames)) {
                Debugger dbg = new Debugger(log, new String[]{String.format("loading %s", entityMeta.getEntityName())});
                Throwable throwable = null;
                try {
                    this.putEntityClass(entityMeta);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dbg == null) continue;
                    if (throwable != null) {
                        try {
                            dbg.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dbg.close();
                }
            }
            this.reNewHibernate((Iterable)dbConnNames);
        }
        catch (Exception ex) {
            this.handleException((Throwable)ex, "Hibernate\u91cd\u65b0\u6620\u5c04\u5b9e\u4f53\u5931\u8d25", new Transaction[0]);
        }
    }

    private synchronized void renewEntityBuilders(Iterable<String> databaseConnectionNames) {
        this.entityBuilderMap.clear();
        for (String databaseConnectionName : databaseConnectionNames) {
            try {
                this.entityBuilderMap.put(databaseConnectionName, this.newEntityBuilder(databaseConnectionName));
            }
            catch (Exception ex) {
                this.handleException((Throwable)ex, "\u5237\u65b0\u5b9e\u4f53\u6784\u5efa\u5668\u5931\u8d25", new Transaction[0]);
            }
        }
    }

    private EntityBuilder newEntityBuilder(String databaseConnectionName) throws MalformedURLException {
        URL url = new URL(String.format(this.jarUrl, databaseConnectionName, UUID.randomUUID().toString()));
        EntityClassLoader classLoader = new EntityClassLoader(new URL[]{url}, this.getClass().getClassLoader());
        return new EntityBuilder().withEntityClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEntityClass(EntityMeta entityMeta) {
        String entityName = entityMeta.getEntityName();
        try {
            String className = String.format("%s.%s", "cn.gtmap.dynamic.entity", entityName);
            EntityMetaServiceImpl entityMetaServiceImpl = this;
            synchronized (entityMetaServiceImpl) {
                EntityClassLoader classLoader = ((EntityBuilder)this.entityBuilderMap.get(entityMeta.getDatabaseConnectionName())).getEntityClassLoader();
                classLoader.loadClass(className);
            }
        }
        catch (ClassNotFoundException ex) {
            this.handleException((Throwable)ex, String.format("\u52a0\u8f7d%s\u5931\u8d25", entityName), new Transaction[0]);
        }
    }

    private void reNewHibernate(Iterable<String> databaseConnectionNames) {
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        try {
            this.ormWriteLock.lock();
            this.serviceRegistryMap.clear();
            this.sessionFactoryMap.clear();
            for (String dbConnName : databaseConnectionNames) {
                try {
                    StandardServiceRegistry serviceRegistry = this.newServiceRegistry(dbConnName);
                    SessionFactory sessionFactory = new MetadataSources((ServiceRegistry)serviceRegistry).buildMetadata().buildSessionFactory();
                    this.serviceRegistryMap.put(dbConnName, serviceRegistry);
                    this.sessionFactoryMap.put(dbConnName, sessionFactory);
                }
                catch (Exception ex) {
                    exceptions.add(ex);
                }
            }
            if (!exceptions.isEmpty()) {
                throw new MetaException();
            }
        }
        catch (MetaException ex) {
            if (exceptions.isEmpty()) {
                throw ex;
            }
            throw new MetaException(((Exception)exceptions.getFirst()).getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new MetaException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.ormWriteLock.unlock();
        }
    }

    private StandardServiceRegistry newServiceRegistry(String dbConnName) {
        StandardServiceRegistry serviceRegistry = null;
        try {
            EntityClassLoader classLoader = ((EntityBuilder)this.entityBuilderMap.get(dbConnName)).getEntityClassLoader();
            serviceRegistry = new StandardServiceRegistryBuilder().configure(new URL(String.format(this.hibernateCfgUrl, dbConnName))).addService(ClassLoaderService.class, (Service)new ClassLoaderServiceImpl((ClassLoader)classLoader)).build();
            Field valuesField = StandardServiceRegistryImpl.class.getDeclaredField("configurationValues");
            valuesField.setAccessible(true);
            log.debug(String.format("StandardServiceRegistryImpl::configurationValues == %s", this.objectMapper.writeValueAsString(valuesField.get(serviceRegistry))));
        }
        catch (Exception ex) {
            if (serviceRegistry != null) {
                StandardServiceRegistryBuilder.destroy(serviceRegistry);
            }
            this.handleException((Throwable)ex, "\u5237\u65b0Hibernate Service Registry\u5931\u8d25", new Transaction[0]);
        }
        return serviceRegistry;
    }

    private void handleException(Throwable originalException, String message, Transaction ... transactions) {
        log.error(message, originalException);
        for (Transaction transaction : transactions) {
            transaction.rollback();
        }
        throw new MetaException(message, originalException);
    }

    private List<EntityMeta> expand(List<EntityMeta> entityMetas) {
        entityMetas.forEach(entityMeta -> Hibernate.initialize((Object)entityMeta.getFields()));
        return entityMetas;
    }

    private Page<EntityMeta> expand(Page<EntityMeta> entityMetas) {
        this.expand(entityMetas.getContent());
        return entityMetas;
    }

    private void fillCategory(EntityMeta entityMeta) {
        if (entityMeta.getDomainCategory() == null) {
            List domainResources = (List)this.domainResourceClient.list(entityMeta.getEntityName(), this.resourceType.getName()).getData();
            if (domainResources == null || domainResources.isEmpty()) {
                return;
            }
            entityMeta.setDomainCategory(((DomainResource)domainResources.get(0)).getDomainCategory());
        }
    }
}

