/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.domain.helpers.EntityBuilder;
import cn.gtmap.gtc.utils.HttpUtils;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface EntityMetaService {
    public EntityBuilder getEntityBuilder(String var1);

    public EntityMeta insert(EntityMeta var1);

    @Deprecated
    public EntityMeta save(EntityMeta var1);

    @Deprecated
    default public List<EntityMeta> saveMetas(EntityMeta ... entityMetas) {
        return this.saveMetas(Arrays.asList(entityMetas));
    }

    default public List<EntityMeta> saveMetas(Collection<EntityMeta> entityMetas) {
        LinkedHashMap<String, EntityMeta> entityMetaMap = new LinkedHashMap<String, EntityMeta>();
        for (EntityMeta entityMeta : entityMetas) {
            entityMetaMap.put(entityMeta.getEntityName(), entityMeta);
        }
        return this.writeMetas(entityMetaMap);
    }

    public EntityMeta get(String var1);

    default public List<EntityMeta> list() {
        return this.list(true);
    }

    public List<EntityMeta> list(boolean var1);

    @Deprecated
    default public Page<EntityMeta> list(int pageNumber, int pageSize, Map<String, Boolean> orderBy, boolean shouldExpand) {
        return this.list(shouldExpand, HttpUtils.toPageable((int)pageNumber, (int)pageSize, orderBy));
    }

    public Page<EntityMeta> list(boolean var1, Pageable var2);

    @Deprecated
    default public Page<EntityMeta> list(String keyWord, int pageNumber, int pageSize, Map<String, Boolean> orderBy, boolean shouldExpand) {
        return this.list(keyWord, shouldExpand, HttpUtils.toPageable((int)pageNumber, (int)pageSize, orderBy));
    }

    public Page<EntityMeta> list(String var1, boolean var2, Pageable var3);

    public void update(EntityMeta var1);

    public void delete(String var1);

    @Deprecated
    default public void deleteMetas(String ... entityNames) {
        this.deleteMetas(Arrays.asList(entityNames));
    }

    default public void deleteMetas(Collection<String> entityNames) {
        LinkedHashMap<String, Object> entityMetaMap = new LinkedHashMap<String, Object>();
        for (String entityName : entityNames) {
            entityMetaMap.put(entityName, null);
        }
        this.writeMetas(entityMetaMap);
    }

    public List<EntityMeta> writeMetas(Map<String, EntityMeta> var1);

    public Serializable getTypedId(String var1, String var2);

    public void refresh();

    public void getEntitiesAsJAR(String var1, OutputStream var2);
}

