/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.model.aspect.EntityMetaModifier;
import cn.gtmap.gtc.model.domain.entity.EntityMeta;
import cn.gtmap.gtc.model.domain.entity.QueryMeta;
import cn.gtmap.gtc.model.domain.helpers.EntityHelper;
import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.exception.MetaException;
import cn.gtmap.gtc.model.service.ConcurrencyService;
import cn.gtmap.gtc.model.service.EntityCrudService;
import cn.gtmap.gtc.model.service.EntityMetaService;
import cn.gtmap.gtc.model.service.EntityMetaServiceImpl;
import cn.gtmap.gtc.model.service.QueryMetaService;
import cn.gtmap.gtc.model.service.QueryService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.hibernate5.Hibernate5Module;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLDataException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import javax.persistence.Id;
import javax.persistence.metamodel.EntityType;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;

@Service
public class EntityCrudServiceQueryServiceSelfImpl
implements EntityCrudService,
QueryService {
    private static final Logger log = LoggerFactory.getLogger(EntityCrudServiceQueryServiceSelfImpl.class);
    private final EntityMetaService entityMetaService;
    QueryMetaService queryMetaService;
    private final Lock ormReadLock;
    private final ObjectMapper objectMapper;
    private final EntityMetaModifier entityMetaModifier;

    @Autowired
    public EntityCrudServiceQueryServiceSelfImpl(EntityMetaService entityMetaService, QueryMetaService queryMetaService, ConcurrencyService concurrencyService, ObjectMapper objectMapper, EntityMetaModifier entityMetaModifier) {
        objectMapper.registerModule((Module)new Hibernate5Module());
        this.objectMapper = objectMapper;
        this.entityMetaService = entityMetaService;
        this.queryMetaService = queryMetaService;
        this.entityMetaModifier = entityMetaModifier;
        this.ormReadLock = concurrencyService.getOrmReadLock();
    }

    /*
     * Exception decompiling
     */
    @Retryable
    public Serializable insert(String entityName, String entityJSON) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Retryable
    public <T extends Serializable> Object get(String entityName, T id, String ... fieldChain) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Retryable
    public List<Object> list(String entityName) {
        return this.list(entityName, (String)null);
    }

    /*
     * Exception decompiling
     */
    @Retryable
    public List<Object> list(String entityName, String proId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Retryable
    public Page<Object> list(String entityName, Pageable pageable) {
        return this.list(entityName, null, pageable);
    }

    /*
     * Exception decompiling
     */
    @Retryable
    public Page<Object> list(String entityName, String proId, Pageable pageable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Retryable
    public <T extends Serializable> void update(String entityName, T id, String jsonString) {
        try (Session session = this.getSessionByEntityName(entityName);){
            Object entity;
            this.ormReadLock.lock();
            Transaction transaction = session.beginTransaction();
            Class entityClass = this.findEntityClass(entityName);
            Object object = entity = id instanceof String ? session.get(entityClass, this.entityMetaService.getTypedId(entityName, id.toString())) : session.get(entityClass, id);
            if (entity == null) {
                throw new SQLDataException();
            }
            Object newEntity = this.objectMapper.readValue(jsonString, entityClass);
            session.detach(entity);
            EntityHelper.clearEmptyIdOf((Object)newEntity);
            EntityHelper.writeIdOf((Object)newEntity, (Object)EntityHelper.readIdOf((Object)entity));
            this.entityMetaModifier.touch(newEntity);
            session.saveOrUpdate(newEntity);
            transaction.commit();
        }
        catch (Exception ex) {
            throw this.toCrudEntityException((Throwable)ex, String.format("%s[%s]\u66f4\u65b0\u5931\u8d25", entityName, id), new Transaction[0]);
        }
        finally {
            this.ormReadLock.unlock();
        }
    }

    @Retryable
    public <T extends Serializable> void updateFields(String entityName, T id, String jsonString) {
        try (Session session = this.getSessionByEntityName(entityName);){
            Object entity;
            this.ormReadLock.lock();
            Transaction transaction = session.beginTransaction();
            Class entityClass = this.findEntityClass(entityName);
            Object object = entity = id instanceof String ? session.get(entityClass, this.entityMetaService.getTypedId(entityName, id.toString())) : session.get(entityClass, id);
            if (entity == null) {
                throw new SQLDataException();
            }
            JsonNode rootNode = this.objectMapper.readTree(jsonString);
            Object newEntity = this.objectMapper.readValue(jsonString, entityClass);
            this.updateFieldsOf(entity, newEntity, (ObjectNode)rootNode);
            this.entityMetaModifier.touch(entity);
            session.update(entity);
            transaction.commit();
        }
        catch (Exception ex) {
            throw this.toCrudEntityException((Throwable)ex, String.format("%s[%s]\u66f4\u65b0\u5931\u8d25", entityName, id), new Transaction[0]);
        }
        finally {
            this.ormReadLock.unlock();
        }
    }

    @Retryable
    public <T extends Serializable> void delete(String entityName, T id) throws EntityCrudException {
        try (Session session = this.getSessionByEntityName(entityName);){
            this.ormReadLock.lock();
            Transaction transaction = session.beginTransaction();
            Class entityClass = this.findEntityClass(entityName);
            Object entity = id instanceof String ? session.get(entityClass, this.entityMetaService.getTypedId(entityName, id.toString())) : session.get(entityClass, id);
            session.delete(entity);
            transaction.commit();
        }
        catch (Exception ex) {
            throw this.toCrudEntityException((Throwable)ex, String.format("%s[%s]\u5220\u9664\u5931\u8d25", entityName, id), new Transaction[0]);
        }
        finally {
            this.ormReadLock.unlock();
        }
    }

    @Retryable
    public Page<Object> listByNamedQuery(String queryName, Map<String, Object> parameters, Pageable pageable) {
        QueryMeta queryMeta = this.queryMetaService.get(queryName);
        String dbConnName = this.queryMetaService.get(queryName).getDatabaseConnectionName();
        return this.listByAnonymousQuery(queryMeta.getQueryStatement(), parameters, queryMeta.getQueryLanguage(), dbConnName, pageable);
    }

    /*
     * Exception decompiling
     */
    @Retryable
    public Page<Object> listByAnonymousQuery(String statement, Map<String, Object> parameters, String language, String databaseConnectionName, Pageable pageable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Session getSessionByEntityName(String entityName) {
        try {
            if (Strings.isNullOrEmpty((String)entityName)) {
                throw new EntityCrudException("\u6a21\u578b\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u521b\u5efa\u6570\u636e\u5e93\u4f1a\u8bdd");
            }
            EntityMeta entityMeta = this.entityMetaService.get(entityName);
            if (entityMeta == null) {
                throw new EntityCrudException(String.format("\u672a\u627e\u5230\u6a21\u578b%s\u7684\u5b9a\u4e49", entityName));
            }
            String dbConnName = entityMeta.getDatabaseConnectionName();
            if (Strings.isNullOrEmpty((String)dbConnName)) {
                throw new EntityCrudException(String.format("\u672a\u627e\u5230\u6a21\u578b%s\u5bf9\u5e94\u7684\u6570\u636e\u5e93", entityName));
            }
            SessionFactory sessionFactory = this.getSessionFactoryByDatabaseConnectionName(dbConnName);
            if (sessionFactory == null) {
                throw new EntityCrudException(String.format("\u672a\u627e\u5230\u6570\u636e\u5e93%s\u5bf9\u5e94\u7684\u4f1a\u8bdd\u5de5\u5382", dbConnName));
            }
            return sessionFactory.openSession();
        }
        catch (EntityCrudException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EntityCrudException(ex.getMessage());
        }
    }

    EntityType<?> getEntityType(String entityName, Session session) throws ClassNotFoundException {
        return session.getEntityManagerFactory().getMetamodel().entity(this.findEntityClass(entityName));
    }

    EntityCrudException toCrudEntityException(Throwable originalException, String message, Transaction ... transactions) throws EntityCrudException {
        log.error(message, originalException);
        for (Transaction transaction : transactions) {
            transaction.rollback();
        }
        return new EntityCrudException(message, originalException);
    }

    Class<?> findEntityClass(String entityName) throws ClassNotFoundException {
        String className = String.format("%s.%s", "cn.gtmap.dynamic.entity", entityName);
        String dbConnName = this.entityMetaService.get(entityName).getDatabaseConnectionName();
        return this.entityMetaService.getEntityBuilder(dbConnName).findByClassLoaders(className);
    }

    private void updateFieldsOf(Object entity, Object fromEntity, ObjectNode node) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Iterator fields = node.fields();
        Class<?> entityClass = entity.getClass();
        while (fields.hasNext()) {
            Map.Entry fieldEntry = (Map.Entry)fields.next();
            String fieldName = (String)fieldEntry.getKey();
            JsonNode fieldNode = (JsonNode)fieldEntry.getValue();
            Field field = entityClass.getDeclaredField(fieldName);
            if (field.getDeclaredAnnotation(Id.class) != null) continue;
            if (fieldNode.isNull()) {
                EntityHelper.writeFieldOf((Object)entity, (String)fieldName, null);
                continue;
            }
            Object entityFieldValue = EntityHelper.readFieldOf((Object)entity, (String)fieldName);
            Object fromFieldValue = EntityHelper.readFieldOf((Object)fromEntity, (String)fieldName);
            if (entityFieldValue != null) {
                if (fieldNode.isObject()) {
                    String fromPackageName = fromFieldValue.getClass().getPackage().getName();
                    Serializable entityId = EntityHelper.readIdOf((Object)entityFieldValue);
                    Serializable fromEntityId = EntityHelper.readIdOf((Object)fromFieldValue);
                    if ("cn.gtmap.dynamic.entity".equals(fromPackageName) && Objects.nonNull(entityId) && entityId.equals(fromEntityId)) {
                        this.updateFieldsOf(entityFieldValue, fromFieldValue, (ObjectNode)fieldNode);
                        continue;
                    }
                } else if (fieldNode.isArray()) {
                    String fieldTypeName = field.getType().getName();
                    String fieldGenericTypeName = field.getGenericType().getTypeName();
                    if (fieldGenericTypeName.matches(String.format("^%s<%s(\\.\\w+)+>$", fieldTypeName, "cn.gtmap.dynamic.entity"))) {
                        this.updateArrayField((Collection)entityFieldValue, (Collection)fromFieldValue, (ArrayNode)fieldNode);
                        continue;
                    }
                }
            }
            EntityHelper.writeFieldOf((Object)entity, (String)fieldName, (Object)fromFieldValue);
        }
    }

    private void updateArrayField(Collection<Object> entities, Collection<Object> fromEntities, ArrayNode entitiesNode) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Map entityMap = this.entitiesToMap(entities);
        Iterator<Object> fromEntityIterator = fromEntities.iterator();
        while (fromEntityIterator.hasNext()) {
            Object fromEntity = fromEntityIterator.next();
            Serializable fromEntityId = EntityHelper.readIdOf((Object)fromEntity);
            if (entityMap.containsKey(fromEntityId)) continue;
            fromEntityIterator.remove();
        }
        Map fromEntityMap = this.entitiesToMap(fromEntities);
        Iterator<Object> entityIterator = entities.iterator();
        for (int i = 0; i < entitiesNode.size(); ++i) {
            ObjectNode entityNode = (ObjectNode)entitiesNode.get(i);
            Object entity = entityIterator.next();
            try {
                Serializable entityId = EntityHelper.readIdOf((Object)entity);
                if (fromEntityMap.containsKey(entityId)) {
                    this.updateFieldsOf(entity, fromEntityMap.get(entityId), entityNode);
                    continue;
                }
                fromEntities.add(entity);
                continue;
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
        }
    }

    private Map<Serializable, Object> entitiesToMap(Collection<Object> entities) {
        return entities.stream().collect(Collectors.toMap(entity -> {
            Serializable id = null;
            try {
                id = EntityHelper.readIdOf((Object)entity);
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
            return id;
        }, entity -> entity));
    }

    private SessionFactory getSessionFactoryByDatabaseConnectionName(String databaseConnectionName) {
        if (this.entityMetaService instanceof EntityMetaServiceImpl) {
            EntityMetaServiceImpl entityMetaServiceImpl = (EntityMetaServiceImpl)this.entityMetaService;
            entityMetaServiceImpl.bootstrapIfNeeded();
            return entityMetaServiceImpl.getSessionFactory(databaseConnectionName);
        }
        throw new MetaException("getSessionFactory not implemented");
    }

    public EntityMetaService getEntityMetaService() {
        return this.entityMetaService;
    }

    public QueryMetaService getQueryMetaService() {
        return this.queryMetaService;
    }
}

