/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.exception.PeerUnreachableException;
import cn.gtmap.gtc.model.service.AbstractPeerService;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityCrudService;
import cn.gtmap.gtc.model.service.EntityCrudServiceQueryServiceSelfImpl;
import cn.gtmap.gtc.model.service.EntityMetaService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service
public class EntityCrudServicePeerImpl
extends AbstractPeerService
implements EntityCrudService {
    private final CoordinationService coordinationService;
    private final EntityMetaService entityMetaService;
    private final EntityCrudService localEntityCrudService;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;

    @Autowired
    public EntityCrudServicePeerImpl(CoordinationService coordinationService, EntityMetaService entityMetaService, EntityCrudServiceQueryServiceSelfImpl localEntityCrudService, ObjectMapper objectMapper, HttpClient httpClient) {
        this.objectMapper = objectMapper;
        this.coordinationService = coordinationService;
        this.entityMetaService = entityMetaService;
        this.localEntityCrudService = localEntityCrudService;
        this.httpClient = httpClient;
    }

    public Serializable insert(String entityName, String jsonString) {
        try {
            return (Serializable)this.request(RequestMethod.POST, this.getPeerLocation(entityName), jsonString, String.class).orElseThrow(() -> new EntityCrudException("\u6a21\u578b\u521b\u5efa\u5931\u8d25"));
        }
        catch (PeerUnreachableException ex) {
            return this.refreshLocalService(entityName).insert(entityName, jsonString);
        }
    }

    public <T extends Serializable> Object get(String entityName, T id, String ... fieldChain) {
        try {
            String entityPath = (String)Lists.asList((Object)id.toString(), (Object[])fieldChain).stream().reduce((left, right) -> String.format("%s/%s", left, right)).orElseThrow(() -> new EntityCrudException("\u4e0d\u6b63\u786e\u7684\u6a21\u578b\u5b9e\u4f8b\u8def\u5f84"));
            String peerLocation = String.format("%s/%s", this.getPeerLocation(entityName), entityPath);
            return this.request(RequestMethod.GET, peerLocation, Object.class);
        }
        catch (PeerUnreachableException ex) {
            return this.refreshLocalService(entityName).get(entityName, (Serializable)fieldChain, new String[0]);
        }
    }

    public List<Object> list(String entityName, String proId) {
        try {
            String peerLocation = this.getPeerLocation(entityName);
            List<Pair> pairs = Strings.isNullOrEmpty((String)proId) ? null : Collections.singletonList(Pair.of((Object)"proId", (Object)proId));
            PageResult result = (PageResult)this.request(RequestMethod.GET, peerLocation, pairs, PageResult.class).orElseThrow(() -> new EntityCrudException("\u6a21\u578b\u67e5\u8be2\u5931\u8d25"));
            return (List)result.getData();
        }
        catch (PeerUnreachableException ex) {
            return this.refreshLocalService(entityName).list(entityName, proId);
        }
    }

    public Page<Object> list(String entityName, String proId, Pageable pageable) {
        try {
            String peerLocation = this.getPeerLocation(entityName);
            List pairs = this.getPairsFromPageable(pageable);
            if (null != proId) {
                pairs.add(Pair.of((Object)"proId", (Object)proId));
            }
            PageResult result = (PageResult)this.request(RequestMethod.GET, peerLocation, (Collection)pairs, PageResult.class).orElseThrow(() -> new EntityCrudException("\u6a21\u578b\u67e5\u8be2\u5931\u8d25"));
            return result.toPage();
        }
        catch (PeerUnreachableException ex) {
            return this.refreshLocalService(entityName).list(entityName, proId, pageable);
        }
    }

    public <T extends Serializable> void update(String entityName, T id, String jsonString) {
        try {
            String peerLocation = String.format("%s/%s", this.getPeerLocation(entityName), id.toString());
            this.request(RequestMethod.PUT, peerLocation, jsonString, PageResult.class);
        }
        catch (PeerUnreachableException ex) {
            this.refreshLocalService(entityName).update(entityName, id, jsonString);
        }
    }

    public <T extends Serializable> void updateFields(String entityName, T id, String jsonString) {
        try {
            String peerLocation = String.format("%s/%s", this.getPeerLocation(entityName), id.toString());
            this.request(RequestMethod.PATCH, peerLocation, jsonString, PageResult.class);
        }
        catch (PeerUnreachableException ex) {
            this.refreshLocalService(entityName).updateFields(entityName, id, jsonString);
        }
    }

    public <T extends Serializable> void delete(String entityName, T id) {
        try {
            String peerLocation = String.format("%s/%s", this.getPeerLocation(entityName), id.toString());
            this.request(RequestMethod.DELETE, peerLocation, Void.class);
        }
        catch (PeerUnreachableException ex) {
            this.refreshLocalService(entityName).delete(entityName, id);
        }
    }

    private EntityCrudService refreshLocalService(String entityName) {
        String shardName = this.getShardNameByEntityName(entityName);
        Long version = this.coordinationService.getNextVersion();
        this.coordinationService.updateShardBySelf(shardName, version);
        return this.localEntityCrudService;
    }

    private String getPeerLocation(String entityName) {
        String peerLocation = this.coordinationService.getPeerLocation(this.getShardNameByEntityName(entityName));
        if (peerLocation == null) {
            throw new EntityCrudException("\u6ca1\u6709\u53ef\u7528\u7684\u8282\u70b9");
        }
        return String.format("%s/v1/models/%s", peerLocation, entityName);
    }

    private String getShardNameByEntityName(String entityName) {
        return this.entityMetaService.get(entityName).getDatabaseConnectionName();
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }
}

