/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.model.domain.dao.DatabaseConnectionRepository;
import cn.gtmap.gtc.model.domain.entity.DatabaseConnection;
import cn.gtmap.gtc.model.domain.entity.EntityFieldMeta;
import cn.gtmap.gtc.model.exception.DatabaseConnectionException;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.DatabaseConnectionService;
import cn.gtmap.gtc.model.service.DatabaseMetaService;
import cn.gtmap.gtc.model.service.EntityMetaServiceImpl;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DatabaseMetaServiceSelfImpl
implements DatabaseMetaService,
DatabaseConnectionService {
    private final DatabaseConnectionRepository connectionRepository;
    private final CoordinationService coordinationService;
    private final EntityMetaServiceImpl entityMetaService;

    @Autowired
    public DatabaseMetaServiceSelfImpl(DatabaseConnectionRepository connectionRepository, CoordinationService coordinationService, EntityMetaServiceImpl entityMetaService) {
        this.connectionRepository = connectionRepository;
        this.coordinationService = coordinationService;
        this.entityMetaService = entityMetaService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validate(DatabaseConnection databaseConnection) throws DatabaseConnectionException {
        try {
            if (null == databaseConnection) {
                throw new DatabaseConnectionException("\u6570\u636e\u5e93\u8fde\u63a5\u4e3a\u7a7a");
            }
            String jdbcDriverName = databaseConnection.getJdbcDriver();
            if (Strings.isNullOrEmpty((String)jdbcDriverName)) {
                throw new DatabaseConnectionException("JDBC\u9a71\u52a8\u4e3a\u7a7a");
            }
            String jdbcUrl = databaseConnection.getJdbcUrl();
            if (Strings.isNullOrEmpty((String)jdbcUrl)) {
                throw new DatabaseConnectionException("JDBC URL\u4e3a\u7a7a");
            }
            String jdbcUser = databaseConnection.getJdbcUser();
            if (Strings.isNullOrEmpty((String)jdbcUser)) {
                throw new DatabaseConnectionException("\u6570\u636e\u5e93\u7528\u6237\u540d\u4e3a\u7a7a");
            }
            String jdbcPassword = databaseConnection.getJdbcPassword();
            if (Strings.isNullOrEmpty((String)jdbcPassword)) {
                throw new DatabaseConnectionException("\u6570\u636e\u5e93\u5bc6\u7801\u4e3a\u7a7a");
            }
            Class<?> jdbcDriverClass = Class.forName(databaseConnection.getJdbcDriver());
            DriverManager.registerDriver((Driver)jdbcDriverClass.newInstance());
            try (Connection connection = DriverManager.getConnection(jdbcUrl, jdbcUser, jdbcPassword);){
                boolean bl = !connection.isClosed();
                return bl;
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new DatabaseConnectionException(String.format("JDBC\u9a71\u52a8\u3010%s\u3011\u672a\u627e\u5230", databaseConnection.getJdbcDriver()), (Throwable)ex);
        }
        catch (SQLException ex) {
            throw new DatabaseConnectionException("\u6570\u636e\u5e93\u8fde\u63a5\u9519\u8bef", (Throwable)ex);
        }
    }

    public DatabaseConnection insert(DatabaseConnection databaseConnection) {
        this.connectionRepository.saveAndFlush((Object)databaseConnection);
        this.coordinationService.updateShardByAll(databaseConnection.getName(), Long.valueOf(this.coordinationService.getNextVersion()));
        return databaseConnection;
    }

    public DatabaseConnection get(String name) {
        return (DatabaseConnection)this.connectionRepository.findOne((Serializable)((Object)name));
    }

    public List<DatabaseConnection> list() {
        return this.connectionRepository.findAll();
    }

    public Page<DatabaseConnection> list(Pageable pageable) {
        return this.connectionRepository.findAll(pageable);
    }

    public void update(DatabaseConnection databaseConnection) {
        this.connectionRepository.saveAndFlush((Object)databaseConnection);
        this.coordinationService.updateShardByAll(databaseConnection.getName(), Long.valueOf(this.coordinationService.getNextVersion()));
    }

    public void delete(String name) {
        this.connectionRepository.delete((Serializable)((Object)name));
        this.coordinationService.deleteShardByAll(name);
    }

    public Page<String> listDatabaseTables(String databaseConnectionName, Pageable pageable) {
        this.entityMetaService.bootstrapIfNeeded();
        LinkedList tables = new LinkedList();
        boolean ignorePage = pageable == null;
        try (Session session = this.entityMetaService.getSessionFactory(databaseConnectionName).openSession();){
            session.doWork(connection -> {
                ResultSet resultSet = connection.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
                int start = ignorePage ? 0 : pageable.getOffset();
                int limit = ignorePage ? Integer.MAX_VALUE : start + pageable.getPageSize();
                int row = 0;
                while (resultSet.next()) {
                    if (start <= row && row < limit) {
                        tables.add(resultSet.getString("TABLE_NAME"));
                    }
                    ++row;
                }
                tables.add(String.format("%d", row));
            });
        }
        if (ignorePage) {
            return new PageImpl(tables);
        }
        String total = (String)tables.removeLast();
        return new PageImpl(tables, pageable, Long.parseLong(total));
    }

    public List<EntityFieldMeta> listTableFields(String databaseConnectionName, String tableName) {
        if (!tableName.matches("^[\\w_][\\w_\\d]{0,32}$")) {
            return Collections.emptyList();
        }
        this.entityMetaService.bootstrapIfNeeded();
        LinkedList<EntityFieldMeta> fieldMetas = new LinkedList<EntityFieldMeta>();
        try (Session session = this.entityMetaService.getSessionFactory(databaseConnectionName).openSession();){
            session.doWork(connection -> {
                ResultSetMetaData metaData = connection.prepareStatement(String.format("select * from %s", tableName)).getMetaData();
                for (int column = metaData.getColumnCount(); column > 0; --column) {
                    EntityFieldMeta fieldMeta = new EntityFieldMeta();
                    String columnName = metaData.getColumnName(column);
                    if (EntityFieldMeta.RESERVED_FIELDS.stream().anyMatch(columnName::equalsIgnoreCase)) continue;
                    fieldMeta.setName(columnName);
                    fieldMeta.setColumnName(columnName);
                    String type = metaData.getColumnTypeName(column).toLowerCase();
                    String temporalType = null;
                    if (type.matches(".*(char|text|clob).*")) {
                        type = "string";
                    } else if (type.matches(".*int.*")) {
                        type = "integer";
                    } else if (type.matches(".*(bit|bool).*")) {
                        type = "boolean";
                    } else if (type.matches(".*(num|dec).*")) {
                        type = "float";
                    } else if (type.matches(".*time.*")) {
                        type = "timestamp";
                        temporalType = "timestamp";
                    } else if (type.matches(".*date.*")) {
                        type = "date";
                        temporalType = "date";
                    }
                    fieldMeta.setType(type);
                    fieldMeta.setTemporalType(temporalType);
                    fieldMetas.addFirst(fieldMeta);
                }
            });
        }
        return fieldMetas;
    }
}

