/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.common.http.result.PageResult;
import cn.gtmap.gtc.model.domain.entity.EntityFieldMeta;
import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.DatabaseMetaService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DatabaseMetaServicePeerImpl
implements DatabaseMetaService {
    private final CoordinationService coordinationService;
    private final ObjectMapper objectMapper;
    private final HttpClient httpClient;

    @Autowired
    public DatabaseMetaServicePeerImpl(CoordinationService coordinationService, ObjectMapper objectMapper, HttpClient httpClient) {
        this.coordinationService = coordinationService;
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
    }

    public Page<String> listDatabaseTables(String databaseConnectionName, Pageable pageable) {
        try {
            String peerLocation = this.getPeerLocation(databaseConnectionName);
            HttpGet httpRequest = this.prepareRequest(peerLocation, pageable);
            return this.doRequest((HttpRequestBase)httpRequest, String.class).toPage();
        }
        catch (IOException | URISyntaxException ex) {
            throw new EntityCrudException(ex.getMessage());
        }
    }

    public List<EntityFieldMeta> listTableFields(String databaseConnectionName, String tableName) {
        try {
            String peerLocation = String.format("%s/%s/fields", this.getPeerLocation(databaseConnectionName), tableName);
            HttpGet httpRequest = this.prepareRequest(peerLocation, null);
            return (List)this.doRequest((HttpRequestBase)httpRequest, EntityFieldMeta.class).getData();
        }
        catch (IOException | URISyntaxException ex) {
            throw new EntityCrudException(ex.getMessage());
        }
    }

    private HttpGet prepareRequest(String location, Pageable pageable) throws URISyntaxException {
        if (pageable != null) {
            location = location + String.format("?page=%d&size=%d", pageable.getPageNumber(), pageable.getPageSize());
        }
        HttpGet httpGet = new HttpGet(new URI(location));
        httpGet.setHeader("Peer-Redirected", "true");
        return httpGet;
    }

    private <T> PageResult<T> doRequest(HttpRequestBase httpRequest, Class<T> itemClass) throws IOException {
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
        PageResult result = (PageResult)this.objectMapper.readValue(httpResponse.getEntity().getContent(), PageResult.class);
        List elements = ((List)result.getData()).stream().map(element -> {
            try {
                return this.objectMapper.readValue(this.objectMapper.writeValueAsString(element), itemClass);
            }
            catch (IOException ex) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        PageResult pageResult = new PageResult();
        pageResult.setData(elements);
        pageResult.setMeta(result.getMeta());
        return pageResult;
    }

    private String getPeerLocation(String databaseConnectionName) {
        String peerLocation = this.coordinationService.getPeerLocation(databaseConnectionName);
        if (peerLocation == null) {
            throw new EntityCrudException("\u6ca1\u6709\u53ef\u7528\u7684\u8282\u70b9");
        }
        return String.format("%s/v1/database-connections/%s/tables", peerLocation, databaseConnectionName);
    }
}

