/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.service.CoordinationService;
import cn.gtmap.gtc.model.service.EntityMetaService;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.discovery.shared.Application;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpEntity;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.client.RestTemplate;

@Service(value="localCoordinator")
public class CoordinationServiceImpl
implements CoordinationService,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CoordinationServiceImpl.class);
    private EntityMetaService entityMetaService;
    private ApplicationContext applicationContext;
    private final EurekaClient eurekaClient;
    private final RestTemplate restTemplate;
    private final String appName;

    @Autowired
    public CoordinationServiceImpl(EurekaClient eurekaClient, RestTemplate restTemplate, @Value(value="${spring.application.name}") String appName) {
        this.eurekaClient = eurekaClient;
        this.restTemplate = restTemplate;
        this.appName = appName;
        eurekaClient.registerEventListener(event -> {
            if (event instanceof StatusChangeEvent && ((StatusChangeEvent)event).isUp()) {
                this.reBalance();
            }
        });
    }

    public boolean canHandle(String shardName) {
        InstanceInfo self = this.eurekaClient.getApplicationInfoManager().getInfo();
        Long selfShardVersion = this.getInstanceShardVersion(self, shardName);
        if (selfShardVersion <= 0L) {
            return false;
        }
        boolean anyOther = this.eurekaClient.getApplication(this.appName).getInstances().stream().anyMatch(instanceInfo -> this.getInstanceShardVersion(instanceInfo, shardName) > selfShardVersion);
        return !anyOther;
    }

    public List<String> listLocalHandledDatabaseConnectionNames() {
        return this.eurekaClient.getApplicationInfoManager().getInfo().getMetadata().entrySet().stream().filter(entry -> !Strings.isNullOrEmpty((String)((String)entry.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public String getPeerLocation(String shardName) {
        InstanceInfo self = this.eurekaClient.getApplicationInfoManager().getInfo();
        List instances = this.eurekaClient.getApplication(this.appName).getInstances();
        List candidates = instances.stream().filter(instanceInfo -> this.getInstanceShardVersion(instanceInfo, shardName) > 0L).collect(Collectors.toList());
        InstanceInfo elected = candidates.isEmpty() ? this.electForShardFromInstances(shardName, Long.valueOf(this.getNextVersion()), (Collection)instances, self) : (candidates.size() == 1 ? (InstanceInfo)candidates.get(0) : this.electForShardFromCandidates(shardName, candidates, self));
        return this.getInstanceBaseUrl(elected);
    }

    @Retryable
    public void updateShardByAll(String shardName, Long version) {
        InstanceInfo self = this.eurekaClient.getApplicationInfoManager().getInfo();
        Application application = this.eurekaClient.getApplication(this.appName);
        List instances = application.getInstances();
        this.electForShardFromInstances(shardName, version, (Collection)instances, self);
    }

    @Retryable
    public void deleteShardByAll(String shardName) {
        InstanceInfo self = this.eurekaClient.getApplicationInfoManager().getInfo();
        Application application = this.eurekaClient.getApplication(this.appName);
        String selfId = self.getId();
        List<InstanceInfo> instances = application.getInstances().stream().filter(instanceInfo -> this.getInstanceShardVersion(instanceInfo, shardName) > 0L).collect(Collectors.toList());
        if (instances.removeIf(instanceInfo -> selfId.equals(instanceInfo.getId()))) {
            this.deleteShardBySelf(shardName);
        }
        instances.forEach(instanceInfo -> this.deleteShardByPeer(shardName, instanceInfo));
    }

    public void updateShardBySelf(String shardName, Long version) {
        this.eurekaClient.getApplicationInfoManager().registerAppMetadata(Collections.singletonMap(shardName, version.toString()));
        this.getEntityMetaService().refresh();
    }

    public void deleteShardBySelf(String shardName) {
        this.eurekaClient.getApplicationInfoManager().registerAppMetadata(Collections.singletonMap(shardName, ""));
    }

    public long getNextVersion() {
        return new Date().getTime();
    }

    @Async
    protected ListenableFuture<Boolean> updateShardByPeer(String shardName, Long version, InstanceInfo peer) {
        boolean success = true;
        try {
            String uri = this.getInstanceBaseUrl(peer) + "/shards/{shardName}?version={version}";
            this.restTemplate.put(uri, (Object)HttpEntity.EMPTY, (Map)ImmutableMap.builder().put((Object)"shardName", (Object)shardName).put((Object)"version", (Object)version.toString()).build());
        }
        catch (RuntimeException ex) {
            success = false;
        }
        return new AsyncResult((Object)success);
    }

    @Async
    protected void deleteShardByPeer(String shardName, InstanceInfo peer) {
        this.restTemplate.delete(this.getInstanceBaseUrl(peer) + "/shards/{shardName}", Collections.singletonMap("shardName", shardName));
    }

    @Scheduled(initialDelayString="${app.sharding.rebalance.initialDelay:900000}", fixedDelayString="${app.sharding.rebalance.fixedDelay:900000}")
    protected void reBalance() {
        int SHARDS_THRESHOLD = 2;
        int TWICE = 2;
        InstanceInfo selfInstance = this.eurekaClient.getApplicationInfoManager().getInfo();
        String selfInstanceId = selfInstance.getId();
        if (Strings.isNullOrEmpty((String)selfInstanceId)) {
            throw new EntityCrudException("\u8282\u70b9\u4fe1\u606f\u6709\u8bef");
        }
        List instances = this.eurekaClient.getApplication(this.appName).getInstances();
        if (instances.isEmpty()) {
            return;
        }
        HashMap<String, Long> shardVersions = new HashMap<String, Long>();
        for (InstanceInfo instance2 : instances) {
            for (String shardName2 : instance2.getMetadata().keySet()) {
                Long oldVersion = shardVersions.getOrDefault(shardName2, Long.MIN_VALUE);
                Long version = this.getInstanceShardVersion(instance2, shardName2);
                if (version <= oldVersion || version <= 0L) continue;
                shardVersions.put(shardName2, version);
            }
        }
        if (shardVersions.size() < 2) {
            return;
        }
        List instanceAndShardCountPairs = instances.stream().map(instance -> Pair.of((Object)instance, (Object)instance.getMetadata().keySet().stream().filter(shardName -> shardVersions.getOrDefault(shardName, Long.MAX_VALUE).equals(this.getInstanceShardVersion(instance, shardName))).count())).collect(Collectors.toList());
        Long maxShardCount = instanceAndShardCountPairs.stream().map(Pair::getValue).max(Long::compareTo).orElse(0L);
        Long selfShardCount = (Long)instanceAndShardCountPairs.stream().filter(pair -> selfInstanceId.equals(((InstanceInfo)pair.getKey()).getId())).findAny().orElse(Pair.of((Object)selfInstance, (Object)0L)).getValue();
        if (maxShardCount - selfShardCount < 2L) {
            return;
        }
        InstanceInfo heavyLoadInstance = instanceAndShardCountPairs.stream().filter(pair -> ((Long)pair.getValue()).equals(maxShardCount)).map(Pair::getKey).findAny().orElse(null);
        if (heavyLoadInstance == null) {
            return;
        }
        List shardNames = heavyLoadInstance.getMetadata().keySet().stream().filter(shardName -> shardVersions.getOrDefault(shardName, Long.MAX_VALUE).equals(this.getInstanceShardVersion(heavyLoadInstance, shardName))).collect(Collectors.toList());
        for (int i = (int)(maxShardCount - selfShardCount) / 2; i > 0; --i) {
            String shardName3 = (String)shardNames.get(i * 2 - 1);
            this.updateShardBySelf(shardName3, Long.valueOf(this.getNextVersion()));
            this.deleteShardByPeer(shardName3, heavyLoadInstance);
        }
    }

    private InstanceInfo electForShardFromInstances(String shardName, Long version, Collection<InstanceInfo> instances, InstanceInfo self) {
        InstanceInfo elected;
        String selfId = self.getId();
        if (selfId.equals((elected = (InstanceInfo)instances.stream().map(instanceInfo -> Pair.of((Object)instanceInfo, (Object)instanceInfo.getMetadata().values().stream().filter(value -> !Strings.isNullOrEmpty((String)value)).count())).min((left, right) -> {
            int diff = ((Long)left.getValue()).compareTo((Long)right.getValue());
            if (diff == 0) {
                if (selfId.equals(((InstanceInfo)left.getKey()).getId())) {
                    return -1;
                }
                if (selfId.equals(((InstanceInfo)right.getKey()).getId())) {
                    return 1;
                }
            }
            return diff;
        }).orElse(Pair.of((Object)self, (Object)0L)).getKey()).getId())) {
            this.updateShardBySelf(shardName, version);
        } else {
            ListenableFuture future = this.updateShardByPeer(shardName, version, elected);
            try {
                future.get();
            }
            catch (Exception ex) {
                throw new EntityCrudException(ex.getMessage());
            }
        }
        return elected;
    }

    private InstanceInfo electForShardFromCandidates(String shardName, Collection<InstanceInfo> candidates, InstanceInfo self) {
        InstanceInfo elected = candidates.stream().max(Comparator.comparing(instanceInfo -> this.getInstanceShardVersion(instanceInfo, shardName))).orElseThrow(() -> new EntityCrudException("\u5019\u9009\u670d\u52a1\u8282\u70b9\u4e3a\u7a7a"));
        long version = this.getInstanceShardVersion(elected, shardName);
        List<InstanceInfo> others = candidates.stream().filter(instanceInfo -> version != this.getInstanceShardVersion(instanceInfo, shardName)).collect(Collectors.toList());
        if (others.removeIf(instanceInfo2 -> self.getId().equals(instanceInfo2.getId()))) {
            this.deleteShardBySelf(shardName);
        }
        if (!others.isEmpty()) {
            others.forEach(other -> this.deleteShardByPeer(shardName, other));
        }
        return elected;
    }

    private String getInstanceBaseUrl(InstanceInfo instanceInfo) {
        return instanceInfo.getHomePageUrl().replaceFirst("\\/$", "");
    }

    private Long getInstanceShardVersion(InstanceInfo instanceInfo, String shardName) {
        String versionString = instanceInfo.getMetadata().getOrDefault(shardName, null);
        return Strings.isNullOrEmpty((String)versionString) ? 0L : Long.parseLong(versionString);
    }

    private EntityMetaService getEntityMetaService() {
        if (this.entityMetaService == null) {
            if (this.applicationContext == null) {
                throw new EntityCrudException("\u65e0\u6cd5\u83b7\u53d6EntityMetaService");
            }
            this.entityMetaService = (EntityMetaService)this.applicationContext.getBean(EntityMetaService.class);
        }
        return this.entityMetaService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

