/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.service;

import cn.gtmap.gtc.model.exception.EntityCrudException;
import cn.gtmap.gtc.model.exception.PeerUnreachableException;
import cn.gtmap.gtc.model.service.AbstractPeerService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class AbstractPeerService {
    protected abstract ObjectMapper getObjectMapper();

    protected abstract HttpClient getHttpClient();

    protected <T> Optional<T> request(RequestMethod requestMethod, String location, Class<T> responseClass) {
        return this.request(requestMethod, location, null, null, responseClass);
    }

    protected <T> Optional<T> request(RequestMethod requestMethod, String location, String requestBody, Class<T> responseClass) {
        return this.request(requestMethod, location, null, requestBody, responseClass);
    }

    protected <T> Optional<T> request(RequestMethod requestMethod, String location, Collection<Pair<String, Object>> queryParams, Class<T> responseClass) {
        return this.request(requestMethod, location, queryParams, null, responseClass);
    }

    protected <T> Optional<T> request(RequestMethod requestMethod, String location, Collection<Pair<String, Object>> queryParams, String requestBody, Class<T> responseClass) {
        try {
            HttpGet httpRequestBase = null;
            HttpPost httpEntityEnclosingRequest = null;
            URI uri = this.getURI(location, queryParams);
            switch (1.$SwitchMap$org$springframework$web$bind$annotation$RequestMethod[requestMethod.ordinal()]) {
                case 1: {
                    httpEntityEnclosingRequest = new HttpPost(uri);
                    break;
                }
                case 2: {
                    httpEntityEnclosingRequest = new HttpPut(uri);
                    break;
                }
                case 3: {
                    httpEntityEnclosingRequest = new HttpPatch(uri);
                    break;
                }
                case 4: {
                    httpRequestBase = new HttpGet(uri);
                    break;
                }
                case 5: {
                    httpRequestBase = new HttpDelete(uri);
                    break;
                }
            }
            if (httpRequestBase != null) {
                this.prepareRequest((HttpRequestBase)httpRequestBase);
            }
            if (httpEntityEnclosingRequest != null) {
                this.prepareRequest((HttpEntityEnclosingRequestBase)httpEntityEnclosingRequest, requestBody);
                httpRequestBase = httpEntityEnclosingRequest;
            }
            return this.doRequest((HttpRequestBase)httpRequestBase, responseClass);
        }
        catch (HttpHostConnectException ex) {
            throw new PeerUnreachableException(ex.getMessage());
        }
        catch (IOException | URISyntaxException ex) {
            throw new EntityCrudException(ex.getMessage());
        }
    }

    protected URI getURI(String location, Collection<Pair<String, Object>> queryParams) throws URISyntaxException {
        URI uri = new URI(location);
        if (queryParams == null || queryParams.isEmpty()) {
            return uri;
        }
        String query = queryParams.stream().map(pair -> String.format("%s=%s", pair.getKey(), pair.getValue().toString())).reduce((queries, thisQuery) -> String.format("%s&%s", queries, thisQuery)).orElse(null);
        return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
    }

    protected void prepareRequest(HttpRequestBase httpRequest) {
        httpRequest.setHeader("Peer-Redirected", "true");
    }

    protected void prepareRequest(HttpEntityEnclosingRequestBase httpRequest, String requestBody) {
        this.prepareRequest((HttpRequestBase)httpRequest);
        httpRequest.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
    }

    protected <T> Optional<T> doRequest(HttpRequestBase httpRequest, Class<T> responseClass) throws IOException {
        HttpResponse httpResponse = this.getHttpClient().execute((HttpUriRequest)httpRequest);
        if (responseClass.equals(Void.class)) {
            return Optional.empty();
        }
        Object result = this.getObjectMapper().readValue(httpResponse.getEntity().getContent(), responseClass);
        return result == null ? Optional.empty() : Optional.of(result);
    }

    protected List<Pair<String, Object>> getPairsFromPageable(Pageable pageable) {
        LinkedList<Pair<String, Object>> pairs = new LinkedList<Pair<String, Object>>();
        if (null == pageable) {
            return pairs;
        }
        pairs.add((Pair<String, Object>)Pair.of((Object)"size", (Object)pageable.getPageSize()));
        pairs.add((Pair<String, Object>)Pair.of((Object)"page", (Object)pageable.getPageNumber()));
        Sort sort = pageable.getSort();
        if (null == sort) {
            return pairs;
        }
        for (Sort.Order order : sort) {
            pairs.add((Pair<String, Object>)Pair.of((Object)"sort", (Object)String.format("%s,%s", order.getProperty(), order.isAscending() ? "asc" : "desc")));
        }
        return pairs;
    }
}

