/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.gtc.model.domain.helpers;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import javax.persistence.Id;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityHelper {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    private EntityHelper() {
    }

    public static Serializable readIdOf(Object entity) throws NoSuchFieldException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        String getterName;
        Optional fieldOptional = EntityHelper.findIdField((Object)entity);
        if (!fieldOptional.isPresent()) {
            throw new NoSuchFieldException("no id field found");
        }
        Class<?> entityClass = entity.getClass();
        Object id = entityClass.getMethod(getterName = EntityHelper.getterNameFromFieldName((String)((Field)fieldOptional.get()).getName()), new Class[0]).invoke(entity, new Object[0]);
        return id instanceof Serializable ? (Serializable)id : null;
    }

    public static <T> void writeIdOf(Object entity, T value) throws NoSuchFieldException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Optional fieldOptional = EntityHelper.findIdField((Object)entity);
        if (!fieldOptional.isPresent()) {
            throw new NoSuchFieldException("no id field found");
        }
        String fieldName = ((Field)fieldOptional.get()).getName();
        Class<?> entityClass = entity.getClass();
        Class<?> fieldType = entityClass.getDeclaredField(fieldName).getType();
        String setterName = EntityHelper.setterNameFromFieldName((String)fieldName);
        entityClass.getMethod(setterName, fieldType).invoke(entity, value);
    }

    public static void clearEmptyIdOf(Object entity) {
        EntityHelper.clearEmptyIdOf((Object)entity, (int)0);
    }

    public static Object readFieldOf(Object entity, String fieldName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = entity.getClass().getMethod(EntityHelper.getterNameFromFieldName((String)fieldName), new Class[0]);
        return method.invoke(entity, new Object[0]);
    }

    public static <T> void writeFieldOf(Object entity, String fieldName, T fieldValue) throws NoSuchMethodException, NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Class<?> entityClass = entity.getClass();
        Class<?> fieldType = entityClass.getDeclaredField(fieldName).getType();
        entityClass.getMethod(EntityHelper.setterNameFromFieldName((String)fieldName), fieldType).invoke(entity, fieldValue);
    }

    public static String getterNameFromFieldName(String fieldName) {
        return "get" + EntityHelper.toFirstUpperCase((String)fieldName);
    }

    public static String setterNameFromFieldName(String fieldName) {
        return "set" + EntityHelper.toFirstUpperCase((String)fieldName);
    }

    public static Optional<Field> findIdField(Object entity) {
        return Arrays.stream(entity.getClass().getDeclaredFields()).filter(field -> field.getAnnotation(Id.class) != null).findFirst();
    }

    private static String fieldNameFromMethodName(String methodName) {
        if (methodName.startsWith("get")) {
            return String.format("%s%s%s", "set", methodName.substring(0, 1).toLowerCase(), methodName.substring("get".length() + 1));
        }
        if (methodName.startsWith("set")) {
            return String.format("%s%s%s", "get", methodName.substring(0, 1).toLowerCase(), methodName.substring("set".length() + 1));
        }
        return methodName;
    }

    private static void clearEmptyIdOf(Object entity, int level) {
        if (level < 0 || level > 5 || !EntityHelper.isEntity((Object)entity)) {
            return;
        }
        Optional idFieldOptional = EntityHelper.findIdField((Object)entity);
        if (!idFieldOptional.isPresent()) {
            return;
        }
        Field idField = (Field)idFieldOptional.get();
        EntityHelper.setNullIfEmptyString((Object)entity, (Field)idField);
        Arrays.stream(entity.getClass().getDeclaredFields()).filter(field2 -> idField != field2).forEach(field -> EntityHelper.clearEmptyIdOfField((Object)entity, (Field)field, (int)(level + 1)));
    }

    private static void setNullIfEmptyString(Object entity, Field field) {
        if (!String.class.isAssignableFrom(field.getType())) {
            return;
        }
        try {
            field.setAccessible(true);
            if ("".equals(field.get(entity))) {
                field.set(entity, null);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void clearEmptyIdOfField(Object entity, Field field, int level) {
        try {
            field.setAccessible(true);
            Object fieldValue = field.get(entity);
            if (null == fieldValue) {
                return;
            }
            if (Collection.class.isAssignableFrom(field.getType())) {
                Collection collection = (Collection)fieldValue;
                for (Object item : collection) {
                    EntityHelper.clearEmptyIdOf(item, (int)level);
                }
            } else {
                EntityHelper.clearEmptyIdOf((Object)fieldValue, (int)level);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static boolean isEntity(Object object) {
        if (null == object) {
            return false;
        }
        return object.getClass().getName().startsWith("cn.gtmap.dynamic.entity");
    }

    private static String toFirstUpperCase(String str) {
        char[] chars = new char[str.length()];
        str.getChars(1, str.length(), chars, 1);
        str.substring(0, 1).toUpperCase().getChars(0, 1, chars, 0);
        return new String(chars);
    }
}

